/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache.alluxio;

import alluxio.client.file.FileInStream;
import alluxio.exception.ExceptionMessage;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;

public class AlluxioCachingHdfsFileInputStream
extends InputStream
implements Seekable,
PositionedReadable {
    private final FileInStream inputStream;

    public AlluxioCachingHdfsFileInputStream(FileInStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        return this.inputStream.positionedRead(position, buffer, offset, length);
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        int bytesRead;
        for (int totalBytesRead = 0; totalBytesRead < length; totalBytesRead += bytesRead) {
            bytesRead = this.read(position + (long)totalBytesRead, buffer, offset + totalBytesRead, length - totalBytesRead);
            if (bytesRead != -1) continue;
            throw new EOFException();
        }
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        this.readFully(position, buffer, 0, buffer.length);
    }

    public void seek(long position) throws IOException {
        this.inputStream.seek(position);
    }

    public long getPos() throws IOException {
        return this.inputStream.getPos();
    }

    public boolean seekToNewSource(long target) throws IOException {
        throw new IOException(ExceptionMessage.NOT_SUPPORTED.getMessage(new Object[0]));
    }
}

