/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache.alluxio;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import io.airlift.units.DataSize;

public class AlluxioCacheConfig {
    private boolean metricsCollectionEnabled = true;
    private boolean asyncWriteEnabled;
    private String jmxClass = "alluxio.metrics.sink.JmxSink";
    private String metricsDomain = "com.facebook.alluxio";
    private DataSize maxCacheSize = new DataSize(2.0, DataSize.Unit.GIGABYTE);

    public boolean isMetricsCollectionEnabled() {
        return this.metricsCollectionEnabled;
    }

    @Config(value="cache.alluxio.metrics.enabled")
    public AlluxioCacheConfig setMetricsCollectionEnabled(boolean metricsCollectionEnabled) {
        this.metricsCollectionEnabled = metricsCollectionEnabled;
        return this;
    }

    public String getJmxClass() {
        return this.jmxClass;
    }

    @Config(value="cache.alluxio.jmx.class")
    public AlluxioCacheConfig setJmxClass(String jmxClass) {
        this.jmxClass = jmxClass;
        return this;
    }

    public String getMetricsDomain() {
        return this.metricsDomain;
    }

    @Config(value="cache.alluxio.metrics.domain")
    public AlluxioCacheConfig setMetricsDomain(String metricsDomain) {
        this.metricsDomain = metricsDomain;
        return this;
    }

    public boolean isAsyncWriteEnabled() {
        return this.asyncWriteEnabled;
    }

    @Config(value="cache.alluxio.async-write.enabled")
    public AlluxioCacheConfig setAsyncWriteEnabled(boolean asyncWriteEnabled) {
        this.asyncWriteEnabled = asyncWriteEnabled;
        return this;
    }

    public DataSize getMaxCacheSize() {
        return this.maxCacheSize;
    }

    @Config(value="cache.alluxio.max-cache-size")
    @ConfigDescription(value="The maximum cache size")
    public AlluxioCacheConfig setMaxCacheSize(DataSize maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
        return this;
    }
}

