/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache;

import com.facebook.presto.cache.CacheManager;
import com.facebook.presto.cache.CachingInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

public final class CachingFileSystem
extends FileSystem {
    private final URI workingDirectory;
    private final CacheManager cacheManager;
    private final FileSystem dataTier;
    private final boolean cacheValidationEnabled;

    public CachingFileSystem(URI workingDirectory, Configuration configuration, CacheManager cacheManager, FileSystem dataTier, boolean cacheValidationEnabled) {
        Objects.requireNonNull(workingDirectory, "uri is null");
        Objects.requireNonNull(configuration, "configuration is null");
        this.workingDirectory = URI.create(workingDirectory.getScheme() + "://" + workingDirectory.getAuthority());
        this.cacheManager = Objects.requireNonNull(cacheManager, "cacheManager is null");
        this.dataTier = Objects.requireNonNull(dataTier, "dataTier is null");
        this.cacheValidationEnabled = cacheValidationEnabled;
        this.setConf(configuration);
        this.statistics = CachingFileSystem.getStatistics((String)workingDirectory.getScheme(), ((Object)((Object)this)).getClass());
    }

    public void initialize(URI uri, Configuration configuration) {
        throw new UnsupportedOperationException();
    }

    public URI getUri() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(Path workingDirectory) {
        this.dataTier.setWorkingDirectory(workingDirectory);
    }

    public Path getWorkingDirectory() {
        return this.dataTier.getWorkingDirectory();
    }

    public boolean mkdirs(Path path, FsPermission permission) throws IOException {
        return this.dataTier.mkdirs(path, permission);
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        return new CachingInputStream(this.dataTier.open(path, bufferSize), this.cacheManager, path, this.cacheValidationEnabled);
    }

    public FSDataOutputStream create(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.dataTier.create(path, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream append(Path path, int bufferSize, Progressable progress) throws IOException {
        return this.dataTier.append(path, bufferSize, progress);
    }

    public boolean rename(Path source, Path destination) throws IOException {
        return this.dataTier.rename(source, destination);
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        return this.dataTier.delete(path, recursive);
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        return this.dataTier.listStatus(path);
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        return this.dataTier.getFileStatus(path);
    }
}

