/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.expression;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.ConstantBytecodeExpression;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;

class InvokeDynamicBytecodeExpression
extends BytecodeExpression {
    private final Method bootstrapMethod;
    private final List<Object> bootstrapArgs;
    private final String methodName;
    private final ParameterizedType returnType;
    private final List<BytecodeExpression> parameters;
    private final List<ParameterizedType> parameterTypes;

    InvokeDynamicBytecodeExpression(Method bootstrapMethod, Iterable<?> bootstrapArgs, String methodName, ParameterizedType returnType, Iterable<? extends BytecodeExpression> parameters, Iterable<ParameterizedType> parameterTypes) {
        super(returnType);
        this.bootstrapMethod = Objects.requireNonNull(bootstrapMethod, "bootstrapMethod is null");
        this.bootstrapArgs = ImmutableList.copyOf(Objects.requireNonNull(bootstrapArgs, "bootstrapArgs is null"));
        this.methodName = Objects.requireNonNull(methodName, "methodName is null");
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
        this.parameters = ImmutableList.copyOf(Objects.requireNonNull(parameters, "parameters is null"));
        this.parameterTypes = ImmutableList.copyOf(Objects.requireNonNull(parameterTypes, "parameterTypes is null"));
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        BytecodeBlock block = new BytecodeBlock();
        for (BytecodeExpression parameter : this.parameters) {
            block.append(parameter);
        }
        return block.invokeDynamic(this.methodName, this.returnType, this.parameterTypes, this.bootstrapMethod, this.bootstrapArgs);
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    @Override
    protected String formatOneLine() {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(this.bootstrapMethod.getName());
        if (!this.bootstrapArgs.isEmpty()) {
            builder.append("(").append(Joiner.on((String)", ").join(this.bootstrapArgs.stream().map(ConstantBytecodeExpression::renderConstant).iterator())).append(")");
        }
        builder.append("]=>");
        builder.append(this.methodName).append("(").append(Joiner.on((String)", ").join(this.parameters)).append(")");
        return builder.toString();
    }
}

