/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.bigquery;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class BigQueryTableHandle
implements ConnectorTableHandle {
    private final String projectId;
    private final String schemaName;
    private final String tableName;
    private final String type;
    private final TupleDomain<ColumnHandle> constraint;
    private final Optional<List<ColumnHandle>> projectedColumns;
    private final OptionalLong limit;

    @JsonCreator
    public BigQueryTableHandle(@JsonProperty(value="projectId") String projectId, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="type") String type, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint, @JsonProperty(value="projectedColumns") Optional<List<ColumnHandle>> projectedColumns, @JsonProperty(value="limit") OptionalLong limit) {
        this.projectId = Objects.requireNonNull(projectId, "projectId is null");
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
        this.projectedColumns = Objects.requireNonNull(projectedColumns, "projectedColumns is null");
        this.limit = Objects.requireNonNull(limit, "limit is null");
    }

    public static BigQueryTableHandle from(TableInfo tableInfo) {
        TableId tableId = tableInfo.getTableId();
        String type = tableInfo.getDefinition().getType().toString();
        return new BigQueryTableHandle(tableId.getProject(), tableId.getDataset(), tableId.getTable(), type, (TupleDomain<ColumnHandle>)TupleDomain.none(), Optional.empty(), OptionalLong.empty());
    }

    @JsonProperty
    public String getProjectId() {
        return this.projectId;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }

    @JsonProperty
    public Optional<List<ColumnHandle>> getProjectedColumns() {
        return this.projectedColumns;
    }

    @JsonProperty
    public OptionalLong getLimit() {
        return this.limit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BigQueryTableHandle that = (BigQueryTableHandle)o;
        return Objects.equals(this.projectId, that.projectId) && Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.type, that.tableName) && Objects.equals(this.constraint, that.constraint) && Objects.equals(this.projectedColumns, that.projectedColumns) && Objects.equals(this.limit, that.limit);
    }

    public int hashCode() {
        return Objects.hash(this.projectId, this.schemaName, this.tableName, this.type, this.constraint, this.projectedColumns, this.limit);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("projectId", (Object)this.projectId).add("schemaName", (Object)this.schemaName).add("tableName", (Object)this.tableName).add("type", (Object)this.type).add("constraint", this.constraint).add("projectedColumns", this.projectedColumns).add("limit", (Object)this.limit).toString();
    }

    public TableId getTableId() {
        return TableId.of((String)this.projectId, (String)this.schemaName, (String)this.tableName);
    }

    BigQueryTableHandle withConstraint(TupleDomain<ColumnHandle> newConstraint) {
        return new BigQueryTableHandle(this.projectId, this.schemaName, this.tableName, this.type, newConstraint, this.projectedColumns, this.limit);
    }

    BigQueryTableHandle withProjectedColumns(List<ColumnHandle> newProjectedColumns) {
        return new BigQueryTableHandle(this.projectId, this.schemaName, this.tableName, this.type, this.constraint, Optional.of(newProjectedColumns), this.limit);
    }
}

