/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.bigquery;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DateTimeEncoding;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.TimeWithTimeZoneType;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.plugin.bigquery.BigQueryColumnHandle;
import com.facebook.presto.plugin.bigquery.BigQueryErrorCode;
import com.facebook.presto.plugin.bigquery.BigQueryException;
import com.facebook.presto.plugin.bigquery.BigQuerySplit;
import com.facebook.presto.plugin.bigquery.BigQueryStorageClientFactory;
import com.facebook.presto.plugin.bigquery.BigQueryTableHandle;
import com.facebook.presto.plugin.bigquery.BigQueryType;
import com.facebook.presto.plugin.bigquery.ReadRowsHelper;
import com.facebook.presto.spi.ConnectorPageSource;
import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageClient;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.avro.Conversions;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.util.Utf8;

public class BigQueryResultPageSource
implements ConnectorPageSource {
    static final AvroDecimalConverter DECIMAL_CONVERTER = new AvroDecimalConverter();
    private static final Logger log = Logger.get(BigQueryResultPageSource.class);
    private final BigQueryStorageClient bigQueryStorageClient;
    private final BigQuerySplit split;
    private final BigQueryTableHandle table;
    private final ImmutableList<BigQueryColumnHandle> columns;
    private final ImmutableList<Type> columnTypes;
    private final AtomicLong readBytes;
    private final PageBuilder pageBuilder;
    private Iterator<Storage.ReadRowsResponse> responses;
    private boolean closed;
    private long completedPositions;

    public BigQueryResultPageSource(BigQueryStorageClientFactory bigQueryStorageClientFactory, int maxReadRowsRetries, BigQuerySplit split, BigQueryTableHandle table, ImmutableList<BigQueryColumnHandle> columns) {
        this.bigQueryStorageClient = bigQueryStorageClientFactory.createBigQueryStorageClient();
        this.split = split;
        this.table = table;
        this.columns = columns;
        this.readBytes = new AtomicLong();
        this.columnTypes = (ImmutableList)columns.stream().map(BigQueryType.Adaptor::getPrestoType).collect(ImmutableList.toImmutableList());
        this.pageBuilder = new PageBuilder(this.columnTypes);
        log.debug("Starting to read from %s", new Object[]{split.getStreamName()});
        Storage.ReadRowsRequest.Builder readRowsRequest = Storage.ReadRowsRequest.newBuilder().setReadPosition(Storage.StreamPosition.newBuilder().setStream(Storage.Stream.newBuilder().setName(split.getStreamName())));
        this.responses = new ReadRowsHelper(this.bigQueryStorageClient, readRowsRequest, maxReadRowsRetries).readRows();
        this.closed = false;
    }

    public long getCompletedBytes() {
        return this.readBytes.get();
    }

    public long getCompletedPositions() {
        return this.completedPositions;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public boolean isFinished() {
        return !this.responses.hasNext();
    }

    public Page getNextPage() {
        Preconditions.checkState((boolean)this.pageBuilder.isEmpty(), (Object)"PageBuilder is not empty at the beginning of a new page");
        Storage.ReadRowsResponse response = this.responses.next();
        Iterable<GenericRecord> records = this.parse(response);
        for (GenericRecord record : records) {
            this.pageBuilder.declarePosition();
            for (int column = 0; column < this.columnTypes.size(); ++column) {
                BlockBuilder output = this.pageBuilder.getBlockBuilder(column);
                this.appendTo((Type)this.columnTypes.get(column), record.get(column), output);
            }
        }
        Page page = this.pageBuilder.build();
        this.completedPositions += (long)page.getPositionCount();
        this.pageBuilder.reset();
        return page;
    }

    private void appendTo(Type type, Object value, BlockBuilder output) {
        block8: {
            if (value == null) {
                output.appendNull();
                return;
            }
            Class javaType = type.getJavaType();
            try {
                if (javaType == Boolean.TYPE) {
                    type.writeBoolean(output, ((Boolean)value).booleanValue());
                    break block8;
                }
                if (javaType == Long.TYPE) {
                    this.writeLong(type, value, output, javaType);
                    break block8;
                }
                if (javaType == Double.TYPE) {
                    type.writeDouble(output, ((Number)value).doubleValue());
                    break block8;
                }
                if (javaType == Slice.class) {
                    this.writeSlice(output, type, value);
                    break block8;
                }
                if (javaType == Block.class) {
                    this.writeBlock(output, type, value);
                    break block8;
                }
                throw new BigQueryException(BigQueryErrorCode.BIGQUERY_UNSUPPORTED_COLUMN_TYPE, String.format("Unhandled type for %s: %s", javaType.getSimpleName(), type));
            }
            catch (ClassCastException exception) {
                throw new BigQueryException(BigQueryErrorCode.BIGQUERY_UNSUPPORTED_COLUMN_TYPE, "Not support type conversion for BigQuery data type: " + type, exception);
            }
        }
    }

    private void writeLong(Type type, Object value, BlockBuilder output, Class<?> javaType) {
        if (type.equals(BigintType.BIGINT)) {
            type.writeLong(output, ((Number)value).longValue());
        } else if (type.equals(IntegerType.INTEGER)) {
            type.writeLong(output, (long)((Number)value).intValue());
        } else if (type.equals(DateType.DATE)) {
            type.writeLong(output, (long)((Number)value).intValue());
        } else if (type.equals(TimestampType.TIMESTAMP)) {
            type.writeLong(output, BigQueryType.toPrestoTimestamp(((Utf8)value).toString()));
        } else if (type.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE) || type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) {
            type.writeLong(output, DateTimeEncoding.packDateTimeWithZone((long)((Long)value / 1000L), (TimeZoneKey)TimeZoneKey.UTC_KEY));
        } else {
            throw new BigQueryException(BigQueryErrorCode.BIGQUERY_UNSUPPORTED_TYPE_FOR_LONG, String.format("Unhandled type for %s: %s", javaType.getSimpleName(), type));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeSlice(BlockBuilder output, Type type, Object value) {
        if (type instanceof VarcharType) {
            type.writeSlice(output, Slices.utf8Slice((String)((Utf8)value).toString()));
            return;
        } else if (type instanceof DecimalType) {
            BigDecimal bdValue = DECIMAL_CONVERTER.convert(value);
            type.writeSlice(output, Decimals.encodeScaledValue((BigDecimal)bdValue, (int)9));
            return;
        } else {
            if (!(type instanceof VarbinaryType)) throw new BigQueryException(BigQueryErrorCode.BIGQUERY_UNSUPPORTED_TYPE_FOR_SLICE, "Unhandled type for Slice: " + type.getTypeSignature());
            if (!(value instanceof ByteBuffer)) throw new BigQueryException(BigQueryErrorCode.BIGQUERY_UNSUPPORTED_TYPE_FOR_VARBINARY, "Unhandled type for VarBinaryType: " + value.getClass());
            type.writeSlice(output, Slices.wrappedBuffer((ByteBuffer)((ByteBuffer)value)));
        }
    }

    private void writeBlock(BlockBuilder output, Type type, Object value) {
        if (type instanceof ArrayType && value instanceof List) {
            BlockBuilder builder = output.beginBlockEntry();
            for (Object element : (List)value) {
                this.appendTo((Type)type.getTypeParameters().get(0), element, builder);
            }
            output.closeEntry();
            return;
        }
        if (type instanceof RowType && value instanceof GenericRecord) {
            GenericRecord record = (GenericRecord)value;
            BlockBuilder builder = output.beginBlockEntry();
            ArrayList<String> fieldNames = new ArrayList<String>();
            for (int i = 0; i < type.getTypeSignature().getParameters().size(); ++i) {
                TypeSignatureParameter parameter = (TypeSignatureParameter)type.getTypeSignature().getParameters().get(i);
                fieldNames.add(parameter.getNamedTypeSignature().getName().orElse("field" + i));
            }
            Preconditions.checkState((fieldNames.size() == type.getTypeParameters().size() ? 1 : 0) != 0, (String)"fieldName doesn't match with type size : %s", (Object)type);
            for (int index = 0; index < type.getTypeParameters().size(); ++index) {
                this.appendTo((Type)type.getTypeParameters().get(index), record.get((String)fieldNames.get(index)), builder);
            }
            output.closeEntry();
            return;
        }
        throw new BigQueryException(BigQueryErrorCode.BIGQUERY_UNSUPPORTED_TYPE_FOR_BLOCK, "Unhandled type for Block: " + type.getTypeSignature());
    }

    public long getSystemMemoryUsage() {
        return 0L;
    }

    public void close() throws IOException {
        this.bigQueryStorageClient.close();
        this.closed = true;
    }

    Iterable<GenericRecord> parse(Storage.ReadRowsResponse response) {
        byte[] buffer = response.getAvroRows().getSerializedBinaryRows().toByteArray();
        this.readBytes.addAndGet(buffer.length);
        log.debug("Read %d bytes (total %d) from %s", new Object[]{buffer.length, this.readBytes.get(), this.split.getStreamName()});
        Schema avroSchema = new Schema.Parser().parse(this.split.getAvroSchema());
        return () -> new AvroBinaryIterator(avroSchema, buffer);
    }

    Stream<GenericRecord> toRecords(Storage.ReadRowsResponse response) {
        byte[] buffer = response.getAvroRows().getSerializedBinaryRows().toByteArray();
        this.readBytes.addAndGet(buffer.length);
        log.debug("Read %d bytes (total %d) from %s", new Object[]{buffer.length, this.readBytes.get(), this.split.getStreamName()});
        Schema avroSchema = new Schema.Parser().parse(this.split.getAvroSchema());
        Iterable responseRecords = () -> new AvroBinaryIterator(avroSchema, buffer);
        return StreamSupport.stream(responseRecords.spliterator(), false);
    }

    static class AvroDecimalConverter {
        private static final Conversions.DecimalConversion AVRO_DECIMAL_CONVERSION = new Conversions.DecimalConversion();
        private static final Schema AVRO_DECIMAL_SCHEMA = new Schema.Parser().parse(String.format("{\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":%d,\"scale\":%d}", 38, 9));

        AvroDecimalConverter() {
        }

        BigDecimal convert(Object value) {
            return AVRO_DECIMAL_CONVERSION.fromBytes((ByteBuffer)value, AVRO_DECIMAL_SCHEMA, AVRO_DECIMAL_SCHEMA.getLogicalType());
        }
    }

    static class AvroBinaryIterator
    implements Iterator<GenericRecord> {
        GenericDatumReader<GenericRecord> reader;
        BinaryDecoder decode;

        AvroBinaryIterator(Schema avroSchema, byte[] buffer) {
            this.reader = new GenericDatumReader(avroSchema);
            this.decode = new DecoderFactory().binaryDecoder(buffer, null);
        }

        @Override
        public boolean hasNext() {
            try {
                return !this.decode.isEnd();
            }
            catch (IOException e) {
                throw new BigQueryException(BigQueryErrorCode.BIGQUERY_ERROR_END_OF_AVRO_BUFFER, "Error determining the end of Avro buffer", e);
            }
        }

        @Override
        public GenericRecord next() {
            try {
                return (GenericRecord)this.reader.read(null, (Decoder)this.decode);
            }
            catch (IOException e) {
                throw new BigQueryException(BigQueryErrorCode.BIGQUERY_ERROR_READING_NEXT_AVRO_RECORD, "Error reading next Avro Record", e);
            }
        }
    }
}

