/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import java.util.Objects;
import java.util.Optional;

public class SemanticException
extends RuntimeException {
    private final SemanticErrorCode code;
    private final Optional<NodeLocation> location;
    private final String formattedMessage;

    public SemanticException(SemanticErrorCode code, String format, Object ... args) {
        this(code, Optional.empty(), format, args);
    }

    public SemanticException(SemanticErrorCode code, Node node, String format, Object ... args) {
        this(code, node == null ? Optional.empty() : node.getLocation(), format, args);
    }

    public SemanticException(SemanticErrorCode code, Optional<NodeLocation> location, String format, Object ... args) {
        this(code, null, location, format, args);
    }

    public SemanticException(SemanticErrorCode code, Throwable cause, Optional<NodeLocation> location, String format, Object ... args) {
        super(cause);
        this.code = Objects.requireNonNull(code, "code is null");
        this.location = Objects.requireNonNull(location, "location is null");
        Objects.requireNonNull(format, "format is null");
        this.formattedMessage = SemanticException.formatMessage(format, location, args);
    }

    @Override
    public String getMessage() {
        return this.formattedMessage;
    }

    public Optional<NodeLocation> getLocation() {
        return this.location;
    }

    public SemanticErrorCode getCode() {
        return this.code;
    }

    private static String formatMessage(String formatString, Optional<NodeLocation> location, Object[] args) {
        if (location.isPresent()) {
            NodeLocation nodeLocation = location.get();
            return String.format("line %s:%s: %s", nodeLocation.getLineNumber(), nodeLocation.getColumnNumber(), String.format(formatString, args));
        }
        return String.format(formatString, args);
    }
}

