/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.tree.Node;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nullable;

public class RelationId {
    @Nullable
    private final Node sourceNode;

    public static RelationId of(Node sourceNode) {
        return new RelationId(Objects.requireNonNull(sourceNode, "source cannot be null"));
    }

    public static RelationId anonymous() {
        return new RelationId(null);
    }

    private RelationId(Node sourceNode) {
        this.sourceNode = sourceNode;
    }

    public boolean isAnonymous() {
        return this.sourceNode == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationId that = (RelationId)o;
        return this.sourceNode != null && this.sourceNode == that.sourceNode;
    }

    public int hashCode() {
        return System.identityHashCode(this.sourceNode);
    }

    public String toString() {
        if (this.isAnonymous()) {
            return MoreObjects.toStringHelper((Object)this).addValue((Object)"anonymous").addValue((Object)String.format("x%08x", System.identityHashCode(this))).toString();
        }
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.sourceNode.getClass().getSimpleName()).addValue((Object)String.format("x%08x", System.identityHashCode(this.sourceNode))).toString();
    }
}

