/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.spi.MaterializedViewDefinition;
import com.facebook.presto.spi.analyzer.ViewDefinition;
import com.facebook.presto.sql.analyzer.TableColumnMetadata;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class MetadataHandle {
    private boolean preProcessMetadataCalls;
    private final Map<QualifiedObjectName, Future<Optional<ViewDefinition>>> viewDefinitions = new ConcurrentHashMap<QualifiedObjectName, Future<Optional<ViewDefinition>>>();
    private final Map<QualifiedObjectName, Future<Optional<MaterializedViewDefinition>>> materializedViewDefinitions = new ConcurrentHashMap<QualifiedObjectName, Future<Optional<MaterializedViewDefinition>>>();
    private final Map<QualifiedObjectName, Future<TableColumnMetadata>> tableColumnsMetadata = new ConcurrentHashMap<QualifiedObjectName, Future<TableColumnMetadata>>();

    public boolean isPreProcessMetadataCalls() {
        return this.preProcessMetadataCalls;
    }

    public void setPreProcessMetadataCalls(boolean preProcessMetadataCalls) {
        this.preProcessMetadataCalls = preProcessMetadataCalls;
    }

    public void addViewDefinition(QualifiedObjectName viewName, Future<Optional<ViewDefinition>> viewDefinition) {
        Preconditions.checkState((!this.viewDefinitions.containsKey(viewName) ? 1 : 0) != 0, (Object)("View " + viewName + " already exists"));
        this.viewDefinitions.put(viewName, viewDefinition);
    }

    public void addMaterializedViewDefinition(QualifiedObjectName viewName, Future<Optional<MaterializedViewDefinition>> viewDefinition) {
        Preconditions.checkState((!this.materializedViewDefinitions.containsKey(viewName) ? 1 : 0) != 0, (Object)("View " + viewName + " already exists"));
        this.materializedViewDefinitions.put(viewName, viewDefinition);
    }

    public void addTableColumnMetadata(QualifiedObjectName tableName, Future<TableColumnMetadata> tableColumnMetadata) {
        Preconditions.checkState((!this.tableColumnsMetadata.containsKey(tableName) ? 1 : 0) != 0, (Object)("Table " + tableName + " already present"));
        this.tableColumnsMetadata.put(tableName, tableColumnMetadata);
    }

    public Optional<ViewDefinition> getViewDefinition(QualifiedObjectName viewName) {
        Preconditions.checkState((boolean)this.viewDefinitions.containsKey(viewName), (Object)("View " + viewName + " not found, the available view names are " + this.viewDefinitions.keySet()));
        try {
            return this.viewDefinitions.get(viewName).get();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
        catch (ExecutionException ex) {
            Throwables.throwIfUnchecked((Throwable)ex.getCause());
            throw new RuntimeException(ex.getCause());
        }
    }

    public Optional<MaterializedViewDefinition> getMaterializedViewDefinition(QualifiedObjectName viewName) {
        Preconditions.checkState((boolean)this.materializedViewDefinitions.containsKey(viewName), (Object)("View " + viewName + " not found"));
        try {
            return this.materializedViewDefinitions.get(viewName).get();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
        catch (ExecutionException ex) {
            Throwables.throwIfUnchecked((Throwable)ex.getCause());
            throw new RuntimeException(ex.getCause());
        }
    }

    public TableColumnMetadata getTableColumnsMetadata(QualifiedObjectName tableName) {
        Preconditions.checkState((boolean)this.tableColumnsMetadata.containsKey(tableName), (Object)("Table " + tableName + " not found"));
        try {
            return this.tableColumnsMetadata.get(tableName).get();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
        catch (ExecutionException ex) {
            Throwables.throwIfUnchecked((Throwable)ex.getCause());
            throw new RuntimeException(ex.getCause());
        }
    }
}

