/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.analyzer.AccessControlInfo;
import com.facebook.presto.spi.analyzer.AccessControlInfoForTable;
import com.facebook.presto.spi.analyzer.AccessControlReferences;
import com.facebook.presto.spi.analyzer.AccessControlRole;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.AccessControlContext;
import com.facebook.presto.spi.security.AllowAllAccessControl;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.sql.analyzer.ExpressionAnalysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.FieldId;
import com.facebook.presto.sql.analyzer.MetadataHandle;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GroupingOperation;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.Offset;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.QuantifiedComparisonExpression;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.Table;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public class Analysis {
    @Nullable
    private final Statement root;
    private final Map<NodeRef<Parameter>, Expression> parameters;
    private String updateType;
    private final Map<NodeRef<Table>, Query> namedQueries = new LinkedHashMap<NodeRef<Table>, Query>();
    private final Map<NodeRef<Node>, Scope> scopes = new LinkedHashMap<NodeRef<Node>, Scope>();
    private final Multimap<NodeRef<Expression>, FieldId> columnReferences = ArrayListMultimap.create();
    private final AccessControlReferences accessControlReferences = new AccessControlReferences();
    private final Map<AccessControlInfo, Map<QualifiedObjectName, Set<String>>> tableColumnReferences = new LinkedHashMap<AccessControlInfo, Map<QualifiedObjectName, Set<String>>>();
    private final Map<AccessControlInfo, Map<QualifiedObjectName, Set<String>>> utilizedTableColumnReferences = new LinkedHashMap<AccessControlInfo, Map<QualifiedObjectName, Set<String>>>();
    private final Map<AccessControlInfo, Map<QualifiedObjectName, Set<Subfield>>> tableColumnAndSubfieldReferences = new LinkedHashMap<AccessControlInfo, Map<QualifiedObjectName, Set<Subfield>>>();
    private final Map<NodeRef<QuerySpecification>, List<FunctionCall>> aggregates = new LinkedHashMap<NodeRef<QuerySpecification>, List<FunctionCall>>();
    private final Map<NodeRef<OrderBy>, List<Expression>> orderByAggregates = new LinkedHashMap<NodeRef<OrderBy>, List<Expression>>();
    private final Map<NodeRef<QuerySpecification>, List<Expression>> groupByExpressions = new LinkedHashMap<NodeRef<QuerySpecification>, List<Expression>>();
    private final Map<NodeRef<QuerySpecification>, GroupingSetAnalysis> groupingSets = new LinkedHashMap<NodeRef<QuerySpecification>, GroupingSetAnalysis>();
    private final Map<NodeRef<Node>, Expression> where = new LinkedHashMap<NodeRef<Node>, Expression>();
    private final Map<NodeRef<QuerySpecification>, Expression> having = new LinkedHashMap<NodeRef<QuerySpecification>, Expression>();
    private final Map<NodeRef<Node>, List<Expression>> orderByExpressions = new LinkedHashMap<NodeRef<Node>, List<Expression>>();
    private final Set<NodeRef<OrderBy>> redundantOrderBy = new HashSet<NodeRef<OrderBy>>();
    private final Map<NodeRef<Node>, List<Expression>> outputExpressions = new LinkedHashMap<NodeRef<Node>, List<Expression>>();
    private final Map<NodeRef<QuerySpecification>, List<FunctionCall>> windowFunctions = new LinkedHashMap<NodeRef<QuerySpecification>, List<FunctionCall>>();
    private final Map<NodeRef<OrderBy>, List<FunctionCall>> orderByWindowFunctions = new LinkedHashMap<NodeRef<OrderBy>, List<FunctionCall>>();
    private final Map<NodeRef<Offset>, Long> offset = new LinkedHashMap<NodeRef<Offset>, Long>();
    private final Map<NodeRef<Join>, Expression> joins = new LinkedHashMap<NodeRef<Join>, Expression>();
    private final Map<NodeRef<Join>, JoinUsingAnalysis> joinUsing = new LinkedHashMap<NodeRef<Join>, JoinUsingAnalysis>();
    private final ListMultimap<NodeRef<Node>, InPredicate> inPredicatesSubqueries = ArrayListMultimap.create();
    private final ListMultimap<NodeRef<Node>, SubqueryExpression> scalarSubqueries = ArrayListMultimap.create();
    private final ListMultimap<NodeRef<Node>, ExistsPredicate> existsSubqueries = ArrayListMultimap.create();
    private final ListMultimap<NodeRef<Node>, QuantifiedComparisonExpression> quantifiedComparisonSubqueries = ArrayListMultimap.create();
    private final MetadataHandle metadataHandle = new MetadataHandle();
    private final Map<NodeRef<Table>, TableHandle> tables = new LinkedHashMap<NodeRef<Table>, TableHandle>();
    private final Map<NodeRef<Expression>, Type> types = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Map<NodeRef<Expression>, Type> coercions = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Map<NodeRef<Expression>, Type> sortKeyCoercionsForFrameBoundCalculation = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Map<NodeRef<Expression>, Type> sortKeyCoercionsForFrameBoundComparison = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Map<NodeRef<Expression>, FunctionHandle> frameBoundCalculations = new LinkedHashMap<NodeRef<Expression>, FunctionHandle>();
    private final Set<NodeRef<Expression>> typeOnlyCoercions = new LinkedHashSet<NodeRef<Expression>>();
    private final Map<NodeRef<Relation>, List<Type>> relationCoercions = new LinkedHashMap<NodeRef<Relation>, List<Type>>();
    private final Map<NodeRef<FunctionCall>, FunctionHandle> functionHandles = new LinkedHashMap<NodeRef<FunctionCall>, FunctionHandle>();
    private final Map<NodeRef<Identifier>, LambdaArgumentDeclaration> lambdaArgumentReferences = new LinkedHashMap<NodeRef<Identifier>, LambdaArgumentDeclaration>();
    private final Map<Field, ColumnHandle> columns = new LinkedHashMap<Field, ColumnHandle>();
    private final Map<NodeRef<SampledRelation>, Double> sampleRatios = new LinkedHashMap<NodeRef<SampledRelation>, Double>();
    private final Map<NodeRef<QuerySpecification>, List<GroupingOperation>> groupingOperations = new LinkedHashMap<NodeRef<QuerySpecification>, List<GroupingOperation>>();
    private Optional<QualifiedObjectName> createTableDestination = Optional.empty();
    private Map<String, Expression> createTableProperties = ImmutableMap.of();
    private boolean createTableAsSelectWithData = true;
    private boolean createTableAsSelectNoOp;
    private Optional<List<Identifier>> createTableColumnAliases = Optional.empty();
    private Optional<String> createTableComment = Optional.empty();
    private Optional<Insert> insert = Optional.empty();
    private Optional<RefreshMaterializedViewAnalysis> refreshMaterializedViewAnalysis = Optional.empty();
    private Optional<TableHandle> analyzeTarget = Optional.empty();
    private final boolean isDescribe;
    private final Deque<Table> tablesForView = new ArrayDeque<Table>();
    private final ListMultimap<NodeRef<Table>, Table> tablesForMaterializedView = ArrayListMultimap.create();
    private final Map<Table, MaterializedViewAnalysisState> materializedViewAnalysisStateMap = new HashMap<Table, MaterializedViewAnalysisState>();
    private final Map<QualifiedObjectName, String> materializedViews = new LinkedHashMap<QualifiedObjectName, String>();
    private Optional<String> expandedQuery = Optional.empty();
    private Optional<QuerySpecification> currentQuerySpecification = Optional.empty();

    public Analysis(@Nullable Statement root, Map<NodeRef<Parameter>, Expression> parameters, boolean isDescribe) {
        this.root = root;
        this.parameters = ImmutableMap.copyOf(Objects.requireNonNull(parameters, "parameterMap is null"));
        this.isDescribe = isDescribe;
    }

    public Statement getStatement() {
        return this.root;
    }

    public String getUpdateType() {
        return this.updateType;
    }

    public void setUpdateType(String updateType) {
        this.updateType = updateType;
    }

    public boolean isCreateTableAsSelectWithData() {
        return this.createTableAsSelectWithData;
    }

    public void setCreateTableAsSelectWithData(boolean createTableAsSelectWithData) {
        this.createTableAsSelectWithData = createTableAsSelectWithData;
    }

    public boolean isCreateTableAsSelectNoOp() {
        return this.createTableAsSelectNoOp;
    }

    public void setCreateTableAsSelectNoOp(boolean createTableAsSelectNoOp) {
        this.createTableAsSelectNoOp = createTableAsSelectNoOp;
    }

    public void setAggregates(QuerySpecification node, List<FunctionCall> aggregates) {
        this.aggregates.put((NodeRef<QuerySpecification>)NodeRef.of((Node)node), (List<FunctionCall>)ImmutableList.copyOf(aggregates));
    }

    public List<FunctionCall> getAggregates(QuerySpecification query) {
        return this.aggregates.get(NodeRef.of((Node)query));
    }

    public void setOrderByAggregates(OrderBy node, List<Expression> aggregates) {
        this.orderByAggregates.put((NodeRef<OrderBy>)NodeRef.of((Node)node), (List<Expression>)ImmutableList.copyOf(aggregates));
    }

    public List<Expression> getOrderByAggregates(OrderBy node) {
        return this.orderByAggregates.get(NodeRef.of((Node)node));
    }

    public Map<NodeRef<Expression>, Type> getTypes() {
        return Collections.unmodifiableMap(this.types);
    }

    public Type getType(Expression expression) {
        Type type = this.types.get(NodeRef.of((Node)expression));
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Expression not analyzed: %s", (Object)expression);
        return type;
    }

    public Type getTypeWithCoercions(Expression expression) {
        NodeRef key = NodeRef.of((Node)expression);
        Preconditions.checkArgument((boolean)this.types.containsKey(key), (String)"Expression not analyzed: %s", (Object)expression);
        if (this.coercions.containsKey(key)) {
            return this.coercions.get(key);
        }
        return this.types.get(key);
    }

    public Type[] getRelationCoercion(Relation relation) {
        return Optional.ofNullable(this.relationCoercions.get(NodeRef.of((Node)relation))).map(types -> (Type[])types.stream().toArray(Type[]::new)).orElse(null);
    }

    public void addRelationCoercion(Relation relation, Type[] types) {
        this.relationCoercions.put((NodeRef<Relation>)NodeRef.of((Node)relation), (List<Type>)ImmutableList.copyOf((Object[])types));
    }

    public Map<NodeRef<Expression>, Type> getCoercions() {
        return Collections.unmodifiableMap(this.coercions);
    }

    public Set<NodeRef<Expression>> getTypeOnlyCoercions() {
        return Collections.unmodifiableSet(this.typeOnlyCoercions);
    }

    public Type getCoercion(Expression expression) {
        return this.coercions.get(NodeRef.of((Node)expression));
    }

    public void addLambdaArgumentReferences(Map<NodeRef<Identifier>, LambdaArgumentDeclaration> lambdaArgumentReferences) {
        this.lambdaArgumentReferences.putAll(lambdaArgumentReferences);
    }

    public LambdaArgumentDeclaration getLambdaArgumentReference(Identifier identifier) {
        return this.lambdaArgumentReferences.get(NodeRef.of((Node)identifier));
    }

    public Map<NodeRef<Identifier>, LambdaArgumentDeclaration> getLambdaArgumentReferences() {
        return Collections.unmodifiableMap(this.lambdaArgumentReferences);
    }

    public void setGroupingSets(QuerySpecification node, GroupingSetAnalysis groupingSets) {
        this.groupingSets.put((NodeRef<QuerySpecification>)NodeRef.of((Node)node), groupingSets);
    }

    public void setGroupByExpressions(QuerySpecification node, List<Expression> expressions) {
        this.groupByExpressions.put((NodeRef<QuerySpecification>)NodeRef.of((Node)node), expressions);
    }

    public boolean isAggregation(QuerySpecification node) {
        return this.groupByExpressions.containsKey(NodeRef.of((Node)node));
    }

    public boolean isTypeOnlyCoercion(Expression expression) {
        return this.typeOnlyCoercions.contains(NodeRef.of((Node)expression));
    }

    public GroupingSetAnalysis getGroupingSets(QuerySpecification node) {
        return this.groupingSets.get(NodeRef.of((Node)node));
    }

    public List<Expression> getGroupByExpressions(QuerySpecification node) {
        return this.groupByExpressions.get(NodeRef.of((Node)node));
    }

    public void setWhere(Node node, Expression expression) {
        this.where.put((NodeRef<Node>)NodeRef.of((Node)node), expression);
    }

    public Expression getWhere(QuerySpecification node) {
        return this.where.get(NodeRef.of((Node)node));
    }

    public void setOrderByExpressions(Node node, List<Expression> items) {
        this.orderByExpressions.put((NodeRef<Node>)NodeRef.of((Node)node), (List<Expression>)ImmutableList.copyOf(items));
    }

    public List<Expression> getOrderByExpressions(Node node) {
        return this.orderByExpressions.get(NodeRef.of((Node)node));
    }

    public void setOffset(Offset node, long rowCount) {
        this.offset.put((NodeRef<Offset>)NodeRef.of((Node)node), rowCount);
    }

    public long getOffset(Offset node) {
        Preconditions.checkState((boolean)this.offset.containsKey(NodeRef.of((Node)node)), (String)"missing OFFSET value for node %s", (Object)node);
        return this.offset.get(NodeRef.of((Node)node));
    }

    public void setOutputExpressions(Node node, List<Expression> expressions) {
        this.outputExpressions.put((NodeRef<Node>)NodeRef.of((Node)node), (List<Expression>)ImmutableList.copyOf(expressions));
    }

    public List<Expression> getOutputExpressions(Node node) {
        return this.outputExpressions.get(NodeRef.of((Node)node));
    }

    public void setHaving(QuerySpecification node, Expression expression) {
        this.having.put((NodeRef<QuerySpecification>)NodeRef.of((Node)node), expression);
    }

    public void setJoinCriteria(Join node, Expression criteria) {
        this.joins.put((NodeRef<Join>)NodeRef.of((Node)node), criteria);
    }

    public Expression getJoinCriteria(Join join) {
        return this.joins.get(NodeRef.of((Node)join));
    }

    public void recordSubqueries(Node node, ExpressionAnalysis expressionAnalysis) {
        NodeRef key = NodeRef.of((Node)node);
        this.inPredicatesSubqueries.putAll((Object)key, this.dereference(expressionAnalysis.getSubqueryInPredicates()));
        this.scalarSubqueries.putAll((Object)key, this.dereference(expressionAnalysis.getScalarSubqueries()));
        this.existsSubqueries.putAll((Object)key, this.dereference(expressionAnalysis.getExistsSubqueries()));
        this.quantifiedComparisonSubqueries.putAll((Object)key, this.dereference(expressionAnalysis.getQuantifiedComparisons()));
    }

    private <T extends Node> List<T> dereference(Collection<NodeRef<T>> nodeRefs) {
        return (List)nodeRefs.stream().map(NodeRef::getNode).collect(ImmutableList.toImmutableList());
    }

    public List<InPredicate> getInPredicateSubqueries(Node node) {
        return ImmutableList.copyOf((Collection)this.inPredicatesSubqueries.get((Object)NodeRef.of((Node)node)));
    }

    public List<SubqueryExpression> getScalarSubqueries(Node node) {
        return ImmutableList.copyOf((Collection)this.scalarSubqueries.get((Object)NodeRef.of((Node)node)));
    }

    public boolean isScalarSubquery(SubqueryExpression subqueryExpression) {
        return this.scalarSubqueries.values().contains(subqueryExpression);
    }

    public List<ExistsPredicate> getExistsSubqueries(Node node) {
        return ImmutableList.copyOf((Collection)this.existsSubqueries.get((Object)NodeRef.of((Node)node)));
    }

    public List<QuantifiedComparisonExpression> getQuantifiedComparisonSubqueries(Node node) {
        return Collections.unmodifiableList(this.quantifiedComparisonSubqueries.get((Object)NodeRef.of((Node)node)));
    }

    public void setWindowFunctions(QuerySpecification node, List<FunctionCall> functions) {
        this.windowFunctions.put((NodeRef<QuerySpecification>)NodeRef.of((Node)node), (List<FunctionCall>)ImmutableList.copyOf(functions));
    }

    public List<FunctionCall> getWindowFunctions(QuerySpecification query) {
        return this.windowFunctions.get(NodeRef.of((Node)query));
    }

    public void setOrderByWindowFunctions(OrderBy node, List<FunctionCall> functions) {
        this.orderByWindowFunctions.put((NodeRef<OrderBy>)NodeRef.of((Node)node), (List<FunctionCall>)ImmutableList.copyOf(functions));
    }

    public List<FunctionCall> getOrderByWindowFunctions(OrderBy query) {
        return this.orderByWindowFunctions.get(NodeRef.of((Node)query));
    }

    public void addColumnReferences(Map<NodeRef<Expression>, FieldId> columnReferences) {
        this.columnReferences.putAll((Multimap)Multimaps.forMap(columnReferences));
    }

    public void addColumnReference(NodeRef<Expression> node, FieldId fieldId) {
        this.columnReferences.put(node, (Object)fieldId);
    }

    public Scope getScope(Node node) {
        return this.tryGetScope(node).orElseThrow(() -> new IllegalArgumentException(String.format("Analysis does not contain information for node: %s", node)));
    }

    public Optional<Scope> tryGetScope(Node node) {
        NodeRef key = NodeRef.of((Node)node);
        if (this.scopes.containsKey(key)) {
            return Optional.of(this.scopes.get(key));
        }
        return Optional.empty();
    }

    public Scope getRootScope() {
        return this.getScope((Node)this.root);
    }

    public void setScope(Node node, Scope scope) {
        this.scopes.put((NodeRef<Node>)NodeRef.of((Node)node), scope);
    }

    public RelationType getOutputDescriptor() {
        return this.getOutputDescriptor((Node)this.root);
    }

    public RelationType getOutputDescriptor(Node node) {
        return this.getScope(node).getRelationType();
    }

    public MetadataHandle getMetadataHandle() {
        return this.metadataHandle;
    }

    public TableHandle getTableHandle(Table table) {
        return this.tables.get(NodeRef.of((Node)table));
    }

    public Collection<TableHandle> getTables() {
        return Collections.unmodifiableCollection(this.tables.values());
    }

    public List<Table> getTableNodes() {
        return (List)this.tables.keySet().stream().map(NodeRef::getNode).collect(ImmutableList.toImmutableList());
    }

    public void registerTable(Table table, TableHandle handle) {
        this.tables.put((NodeRef<Table>)NodeRef.of((Node)table), handle);
    }

    public FunctionHandle getFunctionHandle(FunctionCall function) {
        return this.functionHandles.get(NodeRef.of((Node)function));
    }

    public Map<NodeRef<FunctionCall>, FunctionHandle> getFunctionHandles() {
        return ImmutableMap.copyOf(this.functionHandles);
    }

    public void addFunctionHandles(Map<NodeRef<FunctionCall>, FunctionHandle> infos) {
        this.functionHandles.putAll(infos);
    }

    public Set<NodeRef<Expression>> getColumnReferences() {
        return Collections.unmodifiableSet(this.columnReferences.keySet());
    }

    public Multimap<NodeRef<Expression>, FieldId> getColumnReferenceFields() {
        return Multimaps.unmodifiableMultimap(this.columnReferences);
    }

    public boolean isColumnReference(Expression expression) {
        Objects.requireNonNull(expression, "expression is null");
        Preconditions.checkArgument((this.getType(expression) != null ? 1 : 0) != 0, (String)"expression %s has not been analyzed", (Object)expression);
        return this.columnReferences.containsKey((Object)NodeRef.of((Node)expression));
    }

    public void addTypes(Map<NodeRef<Expression>, Type> types) {
        this.types.putAll(types);
    }

    public void addCoercion(Expression expression, Type type, boolean isTypeOnlyCoercion) {
        this.coercions.put((NodeRef<Expression>)NodeRef.of((Node)expression), type);
        if (isTypeOnlyCoercion) {
            this.typeOnlyCoercions.add((NodeRef<Expression>)NodeRef.of((Node)expression));
        }
    }

    public void addCoercions(Map<NodeRef<Expression>, Type> coercions, Set<NodeRef<Expression>> typeOnlyCoercions, Map<NodeRef<Expression>, Type> sortKeyCoercionsForFrameBoundCalculation, Map<NodeRef<Expression>, Type> sortKeyCoercionsForFrameBoundComparison) {
        this.coercions.putAll(coercions);
        this.typeOnlyCoercions.addAll(typeOnlyCoercions);
        this.sortKeyCoercionsForFrameBoundCalculation.putAll(sortKeyCoercionsForFrameBoundCalculation);
        this.sortKeyCoercionsForFrameBoundComparison.putAll(sortKeyCoercionsForFrameBoundComparison);
    }

    public Type getSortKeyCoercionForFrameBoundCalculation(Expression frameOffset) {
        return this.sortKeyCoercionsForFrameBoundCalculation.get(NodeRef.of((Node)frameOffset));
    }

    public Type getSortKeyCoercionForFrameBoundComparison(Expression frameOffset) {
        return this.sortKeyCoercionsForFrameBoundComparison.get(NodeRef.of((Node)frameOffset));
    }

    public void addFrameBoundCalculations(Map<NodeRef<Expression>, FunctionHandle> frameBoundCalculations) {
        this.frameBoundCalculations.putAll(frameBoundCalculations);
    }

    public FunctionHandle getFrameBoundCalculation(Expression frameOffset) {
        return this.frameBoundCalculations.get(NodeRef.of((Node)frameOffset));
    }

    public Expression getHaving(QuerySpecification query) {
        return this.having.get(NodeRef.of((Node)query));
    }

    public void setColumn(Field field, ColumnHandle handle) {
        this.columns.put(field, handle);
    }

    public ColumnHandle getColumn(Field field) {
        return this.columns.get(field);
    }

    public void setCreateTableDestination(QualifiedObjectName destination) {
        this.createTableDestination = Optional.of(destination);
    }

    public Optional<QualifiedObjectName> getCreateTableDestination() {
        return this.createTableDestination;
    }

    public Optional<TableHandle> getAnalyzeTarget() {
        return this.analyzeTarget;
    }

    public void setAnalyzeTarget(TableHandle analyzeTarget) {
        this.analyzeTarget = Optional.of(analyzeTarget);
    }

    public void setCreateTableProperties(Map<String, Expression> createTableProperties) {
        this.createTableProperties = ImmutableMap.copyOf(createTableProperties);
    }

    public Map<String, Expression> getCreateTableProperties() {
        return this.createTableProperties;
    }

    public Optional<List<Identifier>> getColumnAliases() {
        return this.createTableColumnAliases;
    }

    public void setCreateTableColumnAliases(List<Identifier> createTableColumnAliases) {
        this.createTableColumnAliases = Optional.of(createTableColumnAliases);
    }

    public void setCreateTableComment(Optional<String> createTableComment) {
        this.createTableComment = Objects.requireNonNull(createTableComment);
    }

    public Optional<String> getCreateTableComment() {
        return this.createTableComment;
    }

    public void setInsert(Insert insert) {
        this.insert = Optional.of(insert);
    }

    public Optional<Insert> getInsert() {
        return this.insert;
    }

    public void setRefreshMaterializedViewAnalysis(RefreshMaterializedViewAnalysis refreshMaterializedViewAnalysis) {
        this.refreshMaterializedViewAnalysis = Optional.of(refreshMaterializedViewAnalysis);
    }

    public Optional<RefreshMaterializedViewAnalysis> getRefreshMaterializedViewAnalysis() {
        return this.refreshMaterializedViewAnalysis;
    }

    public Query getNamedQuery(Table table) {
        return this.namedQueries.get(NodeRef.of((Node)table));
    }

    public void registerNamedQuery(Table tableReference, Query query) {
        Objects.requireNonNull(tableReference, "tableReference is null");
        Objects.requireNonNull(query, "query is null");
        this.namedQueries.put((NodeRef<Table>)NodeRef.of((Node)tableReference), query);
    }

    public void registerTableForView(Table tableReference) {
        this.tablesForView.push(Objects.requireNonNull(tableReference, "table is null"));
    }

    public void unregisterTableForView() {
        this.tablesForView.pop();
    }

    public void registerMaterializedViewForAnalysis(QualifiedObjectName materializedViewName, Table materializedView, String materializedViewSql) {
        Objects.requireNonNull(materializedView, "materializedView is null");
        if (this.materializedViewAnalysisStateMap.containsKey(materializedView)) {
            this.materializedViewAnalysisStateMap.put(materializedView, MaterializedViewAnalysisState.VISITED);
        } else {
            this.materializedViewAnalysisStateMap.put(materializedView, MaterializedViewAnalysisState.VISITING);
        }
        this.materializedViews.put(materializedViewName, materializedViewSql);
    }

    public void unregisterMaterializedViewForAnalysis(Table materializedView) {
        Objects.requireNonNull(materializedView, "materializedView is null");
        Preconditions.checkState((boolean)this.materializedViewAnalysisStateMap.containsKey(materializedView), (Object)String.format("materializedViewAnalysisStateMap does not contain materialized view : %s", materializedView.getName()));
        this.materializedViewAnalysisStateMap.remove(materializedView);
    }

    public MaterializedViewAnalysisState getMaterializedViewAnalysisState(Table materializedView) {
        Objects.requireNonNull(materializedView, "materializedView is null");
        return this.materializedViewAnalysisStateMap.getOrDefault(materializedView, MaterializedViewAnalysisState.NOT_VISITED);
    }

    public boolean hasTableInView(Table tableReference) {
        return this.tablesForView.contains(tableReference);
    }

    public void registerTableForMaterializedView(Table view, Table table) {
        Objects.requireNonNull(view, "view is null");
        Objects.requireNonNull(table, "table is null");
        this.tablesForMaterializedView.put((Object)NodeRef.of((Node)view), (Object)table);
    }

    public void unregisterTableForMaterializedView(Table view, Table table) {
        Objects.requireNonNull(view, "view is null");
        Objects.requireNonNull(table, "table is null");
        this.tablesForMaterializedView.remove((Object)NodeRef.of((Node)view), (Object)table);
    }

    public boolean hasTableRegisteredForMaterializedView(Table view, Table table) {
        Objects.requireNonNull(view, "view is null");
        Objects.requireNonNull(table, "table is null");
        return this.tablesForMaterializedView.containsEntry((Object)NodeRef.of((Node)view), (Object)table);
    }

    public void setSampleRatio(SampledRelation relation, double ratio) {
        this.sampleRatios.put((NodeRef<SampledRelation>)NodeRef.of((Node)relation), ratio);
    }

    public double getSampleRatio(SampledRelation relation) {
        NodeRef key = NodeRef.of((Node)relation);
        Preconditions.checkState((boolean)this.sampleRatios.containsKey(key), (String)"Sample ratio missing for %s. Broken analysis?", (Object)relation);
        return this.sampleRatios.get(key);
    }

    public void setGroupingOperations(QuerySpecification querySpecification, List<GroupingOperation> groupingOperations) {
        this.groupingOperations.put((NodeRef<QuerySpecification>)NodeRef.of((Node)querySpecification), (List<GroupingOperation>)ImmutableList.copyOf(groupingOperations));
    }

    public List<GroupingOperation> getGroupingOperations(QuerySpecification querySpecification) {
        return Optional.ofNullable(this.groupingOperations.get(NodeRef.of((Node)querySpecification))).orElse(Collections.emptyList());
    }

    public Map<NodeRef<Parameter>, Expression> getParameters() {
        return this.parameters;
    }

    public boolean isDescribe() {
        return this.isDescribe;
    }

    public void setJoinUsing(Join node, JoinUsingAnalysis analysis) {
        this.joinUsing.put((NodeRef<Join>)NodeRef.of((Node)node), analysis);
    }

    public JoinUsingAnalysis getJoinUsing(Join node) {
        return this.joinUsing.get(NodeRef.of((Node)node));
    }

    public AccessControlReferences getAccessControlReferences() {
        return this.accessControlReferences;
    }

    public void addAccessControlCheckForTable(AccessControlRole accessControlRole, AccessControlInfoForTable accessControlInfoForTable) {
        this.accessControlReferences.addTableReference(accessControlRole, accessControlInfoForTable);
    }

    public void addTableColumnAndSubfieldReferences(AccessControl accessControl, Identity identity, Optional<TransactionId> transactionId, AccessControlContext accessControlContext, Multimap<QualifiedObjectName, Subfield> tableColumnMap, Multimap<QualifiedObjectName, Subfield> tableColumnMapForAccessControl) {
        AccessControlInfo accessControlInfo = new AccessControlInfo(accessControl, identity, transactionId, accessControlContext);
        Map columnReferences = this.tableColumnReferences.computeIfAbsent(accessControlInfo, k -> new LinkedHashMap());
        tableColumnMap.asMap().forEach((key, value) -> columnReferences.computeIfAbsent(key, k -> new HashSet()).addAll((Collection)value.stream().map(Subfield::getRootName).collect(ImmutableSet.toImmutableSet())));
        Map columnAndSubfieldReferences = this.tableColumnAndSubfieldReferences.computeIfAbsent(accessControlInfo, k -> new LinkedHashMap());
        tableColumnMapForAccessControl.asMap().forEach((key, value) -> columnAndSubfieldReferences.computeIfAbsent(key, k -> new HashSet()).addAll(value));
    }

    public void addEmptyColumnReferencesForTable(AccessControl accessControl, Identity identity, Optional<TransactionId> transactionId, AccessControlContext accessControlContext, QualifiedObjectName table) {
        AccessControlInfo accessControlInfo = new AccessControlInfo(accessControl, identity, transactionId, accessControlContext);
        this.tableColumnReferences.computeIfAbsent(accessControlInfo, k -> new LinkedHashMap()).computeIfAbsent(table, k -> new HashSet());
        this.tableColumnAndSubfieldReferences.computeIfAbsent(accessControlInfo, k -> new LinkedHashMap()).computeIfAbsent(table, k -> new HashSet());
    }

    public Map<AccessControlInfo, Map<QualifiedObjectName, Set<String>>> getTableColumnReferences() {
        return this.tableColumnReferences;
    }

    public void addUtilizedTableColumnReferences(AccessControlInfo accessControlInfo, Map<QualifiedObjectName, Set<String>> utilizedTableColumns) {
        this.utilizedTableColumnReferences.put(accessControlInfo, utilizedTableColumns);
    }

    public Map<AccessControlInfo, Map<QualifiedObjectName, Set<String>>> getUtilizedTableColumnReferences() {
        return ImmutableMap.copyOf(this.utilizedTableColumnReferences);
    }

    public void populateTableColumnAndSubfieldReferencesForAccessControl(boolean checkAccessControlOnUtilizedColumnsOnly, boolean checkAccessControlWithSubfields) {
        this.accessControlReferences.addTableColumnAndSubfieldReferencesForAccessControl(this.getTableColumnAndSubfieldReferencesForAccessControl(checkAccessControlOnUtilizedColumnsOnly, checkAccessControlWithSubfields));
    }

    private Map<AccessControlInfo, Map<QualifiedObjectName, Set<Subfield>>> getTableColumnAndSubfieldReferencesForAccessControl(boolean checkAccessControlOnUtilizedColumnsOnly, boolean checkAccessControlWithSubfields) {
        Map references = !checkAccessControlWithSubfields ? (Map)(checkAccessControlOnUtilizedColumnsOnly ? this.utilizedTableColumnReferences : this.tableColumnReferences).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, accessControlEntry -> (ImmutableMap)((Map)accessControlEntry.getValue()).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, tableEntry -> (ImmutableSet)((Set)tableEntry.getValue()).stream().map(column -> new Subfield(column, (List)ImmutableList.of())).collect(ImmutableSet.toImmutableSet()))))) : (!checkAccessControlOnUtilizedColumnsOnly ? this.tableColumnAndSubfieldReferences : (Map)this.tableColumnAndSubfieldReferences.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, accessControlEntry -> (ImmutableMap)((Map)accessControlEntry.getValue()).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, tableEntry -> (ImmutableSet)((Set)tableEntry.getValue()).stream().filter(column -> {
            Map<QualifiedObjectName, Set<String>> utilizedTableReferences = this.utilizedTableColumnReferences.get(accessControlEntry.getKey());
            if (utilizedTableReferences == null) {
                return false;
            }
            Set<String> utilizedColumns = utilizedTableReferences.get(tableEntry.getKey());
            return utilizedColumns != null && utilizedColumns.contains(column.getRootName());
        }).collect(ImmutableSet.toImmutableSet()))))));
        return this.buildMaterializedViewAccessControl(references);
    }

    private Map<AccessControlInfo, Map<QualifiedObjectName, Set<Subfield>>> buildMaterializedViewAccessControl(Map<AccessControlInfo, Map<QualifiedObjectName, Set<Subfield>>> tableColumnReferences) {
        if (!(this.getStatement() instanceof Query) || this.materializedViews.isEmpty()) {
            return tableColumnReferences;
        }
        LinkedHashMap<AccessControlInfo, Map<QualifiedObjectName, Set<Subfield>>> newTableColumnReferences = new LinkedHashMap<AccessControlInfo, Map<QualifiedObjectName, Set<Subfield>>>();
        tableColumnReferences.forEach((accessControlInfo, references) -> {
            AccessControlInfo allowAllAccessControlInfo = new AccessControlInfo((AccessControl)new AllowAllAccessControl(), accessControlInfo.getIdentity(), accessControlInfo.getTransactionId(), accessControlInfo.getAccessControlContext());
            Map newAllowAllReferences = newTableColumnReferences.getOrDefault(allowAllAccessControlInfo, new LinkedHashMap());
            LinkedHashMap newOtherReferences = new LinkedHashMap();
            references.forEach((table, columns) -> {
                if (this.materializedViews.containsKey(table)) {
                    newAllowAllReferences.computeIfAbsent(table, key -> new HashSet()).addAll(columns);
                } else {
                    newOtherReferences.put(table, columns);
                }
            });
            if (!newAllowAllReferences.isEmpty()) {
                newTableColumnReferences.put(allowAllAccessControlInfo, newAllowAllReferences);
            }
            if (!newOtherReferences.isEmpty()) {
                newTableColumnReferences.put((AccessControlInfo)accessControlInfo, newOtherReferences);
            }
        });
        return newTableColumnReferences;
    }

    public void markRedundantOrderBy(OrderBy orderBy) {
        this.redundantOrderBy.add((NodeRef<OrderBy>)NodeRef.of((Node)orderBy));
    }

    public boolean isOrderByRedundant(OrderBy orderBy) {
        return this.redundantOrderBy.contains(NodeRef.of((Node)orderBy));
    }

    public void setExpandedQuery(String expandedQuery) {
        this.expandedQuery = Optional.of(expandedQuery);
    }

    public Optional<String> getExpandedQuery() {
        return this.expandedQuery;
    }

    public void setCurrentSubquery(QuerySpecification currentSubQuery) {
        this.currentQuerySpecification = Optional.of(currentSubQuery);
    }

    public Optional<QuerySpecification> getCurrentQuerySpecification() {
        return this.currentQuerySpecification;
    }

    public Map<FunctionKind, Set<String>> getInvokedFunctions() {
        HashMap functionMap = new HashMap();
        for (FunctionHandle functionHandle : this.functionHandles.values()) {
            functionMap.putIfAbsent(functionHandle.getKind(), new HashSet());
            ((Set)functionMap.get(functionHandle.getKind())).add(functionHandle.getName());
        }
        return (Map)functionMap.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ImmutableSet.copyOf((Collection)((Collection)entry.getValue()))));
    }

    public static enum MaterializedViewAnalysisState {
        NOT_VISITED(0),
        VISITING(1),
        VISITED(2);

        private final int value;

        private MaterializedViewAnalysisState(int value) {
            this.value = value;
        }

        public boolean isNotVisited() {
            return this.value == MaterializedViewAnalysisState.NOT_VISITED.value;
        }

        public boolean isVisited() {
            return this.value == MaterializedViewAnalysisState.VISITED.value;
        }

        public boolean isVisiting() {
            return this.value == MaterializedViewAnalysisState.VISITING.value;
        }
    }

    public static class GroupingSetAnalysis {
        private final List<Set<FieldId>> cubes;
        private final List<List<FieldId>> rollups;
        private final List<List<Set<FieldId>>> ordinarySets;
        private final List<Expression> complexExpressions;

        public GroupingSetAnalysis(List<Set<FieldId>> cubes, List<List<FieldId>> rollups, List<List<Set<FieldId>>> ordinarySets, List<Expression> complexExpressions) {
            this.cubes = ImmutableList.copyOf(cubes);
            this.rollups = ImmutableList.copyOf(rollups);
            this.ordinarySets = ImmutableList.copyOf(ordinarySets);
            this.complexExpressions = ImmutableList.copyOf(complexExpressions);
        }

        public List<Set<FieldId>> getCubes() {
            return this.cubes;
        }

        public List<List<FieldId>> getRollups() {
            return this.rollups;
        }

        public List<List<Set<FieldId>>> getOrdinarySets() {
            return this.ordinarySets;
        }

        public List<Expression> getComplexExpressions() {
            return this.complexExpressions;
        }
    }

    public static final class JoinUsingAnalysis {
        private final List<Integer> leftJoinFields;
        private final List<Integer> rightJoinFields;
        private final List<Integer> otherLeftFields;
        private final List<Integer> otherRightFields;

        JoinUsingAnalysis(List<Integer> leftJoinFields, List<Integer> rightJoinFields, List<Integer> otherLeftFields, List<Integer> otherRightFields) {
            this.leftJoinFields = ImmutableList.copyOf(leftJoinFields);
            this.rightJoinFields = ImmutableList.copyOf(rightJoinFields);
            this.otherLeftFields = ImmutableList.copyOf(otherLeftFields);
            this.otherRightFields = ImmutableList.copyOf(otherRightFields);
            Preconditions.checkArgument((leftJoinFields.size() == rightJoinFields.size() ? 1 : 0) != 0, (Object)"Expected join fields for left and right to have the same size");
        }

        public List<Integer> getLeftJoinFields() {
            return this.leftJoinFields;
        }

        public List<Integer> getRightJoinFields() {
            return this.rightJoinFields;
        }

        public List<Integer> getOtherLeftFields() {
            return this.otherLeftFields;
        }

        public List<Integer> getOtherRightFields() {
            return this.otherRightFields;
        }
    }

    @Immutable
    public static final class RefreshMaterializedViewAnalysis {
        private final TableHandle target;
        private final List<ColumnHandle> columns;
        private final Query query;

        public RefreshMaterializedViewAnalysis(TableHandle target, List<ColumnHandle> columns, Query query) {
            this.target = Objects.requireNonNull(target, "target is null");
            this.columns = Objects.requireNonNull(columns, "columns is null");
            this.query = Objects.requireNonNull(query, "query is null");
            Preconditions.checkArgument((columns.size() > 0 ? 1 : 0) != 0, (Object)"No columns given to insert");
        }

        public List<ColumnHandle> getColumns() {
            return this.columns;
        }

        public TableHandle getTarget() {
            return this.target;
        }

        public Query getQuery() {
            return this.query;
        }
    }

    @Immutable
    public static final class Insert {
        private final TableHandle target;
        private final List<ColumnHandle> columns;

        public Insert(TableHandle target, List<ColumnHandle> columns) {
            this.target = Objects.requireNonNull(target, "target is null");
            this.columns = Objects.requireNonNull(columns, "columns is null");
            Preconditions.checkArgument((columns.size() > 0 ? 1 : 0) != 0, (Object)"No columns given to insert");
        }

        public List<ColumnHandle> getColumns() {
            return this.columns;
        }

        public TableHandle getTarget() {
            return this.target;
        }
    }
}

