/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.format;

import com.facebook.ktfmt.format.KotlinTok;
import com.facebook.ktfmt.format.KotlinToken;
import com.facebook.ktfmt.format.Tokenizer;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.collect.UnmodifiableIterator;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.JavaOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0002J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00122\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J#\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u001b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u001eJ \u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0 2\u0012\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u001b0\"J\u0010\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\bH\u0016J\u0010\u0010%\u001a\u00020\b2\u0006\u0010$\u001a\u00020\bH\u0016J\u0014\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000eH\u0016J\u0016\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0010H\u0016J\b\u0010(\u001a\u00020\u0003H\u0016J\u0012\u0010)\u001a\u0004\u0018\u00010\u000b2\u0006\u0010*\u001a\u00020\bH\u0016J\u0010\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0012H\u0016J\b\u0010,\u001a\u00020\bH\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002JV\u00101\u001aB\u0012\f\u0012\n 2*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n 2*\u0004\u0018\u00010\b0\b 2* \u0012\f\u0012\n 2*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n 2*\u0004\u0018\u00010\b0\b\u0018\u00010\u000e0\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/facebook/ktfmt/format/KotlinInput;", "Lcom/google/googlejavaformat/Input;", "text", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/psi/KtFile;)V", "kN", "", "kToToken", "", "Lcom/google/googlejavaformat/Input$Token;", "[Lcom/google/googlejavaformat/Input$Token;", "positionToColumnMap", "Lcom/google/common/collect/ImmutableMap;", "positionTokenMap", "Lcom/google/common/collect/ImmutableRangeMap;", "tokens", "Lcom/google/common/collect/ImmutableList;", "buildTokenPositionsMap", "buildTokens", "toks", "", "Lcom/facebook/ktfmt/format/KotlinTok;", "buildToks", "fileText", "characterRangeToTokenRange", "Lcom/google/common/collect/Range;", "offset", "length", "characterRangeToTokenRange$ktfmt", "characterRangesToTokenRanges", "Lcom/google/common/collect/RangeSet;", "characterRanges", "", "getColumnNumber", "inputPosition", "getLineNumber", "getPositionToColumnMap", "getPositionTokenMap", "getText", "getToken", "k", "getTokens", "getkN", "isParamComment", "", "tok", "Lcom/google/googlejavaformat/Input$Tok;", "makePositionToColumnMap", "kotlin.jvm.PlatformType", "ktfmt"})
public final class KotlinInput
extends Input {
    @NotNull
    private final String text;
    @NotNull
    private final ImmutableList<Input.Token> tokens;
    @NotNull
    private final ImmutableMap<Integer, Integer> positionToColumnMap;
    @NotNull
    private final ImmutableRangeMap<Integer, Input.Token> positionTokenMap;
    private int kN;
    @NotNull
    private final Input.Token[] kToToken;

    public KotlinInput(@NotNull String text, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.text = text;
        this.setLines(ImmutableList.copyOf((Iterator)Newlines.lineIterator((String)this.text)));
        ImmutableList<KotlinTok> toks = this.buildToks(file, this.text);
        UnmodifiableIterator unmodifiableIterator = this.makePositionToColumnMap((List)toks);
        Intrinsics.checkNotNullExpressionValue(unmodifiableIterator, (String)"makePositionToColumnMap(toks)");
        this.positionToColumnMap = unmodifiableIterator;
        this.tokens = this.buildTokens((List)toks);
        this.positionTokenMap = this.buildTokenPositionsMap(this.tokens);
        this.kToToken = new Input.Token[this.kN + 1];
        for (Input.Token token : this.tokens) {
            for (Input.Tok tok : token.getToksBefore()) {
                if (tok.getIndex() < 0) continue;
                this.kToToken[tok.getIndex()] = token;
            }
            this.kToToken[token.getTok().getIndex()] = token;
            for (Input.Tok tok : token.getToksAfter()) {
                if (tok.getIndex() < 0) continue;
                this.kToToken[tok.getIndex()] = token;
            }
        }
    }

    @NotNull
    public final RangeSet<Integer> characterRangesToTokenRanges(@NotNull Collection<Range<Integer>> characterRanges) throws FormatterException {
        Intrinsics.checkNotNullParameter(characterRanges, (String)"characterRanges");
        TreeRangeSet tokenRangeSet = TreeRangeSet.create();
        for (Range<Integer> characterRange0 : characterRanges) {
            Range characterRange = characterRange0.canonical(DiscreteDomain.integers());
            Comparable comparable = characterRange.lowerEndpoint();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"characterRange.lowerEndpoint()");
            int n = ((Number)((Object)comparable)).intValue();
            int n2 = ((Number)((Object)characterRange.upperEndpoint())).intValue();
            comparable = characterRange.lowerEndpoint();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"characterRange.lowerEndpoint()");
            tokenRangeSet.add(this.characterRangeToTokenRange$ktfmt(n, n2 - ((Number)((Object)comparable)).intValue()));
        }
        Intrinsics.checkNotNullExpressionValue((Object)tokenRangeSet, (String)"tokenRangeSet");
        return (RangeSet)tokenRangeSet;
    }

    @NotNull
    public final Range<Integer> characterRangeToTokenRange$ktfmt(int offset, int length) throws FormatterException {
        Collection collection;
        int requiredLength = offset + length;
        if (requiredLength > this.text.length()) {
            String string = "error: invalid length %d, offset + length (%d) is outside the file";
            Object[] objectArray = new Object[]{length, requiredLength};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            throw new FormatterException(string2);
        }
        if (length < 0) {
            Range range = Input.EMPTY_RANGE;
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"EMPTY_RANGE");
            return range;
        }
        int expandedLength = length == 0 ? 1 : length;
        Collection collection2 = this.getPositionTokenMap().subRangeMap(Range.closedOpen((Comparable)Integer.valueOf(offset), (Comparable)Integer.valueOf(offset + expandedLength))).asMapOfRanges().values();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getPositionTokenMap()\n  \u2026ges()\n            .values");
        ImmutableCollection enclosed = (ImmutableCollection)collection2;
        if (enclosed.isEmpty()) {
            collection2 = Input.EMPTY_RANGE;
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"{\n      EMPTY_RANGE\n    }");
            collection = collection2;
        } else {
            collection2 = Range.closedOpen((Comparable)Integer.valueOf(((Input.Token)enclosed.iterator().next()).getTok().getIndex()), (Comparable)Integer.valueOf(((Input.Token)Iterables.getLast((Iterable)((Iterable)enclosed))).getTok().getIndex() + 1));
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"closedOpen(\n            \u2026.getTok().getIndex() + 1)");
            collection = collection2;
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private final ImmutableMap<Integer, Integer> makePositionToColumnMap(List<KotlinTok> toks) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = toks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinTok kotlinTok = (KotlinTok)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getPosition(), (Object)it.getColumn()));
        }
        return ImmutableMap.copyOf((Map)MapsKt.toMap((Iterable)((List)destination$iv$iv)));
    }

    private final ImmutableList<KotlinTok> buildToks(KtFile file, String fileText) {
        Tokenizer tokenizer = new Tokenizer(fileText, file);
        file.accept((PsiElementVisitor)tokenizer);
        List<KotlinTok> toks = tokenizer.getToks();
        int n = tokenizer.getIndex();
        int n2 = fileText.length();
        KtToken ktToken = KtTokens.EOF;
        Intrinsics.checkNotNullExpressionValue((Object)ktToken, (String)"EOF");
        toks.add(new KotlinTok(n, "", "", n2, 0, true, ktToken));
        this.kN = tokenizer.getIndex();
        this.computeRanges(toks);
        ktToken = ImmutableList.copyOf((Collection)toks);
        Intrinsics.checkNotNullExpressionValue((Object)ktToken, (String)"copyOf(toks)");
        return ktToken;
    }

    private final ImmutableList<Input.Token> buildTokens(List<KotlinTok> toks) {
        ImmutableList.Builder tokens = ImmutableList.builder();
        int k = 0;
        int kN = toks.size();
        ImmutableList.Builder builder = ImmutableList.builder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder()");
        ImmutableList.Builder toksBefore = builder;
        block0: while (k < kN) {
            ImmutableList immutableList;
            KotlinTok tok;
            int n;
            while (!toks.get(k).isToken()) {
                n = k;
                k = n + 1;
                tok = toks.get(n);
                toksBefore.add((Object)tok);
                if (!this.isParamComment(tok)) continue;
                while (toks.get(k).isNewline()) {
                    n = k;
                    k = n + 1;
                }
            }
            n = k;
            k = n + 1;
            tok = toks.get(n);
            ImmutableList.Builder toksAfter = ImmutableList.builder();
            while (!(k >= kN || toks.get(k).isToken() || toks.get(k).isSlashStarComment() && (Intrinsics.areEqual((Object)tok.getText(), (Object)"(") || Intrinsics.areEqual((Object)tok.getText(), (Object)"<") || Intrinsics.areEqual((Object)tok.getText(), (Object)".")) || toks.get(k).isJavadocComment() && Intrinsics.areEqual((Object)tok.getText(), (Object)";"))) {
                int n2;
                if (this.isParamComment(toks.get(k))) {
                    immutableList = toksBefore.build();
                    Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"toksBefore.build()");
                    ImmutableList immutableList2 = immutableList;
                    immutableList = toksAfter.build();
                    Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"toksAfter.build()");
                    tokens.add((Object)new KotlinToken((ImmutableList<KotlinTok>)immutableList2, tok, (ImmutableList<KotlinTok>)immutableList));
                    n2 = k;
                    k = n2 + 1;
                    immutableList = ImmutableList.builder().add((Object)toks.get(n2));
                    Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"builder<KotlinTok>().add(toks[k++])");
                    toksBefore = immutableList;
                    while (toks.get(k).isNewline()) {
                        int n3 = k;
                        k = n3 + 1;
                    }
                    continue block0;
                }
                n2 = k;
                k = n2 + 1;
                KotlinTok nonTokenAfter = toks.get(n2);
                toksAfter.add((Object)nonTokenAfter);
                if (!Newlines.containsBreaks((String)nonTokenAfter.getText())) continue;
            }
            immutableList = toksBefore.build();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"toksBefore.build()");
            ImmutableList immutableList3 = immutableList;
            immutableList = toksAfter.build();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"toksAfter.build()");
            tokens.add((Object)new KotlinToken((ImmutableList<KotlinTok>)immutableList3, tok, (ImmutableList<KotlinTok>)immutableList));
            immutableList = ImmutableList.builder();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"builder()");
            toksBefore = immutableList;
        }
        builder = tokens.build();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"tokens.build()");
        return builder;
    }

    private final ImmutableRangeMap<Integer, Input.Token> buildTokenPositionsMap(ImmutableList<Input.Token> tokens) {
        ImmutableRangeMap.Builder tokenLocations = ImmutableRangeMap.builder();
        for (Input.Token token : tokens) {
            Input.Tok end = JavaOutput.endTok((Input.Token)token);
            int n = end.getPosition();
            String string = end.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"end.text");
            int endPosition = n + (((CharSequence)string).length() > 0 ? end.length() - 1 : 0);
            tokenLocations.put(Range.closed((Comparable)Integer.valueOf(JavaOutput.startTok((Input.Token)token).getPosition()), (Comparable)Integer.valueOf(endPosition)), (Object)token);
        }
        UnmodifiableIterator unmodifiableIterator = tokenLocations.build();
        Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator, (String)"tokenLocations.build()");
        return unmodifiableIterator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isParamComment(Input.Tok tok) {
        if (!tok.isSlashStarComment()) return false;
        String string = tok.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tok.text");
        CharSequence charSequence = string;
        if (!new Regex("/\\*[A-Za-z0-9\\s_\\-]+=\\s*\\*/").matches(charSequence)) return false;
        return true;
    }

    public int getkN() {
        return this.kN;
    }

    @Nullable
    public Input.Token getToken(int k) {
        return this.kToToken[k];
    }

    @NotNull
    public ImmutableList<? extends Input.Token> getTokens() {
        return this.tokens;
    }

    @NotNull
    public ImmutableRangeMap<Integer, ? extends Input.Token> getPositionTokenMap() {
        return this.positionTokenMap;
    }

    @NotNull
    public ImmutableMap<Integer, Integer> getPositionToColumnMap() {
        return this.positionToColumnMap;
    }

    @NotNull
    public String getText() {
        return this.text;
    }

    public int getLineNumber(int inputPosition) {
        return StringUtil.offsetToLineColumn((CharSequence)((CharSequence)this.text), (int)inputPosition).line + 1;
    }

    public int getColumnNumber(int inputPosition) {
        return StringUtil.offsetToLineColumn((CharSequence)((CharSequence)this.text), (int)inputPosition).column;
    }
}

