/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import androidx.annotation.VisibleForTesting;
import com.facebook.common.memory.PooledByteBufferOutputStream;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imagepipeline.memory.MemoryChunk;
import com.facebook.imagepipeline.memory.MemoryChunkPool;
import com.facebook.imagepipeline.memory.MemoryPooledByteBuffer;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0019B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0005H\u0007J\b\u0010\u0018\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/facebook/imagepipeline/memory/MemoryPooledByteBufferOutputStream;", "Lcom/facebook/common/memory/PooledByteBufferOutputStream;", "pool", "Lcom/facebook/imagepipeline/memory/MemoryChunkPool;", "initialCapacity", "", "<init>", "(Lcom/facebook/imagepipeline/memory/MemoryChunkPool;I)V", "bufRef", "Lcom/facebook/common/references/CloseableReference;", "Lcom/facebook/imagepipeline/memory/MemoryChunk;", "count", "toByteBuffer", "Lcom/facebook/imagepipeline/memory/MemoryPooledByteBuffer;", "size", "write", "", "oneByte", "buffer", "", "offset", "close", "realloc", "newLength", "ensureValid", "InvalidStreamException", "imagepipeline_release"})
@NotThreadSafe
public final class MemoryPooledByteBufferOutputStream
extends PooledByteBufferOutputStream {
    @NotNull
    private final MemoryChunkPool pool;
    @Nullable
    private CloseableReference<MemoryChunk> bufRef;
    private int count;

    @JvmOverloads
    public MemoryPooledByteBufferOutputStream(@NotNull MemoryChunkPool pool, int initialCapacity) {
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        if (!(initialCapacity > 0)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.pool = pool;
        this.count = 0;
        this.bufRef = CloseableReference.of(this.pool.get(initialCapacity), (ResourceReleaser)((ResourceReleaser)this.pool));
    }

    public /* synthetic */ MemoryPooledByteBufferOutputStream(MemoryChunkPool memoryChunkPool, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = memoryChunkPool.getMinBufferSize();
        }
        this(memoryChunkPool, n);
    }

    @NotNull
    public MemoryPooledByteBuffer toByteBuffer() {
        this.ensureValid();
        CloseableReference<MemoryChunk> closeableReference = this.bufRef;
        if (closeableReference == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return new MemoryPooledByteBuffer(closeableReference, this.count);
    }

    public int size() {
        return this.count;
    }

    public void write(int oneByte) throws IOException {
        byte[] buf = new byte[]{(byte)oneByte};
        this.write(buf);
    }

    public void write(@NotNull byte[] buffer, int offset, int count) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (offset < 0 || count < 0 || offset + count > buffer.length) {
            throw new ArrayIndexOutOfBoundsException("length=" + buffer.length + "; regionStart=" + offset + "; regionLength=" + count);
        }
        this.ensureValid();
        this.realloc(this.count + count);
        CloseableReference<MemoryChunk> closeableReference = this.bufRef;
        if (closeableReference == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        ((MemoryChunk)closeableReference.get()).write(this.count, buffer, offset, count);
        this.count += count;
    }

    public void close() {
        CloseableReference.closeSafely(this.bufRef);
        this.bufRef = null;
        this.count = -1;
        super.close();
    }

    @VisibleForTesting
    public final void realloc(int newLength) {
        this.ensureValid();
        if (this.bufRef == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        CloseableReference<MemoryChunk> closeableReference = this.bufRef;
        Intrinsics.checkNotNull(closeableReference);
        if (newLength <= ((MemoryChunk)closeableReference.get()).getSize()) {
            return;
        }
        Object v = this.pool.get(newLength);
        Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
        MemoryChunk newbuf = (MemoryChunk)v;
        if (this.bufRef == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        CloseableReference<MemoryChunk> closeableReference2 = this.bufRef;
        Intrinsics.checkNotNull(closeableReference2);
        ((MemoryChunk)closeableReference2.get()).copy(0, newbuf, 0, this.count);
        CloseableReference<MemoryChunk> closeableReference3 = this.bufRef;
        Intrinsics.checkNotNull(closeableReference3);
        closeableReference3.close();
        this.bufRef = CloseableReference.of((Object)newbuf, (ResourceReleaser)((ResourceReleaser)this.pool));
    }

    private final void ensureValid() {
        if (!CloseableReference.isValid(this.bufRef)) {
            throw new InvalidStreamException();
        }
    }

    @JvmOverloads
    public MemoryPooledByteBufferOutputStream(@NotNull MemoryChunkPool pool) {
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        this(pool, 0, 2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00060\u0002j\u0002`\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/facebook/imagepipeline/memory/MemoryPooledByteBufferOutputStream$InvalidStreamException;", "Lkotlin/RuntimeException;", "Ljava/lang/RuntimeException;", "<init>", "()V", "imagepipeline_release"})
    public static final class InvalidStreamException
    extends RuntimeException {
        public InvalidStreamException() {
            super("OutputStream no longer valid");
        }
    }
}

