/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.bitmaps;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.webp.BitmapCreator;
import com.facebook.imageformat.DefaultImageFormats;
import com.facebook.imagepipeline.bitmaps.EmptyJpegGenerator;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.FlexByteArrayPool;
import com.facebook.imagepipeline.memory.PoolFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/imagepipeline/bitmaps/HoneycombBitmapCreator;", "Lcom/facebook/common/webp/BitmapCreator;", "poolFactory", "Lcom/facebook/imagepipeline/memory/PoolFactory;", "<init>", "(Lcom/facebook/imagepipeline/memory/PoolFactory;)V", "jpegGenerator", "Lcom/facebook/imagepipeline/bitmaps/EmptyJpegGenerator;", "flexByteArrayPool", "Lcom/facebook/imagepipeline/memory/FlexByteArrayPool;", "createNakedBitmap", "Landroid/graphics/Bitmap;", "width", "", "height", "bitmapConfig", "Landroid/graphics/Bitmap$Config;", "Companion", "imagepipeline_release"})
public final class HoneycombBitmapCreator
implements BitmapCreator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EmptyJpegGenerator jpegGenerator;
    @NotNull
    private final FlexByteArrayPool flexByteArrayPool;

    public HoneycombBitmapCreator(@NotNull PoolFactory poolFactory) {
        Intrinsics.checkNotNullParameter((Object)poolFactory, (String)"poolFactory");
        this.jpegGenerator = new EmptyJpegGenerator(poolFactory.getPooledByteBufferFactory());
        FlexByteArrayPool flexByteArrayPool = poolFactory.getFlexByteArrayPool();
        Intrinsics.checkNotNullExpressionValue((Object)flexByteArrayPool, (String)"getFlexByteArrayPool(...)");
        this.flexByteArrayPool = flexByteArrayPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Bitmap createNakedBitmap(int width, int height, @NotNull Bitmap.Config bitmapConfig) {
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)bitmapConfig, (String)"bitmapConfig");
        CloseableReference<PooledByteBuffer> closeableReference = this.jpegGenerator.generate((short)width, (short)height);
        Intrinsics.checkNotNullExpressionValue(closeableReference, (String)"generate(...)");
        CloseableReference<PooledByteBuffer> jpgRef = closeableReference;
        EncodedImage encodedImage = null;
        CloseableReference<byte[]> encodedBytesArrayRef = null;
        try {
            encodedImage = new EncodedImage(jpgRef);
            encodedImage.setImageFormat(DefaultImageFormats.JPEG);
            BitmapFactory.Options options = HoneycombBitmapCreator.Companion.getBitmapFactoryOptions(encodedImage.getSampleSize(), bitmapConfig);
            int length = ((PooledByteBuffer)jpgRef.get()).size();
            Object object = jpgRef.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            PooledByteBuffer pooledByteBuffer = (PooledByteBuffer)object;
            encodedBytesArrayRef = this.flexByteArrayPool.get(length + 2);
            Object object2 = encodedBytesArrayRef.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            byte[] encodedBytesArray = (byte[])object2;
            pooledByteBuffer.read(0, encodedBytesArray, 0, length);
            Bitmap bitmap2 = BitmapFactory.decodeByteArray((byte[])encodedBytesArray, (int)0, (int)length, (BitmapFactory.Options)options);
            if (bitmap2 == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            Bitmap bitmap3 = bitmap2;
            bitmap3.setHasAlpha(true);
            bitmap3.eraseColor(0);
            bitmap = bitmap3;
        }
        finally {
            CloseableReference.closeSafely(encodedBytesArrayRef);
            EncodedImage.closeSafely((EncodedImage)encodedImage);
            CloseableReference.closeSafely(jpgRef);
        }
        return bitmap;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lcom/facebook/imagepipeline/bitmaps/HoneycombBitmapCreator$Companion;", "", "<init>", "()V", "getBitmapFactoryOptions", "Landroid/graphics/BitmapFactory$Options;", "sampleSize", "", "bitmapConfig", "Landroid/graphics/Bitmap$Config;", "imagepipeline_release"})
    public static final class Companion {
        private Companion() {
        }

        private final BitmapFactory.Options getBitmapFactoryOptions(int sampleSize, Bitmap.Config bitmapConfig) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inDither = true;
            options.inPreferredConfig = bitmapConfig;
            options.inPurgeable = true;
            options.inInputShareable = true;
            options.inSampleSize = sampleSize;
            options.inMutable = true;
            return options;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

