/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.core;

import com.facebook.imagepipeline.core.ExecutorSupplier;
import com.facebook.imagepipeline.core.PriorityThreadFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u0007H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/facebook/imagepipeline/core/DefaultExecutorSupplier;", "Lcom/facebook/imagepipeline/core/ExecutorSupplier;", "numCpuBoundThreads", "", "<init>", "(I)V", "ioBoundExecutor", "Ljava/util/concurrent/Executor;", "decodeExecutor", "backgroundExecutor", "lightWeightBackgroundExecutor", "backgroundScheduledExecutorService", "Ljava/util/concurrent/ScheduledExecutorService;", "forLocalStorageRead", "forLocalStorageWrite", "forDecode", "forBackgroundTasks", "scheduledExecutorServiceForBackgroundTasks", "forLightweightBackgroundTasks", "forThumbnailProducer", "Companion", "imagepipeline-base_release"})
public final class DefaultExecutorSupplier
implements ExecutorSupplier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Executor ioBoundExecutor;
    @NotNull
    private final Executor decodeExecutor;
    @NotNull
    private final Executor backgroundExecutor;
    @NotNull
    private final Executor lightWeightBackgroundExecutor;
    @NotNull
    private final ScheduledExecutorService backgroundScheduledExecutorService;
    private static final int NUM_IO_BOUND_THREADS = 2;
    private static final int NUM_LIGHTWEIGHT_BACKGROUND_THREADS = 1;

    public DefaultExecutorSupplier(int numCpuBoundThreads) {
        ExecutorService executorService = Executors.newFixedThreadPool(2, new PriorityThreadFactory(10, "FrescoIoBoundExecutor", true));
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newFixedThreadPool(...)");
        this.ioBoundExecutor = executorService;
        ExecutorService executorService2 = Executors.newFixedThreadPool(numCpuBoundThreads, new PriorityThreadFactory(10, "FrescoDecodeExecutor", true));
        Intrinsics.checkNotNullExpressionValue((Object)executorService2, (String)"newFixedThreadPool(...)");
        this.decodeExecutor = executorService2;
        ExecutorService executorService3 = Executors.newFixedThreadPool(numCpuBoundThreads, new PriorityThreadFactory(10, "FrescoBackgroundExecutor", true));
        Intrinsics.checkNotNullExpressionValue((Object)executorService3, (String)"newFixedThreadPool(...)");
        this.backgroundExecutor = executorService3;
        ExecutorService executorService4 = Executors.newFixedThreadPool(1, new PriorityThreadFactory(10, "FrescoLightWeightBackgroundExecutor", true));
        Intrinsics.checkNotNullExpressionValue((Object)executorService4, (String)"newFixedThreadPool(...)");
        this.lightWeightBackgroundExecutor = executorService4;
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(numCpuBoundThreads, new PriorityThreadFactory(10, "FrescoBackgroundExecutor", true));
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newScheduledThreadPool(...)");
        this.backgroundScheduledExecutorService = scheduledExecutorService;
    }

    @Override
    @NotNull
    public Executor forLocalStorageRead() {
        return this.ioBoundExecutor;
    }

    @Override
    @NotNull
    public Executor forLocalStorageWrite() {
        return this.ioBoundExecutor;
    }

    @Override
    @NotNull
    public Executor forDecode() {
        return this.decodeExecutor;
    }

    @Override
    @NotNull
    public Executor forBackgroundTasks() {
        return this.backgroundExecutor;
    }

    @Override
    @Nullable
    public ScheduledExecutorService scheduledExecutorServiceForBackgroundTasks() {
        return this.backgroundScheduledExecutorService;
    }

    @Override
    @NotNull
    public Executor forLightweightBackgroundTasks() {
        return this.lightWeightBackgroundExecutor;
    }

    @Override
    @NotNull
    public Executor forThumbnailProducer() {
        return this.ioBoundExecutor;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/facebook/imagepipeline/core/DefaultExecutorSupplier$Companion;", "", "<init>", "()V", "NUM_IO_BOUND_THREADS", "", "NUM_LIGHTWEIGHT_BACKGROUND_THREADS", "imagepipeline-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

