/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.callercontext;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class ContextChain
implements Parcelable {
    public static final String TAG_PRODUCT = "p";
    public static final String TAG_INFRA = "i";
    public static final String TAG_PRODUCT_AND_INFRA = "pi";
    private static final char PARENT_SEPARATOR = '/';
    private final String mTag;
    private final String mName;
    @Nullable
    private final ContextChain mParent;
    @Nullable
    private Map<String, Object> mExtraData;
    @Nullable
    private String mSerializedChainString;
    private String mSerializedNodeString;
    private static boolean sUseConcurrentHashMap = false;
    public static final Parcelable.Creator<ContextChain> CREATOR = new Parcelable.Creator<ContextChain>(){

        public ContextChain createFromParcel(Parcel in) {
            return new ContextChain(in);
        }

        public ContextChain[] newArray(int size) {
            return new ContextChain[size];
        }
    };

    public ContextChain(String tag, String name, @Nullable Map<String, String> extraData, @Nullable ContextChain parent) {
        this.mTag = tag;
        this.mName = name;
        this.mSerializedNodeString = this.mTag + ":" + this.mName;
        this.mParent = parent;
        this.initializeExtraData(parent, extraData);
    }

    private void initializeExtraData(@Nullable ContextChain parent, @Nullable Map<String, ?> extraData) {
        Map<String, Object> parentExtraData = null;
        if (parent != null) {
            parentExtraData = parent.getExtraData();
        }
        if (parentExtraData != null) {
            this.mExtraData = sUseConcurrentHashMap ? new ConcurrentHashMap<String, Object>(parentExtraData) : new HashMap<String, Object>(parentExtraData);
        }
        if (extraData != null) {
            if (this.mExtraData == null) {
                this.mExtraData = sUseConcurrentHashMap ? new ConcurrentHashMap<String, Object>() : new HashMap<String, Object>();
            }
            this.mExtraData.putAll(extraData);
        }
    }

    public ContextChain(String serializedNodeString, @Nullable Map<String, Object> extraData, @Nullable ContextChain parent) {
        this.mTag = "serialized_tag";
        this.mName = "serialized_name";
        this.mSerializedNodeString = serializedNodeString;
        this.mParent = parent;
        this.initializeExtraData(parent, extraData);
    }

    public ContextChain(String serializedNodeString, @Nullable ContextChain parent) {
        this(serializedNodeString, (Map<String, Object>)null, parent);
    }

    public ContextChain(String tag, String name, @Nullable ContextChain parent) {
        this(tag, name, null, parent);
    }

    protected ContextChain(Parcel in) {
        this.mTag = in.readString();
        this.mName = in.readString();
        this.mSerializedNodeString = in.readString();
        this.mParent = (ContextChain)in.readParcelable(ContextChain.class.getClassLoader());
    }

    public static void setUseConcurrentHashMap(boolean useConcurrentHashMap) {
        sUseConcurrentHashMap = useConcurrentHashMap;
    }

    public String getName() {
        return this.mName;
    }

    public String getTag() {
        return this.mTag;
    }

    @Nullable
    public Map<String, Object> getExtraData() {
        return this.mExtraData;
    }

    @Nullable
    public ContextChain getParent() {
        return this.mParent;
    }

    public ContextChain getRootContextChain() {
        return this.mParent == null ? this : this.mParent.getRootContextChain();
    }

    @Nullable
    public String getStringExtra(String key) {
        if (this.mExtraData == null) {
            return null;
        }
        if (sUseConcurrentHashMap && key == null) {
            return null;
        }
        Object val = this.mExtraData.get(key);
        return val == null ? null : String.valueOf(val);
    }

    public void putObjectExtra(String key, Object value) {
        if (sUseConcurrentHashMap && (key == null || value == null)) {
            return;
        }
        if (this.mExtraData == null) {
            this.mExtraData = sUseConcurrentHashMap ? new ConcurrentHashMap<String, Object>() : new HashMap<String, Object>();
        }
        this.mExtraData.put(key, value);
    }

    public String toString() {
        if (this.mSerializedChainString == null) {
            this.mSerializedChainString = this.getNodeString();
            if (this.mParent != null) {
                this.mSerializedChainString = this.mParent.toString() + '/' + this.mSerializedChainString;
            }
        }
        return this.mSerializedChainString;
    }

    protected String getNodeString() {
        return this.mSerializedNodeString;
    }

    public String[] toStringArray() {
        return this.toString().split(String.valueOf('/'));
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ContextChain other = (ContextChain)obj;
        return Objects.equals(this.getNodeString(), other.getNodeString()) && Objects.equals(this.mParent, other.mParent);
    }

    public int hashCode() {
        return Objects.hash(this.mParent, this.getNodeString());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mTag);
        dest.writeString(this.mName);
        dest.writeString(this.getNodeString());
        dest.writeParcelable((Parcelable)this.mParent, flags);
    }
}

