/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.graphics.PointF;
import android.graphics.Rect;
import android.transition.ChangeBounds;
import android.transition.Transition;
import android.transition.TransitionSet;
import android.transition.TransitionValues;
import android.view.ViewGroup;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.view.GenericDraweeView;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
@TargetApi(value=19)
public class DraweeTransition
extends Transition {
    private static final String PROPNAME_BOUNDS = "draweeTransition:bounds";
    private final ScalingUtils.ScaleType mFromScale;
    private final ScalingUtils.ScaleType mToScale;
    @Nullable
    private final PointF mFromFocusPoint;
    @Nullable
    private final PointF mToFocusPoint;

    public static TransitionSet createTransitionSet(ScalingUtils.ScaleType fromScale, ScalingUtils.ScaleType toScale) {
        return DraweeTransition.createTransitionSet(fromScale, toScale, null, null);
    }

    public static TransitionSet createTransitionSet(ScalingUtils.ScaleType fromScale, ScalingUtils.ScaleType toScale, @Nullable PointF fromFocusPoint, @Nullable PointF toFocusPoint) {
        TransitionSet transitionSet = new TransitionSet();
        transitionSet.addTransition((Transition)new ChangeBounds());
        transitionSet.addTransition((Transition)new DraweeTransition(fromScale, toScale, fromFocusPoint, toFocusPoint));
        return transitionSet;
    }

    public DraweeTransition(ScalingUtils.ScaleType fromScale, ScalingUtils.ScaleType toScale, @Nullable PointF fromFocusPoint, @Nullable PointF toFocusPoint) {
        this.mFromScale = fromScale;
        this.mToScale = toScale;
        this.mFromFocusPoint = fromFocusPoint;
        this.mToFocusPoint = toFocusPoint;
    }

    public DraweeTransition(ScalingUtils.ScaleType fromScale, ScalingUtils.ScaleType toScale) {
        this(fromScale, toScale, null, null);
    }

    public void captureStartValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    public void captureEndValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    @Nullable
    public Animator createAnimator(ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
        if (startValues == null || endValues == null) {
            return null;
        }
        Rect startBounds = (Rect)startValues.values.get(PROPNAME_BOUNDS);
        Rect endBounds = (Rect)endValues.values.get(PROPNAME_BOUNDS);
        if (startBounds == null || endBounds == null) {
            return null;
        }
        if (this.mFromScale == this.mToScale && this.mFromFocusPoint == this.mToFocusPoint) {
            return null;
        }
        final GenericDraweeView draweeView = (GenericDraweeView)startValues.view;
        final ScalingUtils.InterpolatingScaleType scaleType = new ScalingUtils.InterpolatingScaleType(this.mFromScale, this.mToScale, startBounds, endBounds, this.mFromFocusPoint, this.mToFocusPoint);
        ((GenericDraweeHierarchy)draweeView.getHierarchy()).setActualImageScaleType((ScalingUtils.ScaleType)scaleType);
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float fraction = ((Float)animation.getAnimatedValue()).floatValue();
                scaleType.setValue(fraction);
            }
        });
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                ((GenericDraweeHierarchy)draweeView.getHierarchy()).setActualImageScaleType(DraweeTransition.this.mToScale);
                if (DraweeTransition.this.mToFocusPoint != null) {
                    ((GenericDraweeHierarchy)draweeView.getHierarchy()).setActualImageFocusPoint(DraweeTransition.this.mToFocusPoint);
                }
            }
        });
        return animator;
    }

    private void captureValues(TransitionValues transitionValues) {
        if (transitionValues.view instanceof GenericDraweeView) {
            transitionValues.values.put(PROPNAME_BOUNDS, new Rect(0, 0, transitionValues.view.getWidth(), transitionValues.view.getHeight()));
        }
    }
}

