/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.VisibleForTesting;
import com.facebook.drawee.drawable.DrawableUtils;
import com.facebook.drawee.drawable.RoundedDrawable;
import com.facebook.imagepipeline.systrace.FrescoSystrace;
import com.facebook.infer.annotation.Nullsafe;
import java.lang.ref.WeakReference;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class RoundedBitmapDrawable
extends RoundedDrawable {
    private static boolean sDefaultRepeatEdgePixels = false;
    private final Paint mPaint = new Paint();
    private final Paint mBorderPaint = new Paint(1);
    @Nullable
    private final Bitmap mBitmap;
    @Nullable
    private WeakReference<Bitmap> mLastBitmap;
    private boolean mRepeatEdgePixels;
    @Nullable
    private RectF mBitmapClipRect = null;

    public static void setDefaultRepeatEdgePixels(boolean defaultRepeatEdgePixels) {
        sDefaultRepeatEdgePixels = defaultRepeatEdgePixels;
    }

    public static boolean getDefaultRepeatEdgePixels() {
        return sDefaultRepeatEdgePixels;
    }

    public RoundedBitmapDrawable(Resources res, @Nullable Bitmap bitmap, @Nullable Paint paint, boolean repeatEdgePixels) {
        super((Drawable)new BitmapDrawable(res, bitmap));
        this.mBitmap = bitmap;
        if (paint != null) {
            this.mPaint.set(paint);
        }
        this.mPaint.setFlags(1);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mRepeatEdgePixels = repeatEdgePixels;
    }

    public RoundedBitmapDrawable(Resources res, @Nullable Bitmap bitmap, @Nullable Paint paint) {
        this(res, bitmap, paint, sDefaultRepeatEdgePixels);
    }

    public RoundedBitmapDrawable(Resources res, @Nullable Bitmap bitmap) {
        this(res, bitmap, null);
    }

    @Override
    protected void updateTransform() {
        super.updateTransform();
        if (!this.mRepeatEdgePixels) {
            if (this.mBitmapClipRect == null) {
                this.mBitmapClipRect = new RectF();
            }
            this.mTransform.mapRect(this.mBitmapClipRect, this.mBitmapBounds);
        }
    }

    @Override
    public void draw(Canvas canvas) {
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"RoundedBitmapDrawable#draw");
        }
        if (!this.shouldRound()) {
            super.draw(canvas);
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
            return;
        }
        this.updateTransform();
        this.updatePath();
        this.updatePaint();
        int saveCount = canvas.save();
        canvas.concat(this.mInverseParentTransform);
        if (!this.mRepeatEdgePixels && this.mBitmapClipRect != null) {
            int saveCount2 = canvas.save();
            canvas.clipRect(this.mBitmapClipRect);
            canvas.drawPath(this.mPath, this.mPaint);
            canvas.restoreToCount(saveCount2);
        } else {
            canvas.drawPath(this.mPath, this.mPaint);
        }
        if (this.mBorderWidth > 0.0f) {
            this.mBorderPaint.setStrokeWidth(this.mBorderWidth);
            this.mBorderPaint.setColor(DrawableUtils.multiplyColorAlpha(this.mBorderColor, this.mPaint.getAlpha()));
            canvas.drawPath(this.mBorderPath, this.mBorderPaint);
        }
        canvas.restoreToCount(saveCount);
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
    }

    private void updatePaint() {
        Shader shader;
        if (this.mLastBitmap == null || this.mLastBitmap.get() != this.mBitmap) {
            this.mLastBitmap = new WeakReference<Bitmap>(this.mBitmap);
            if (this.mBitmap != null) {
                this.mPaint.setShader((Shader)new BitmapShader(this.mBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
                this.mIsShaderTransformDirty = true;
            }
        }
        if (this.mIsShaderTransformDirty && (shader = this.mPaint.getShader()) != null) {
            shader.setLocalMatrix(this.mTransform);
            this.mIsShaderTransformDirty = false;
        }
        this.mPaint.setFilterBitmap(this.getPaintFilterBitmap());
    }

    public static RoundedBitmapDrawable fromBitmapDrawable(Resources res, BitmapDrawable bitmapDrawable) {
        return new RoundedBitmapDrawable(res, bitmapDrawable.getBitmap(), bitmapDrawable.getPaint());
    }

    @Override
    @VisibleForTesting
    boolean shouldRound() {
        return super.shouldRound() && this.mBitmap != null;
    }

    @Override
    public void setAlpha(int alpha) {
        super.setAlpha(alpha);
        if (alpha != this.mPaint.getAlpha()) {
            this.mPaint.setAlpha(alpha);
            super.setAlpha(alpha);
            this.invalidateSelf();
        }
    }

    @Override
    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        super.setColorFilter(colorFilter);
        this.mPaint.setColorFilter(colorFilter);
    }

    public Paint getPaint() {
        return this.mPaint;
    }

    @Override
    public void setRepeatEdgePixels(boolean repeatEdgePixels) {
        this.mRepeatEdgePixels = repeatEdgePixels;
    }

    @Nullable
    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    public boolean getRepeatEdgePixels() {
        return this.mRepeatEdgePixels;
    }
}

