/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import androidx.annotation.VisibleForTesting;
import com.facebook.drawee.drawable.ForwardingDrawable;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\nH\u0016R\u0016\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/facebook/drawee/drawable/OrientedDrawable;", "Lcom/facebook/drawee/drawable/ForwardingDrawable;", "drawable", "Landroid/graphics/drawable/Drawable;", "rotationAngle", "", "exifOrientation", "<init>", "(Landroid/graphics/drawable/Drawable;II)V", "mRotationMatrix", "Landroid/graphics/Matrix;", "getMRotationMatrix$annotations", "()V", "tempMatrix", "tempRectF", "Landroid/graphics/RectF;", "draw", "", "canvas", "Landroid/graphics/Canvas;", "getIntrinsicWidth", "getIntrinsicHeight", "onBoundsChange", "bounds", "Landroid/graphics/Rect;", "getTransform", "transform", "drawee_release"})
public final class OrientedDrawable
extends ForwardingDrawable {
    @JvmField
    @NotNull
    public final Matrix mRotationMatrix;
    private final int rotationAngle;
    private final int exifOrientation;
    @NotNull
    private final Matrix tempMatrix;
    @NotNull
    private final RectF tempRectF;

    @JvmOverloads
    public OrientedDrawable(@Nullable Drawable drawable, int rotationAngle, int exifOrientation) {
        super(drawable);
        this.mRotationMatrix = new Matrix();
        this.rotationAngle = rotationAngle - rotationAngle % 90;
        this.exifOrientation = exifOrientation >= 0 && exifOrientation <= 8 ? exifOrientation : 0;
        this.tempMatrix = new Matrix();
        this.tempRectF = new RectF();
    }

    public /* synthetic */ OrientedDrawable(Drawable drawable, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        this(drawable, n, n2);
    }

    @VisibleForTesting
    public static /* synthetic */ void getMRotationMatrix$annotations() {
    }

    @Override
    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this.rotationAngle <= 0 && (this.exifOrientation == 0 || this.exifOrientation == 1)) {
            super.draw(canvas);
            return;
        }
        int saveCount = canvas.save();
        canvas.concat(this.mRotationMatrix);
        super.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    @Override
    public int getIntrinsicWidth() {
        return this.exifOrientation == 5 || this.exifOrientation == 7 || this.rotationAngle % 180 != 0 ? super.getIntrinsicHeight() : super.getIntrinsicWidth();
    }

    @Override
    public int getIntrinsicHeight() {
        return this.exifOrientation == 5 || this.exifOrientation == 7 || this.rotationAngle % 180 != 0 ? super.getIntrinsicWidth() : super.getIntrinsicHeight();
    }

    @Override
    protected void onBoundsChange(@NotNull Rect bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Drawable drawable = this.getCurrent();
        if (drawable == null) {
            return;
        }
        Drawable underlyingDrawable = drawable;
        if (this.rotationAngle > 0 || this.exifOrientation != 0 && this.exifOrientation != 1) {
            switch (this.exifOrientation) {
                case 2: {
                    this.mRotationMatrix.setScale(-1.0f, 1.0f);
                    break;
                }
                case 4: {
                    this.mRotationMatrix.setScale(1.0f, -1.0f);
                    break;
                }
                case 5: {
                    this.mRotationMatrix.setRotate(270.0f, (float)bounds.centerX(), (float)bounds.centerY());
                    this.mRotationMatrix.postScale(1.0f, -1.0f);
                    break;
                }
                case 7: {
                    this.mRotationMatrix.setRotate(270.0f, (float)bounds.centerX(), (float)bounds.centerY());
                    this.mRotationMatrix.postScale(-1.0f, 1.0f);
                    break;
                }
                default: {
                    this.mRotationMatrix.setRotate((float)this.rotationAngle, (float)bounds.centerX(), (float)bounds.centerY());
                }
            }
            this.tempMatrix.reset();
            this.mRotationMatrix.invert(this.tempMatrix);
            this.tempRectF.set(bounds);
            this.tempMatrix.mapRect(this.tempRectF);
            underlyingDrawable.setBounds((int)this.tempRectF.left, (int)this.tempRectF.top, (int)this.tempRectF.right, (int)this.tempRectF.bottom);
        } else {
            underlyingDrawable.setBounds(bounds);
        }
    }

    @Override
    public void getTransform(@NotNull Matrix transform) {
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        this.getParentTransform(transform);
        if (!this.mRotationMatrix.isIdentity()) {
            transform.preConcat(this.mRotationMatrix);
        }
    }

    @JvmOverloads
    public OrientedDrawable(@Nullable Drawable drawable, int rotationAngle) {
        this(drawable, rotationAngle, 0, 4, null);
    }
}

