/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.graphics.Canvas;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.facebook.drawee.drawable.ForwardingDrawable;
import com.facebook.drawee.drawable.ScaleTypeDrawable;
import com.facebook.drawee.drawable.ScalingUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/drawee/drawable/InstrumentedDrawable;", "Lcom/facebook/drawee/drawable/ForwardingDrawable;", "drawable", "Landroid/graphics/drawable/Drawable;", "listener", "Lcom/facebook/drawee/drawable/InstrumentedDrawable$Listener;", "<init>", "(Landroid/graphics/drawable/Drawable;Lcom/facebook/drawee/drawable/InstrumentedDrawable$Listener;)V", "_scaleType", "", "isChecked", "", "getScaleType", "draw", "", "canvas", "Landroid/graphics/Canvas;", "Listener", "drawee_release"})
public final class InstrumentedDrawable
extends ForwardingDrawable {
    @Nullable
    private final Listener listener;
    @NotNull
    private final String _scaleType;
    private boolean isChecked;

    public InstrumentedDrawable(@NotNull Drawable drawable, @Nullable Listener listener) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        super(drawable);
        this.listener = listener;
        this._scaleType = this.getScaleType(drawable);
    }

    private final String getScaleType(Drawable drawable) {
        if (drawable instanceof ScaleTypeDrawable) {
            ScalingUtils.ScaleType type = ((ScaleTypeDrawable)drawable).getScaleType();
            return type.toString();
        }
        return "none";
    }

    @Override
    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (!this.isChecked) {
            this.isChecked = true;
            RectF bounds = new RectF();
            this.getRootBounds(bounds);
            int viewWidth = (int)bounds.width();
            int viewHeight = (int)bounds.height();
            this.getTransformedBounds(bounds);
            int scaledWidth = (int)bounds.width();
            int scaledHeight = (int)bounds.height();
            int imageWidth = this.getIntrinsicWidth();
            int imageHeight = this.getIntrinsicHeight();
            Listener listener = this.listener;
            if (listener != null) {
                listener.track(viewWidth, viewHeight, imageWidth, imageHeight, scaledWidth, scaledHeight, this._scaleType);
            }
        }
        super.draw(canvas);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001JB\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\fH&\u00a8\u0006\r"}, d2={"Lcom/facebook/drawee/drawable/InstrumentedDrawable$Listener;", "", "track", "", "viewWidth", "", "viewHeight", "imageWidth", "imageHeight", "scaledWidth", "scaledHeight", "scaleType", "", "drawee_release"})
    public static interface Listener {
        public void track(int var1, int var2, int var3, int var4, int var5, int var6, @Nullable String var7);
    }
}

