/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.animated.impl;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableBackend;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableFrameInfo;
import com.facebook.imagepipeline.animated.base.AnimatedImage;
import com.facebook.imagepipeline.animated.base.AnimatedImageFrame;
import com.facebook.imagepipeline.animated.base.AnimatedImageResult;
import com.facebook.imagepipeline.animated.util.AnimatedDrawableUtil;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class AnimatedDrawableBackendImpl
implements AnimatedDrawableBackend {
    private final AnimatedDrawableUtil mAnimatedDrawableUtil;
    private final AnimatedImageResult mAnimatedImageResult;
    private final AnimatedImage mAnimatedImage;
    private final Rect mRenderedBounds;
    private final int[] mFrameDurationsMs;
    private final int[] mFrameTimestampsMs;
    private final int mDurationMs;
    private final AnimatedDrawableFrameInfo[] mFrameInfos;
    private final Rect mRenderSrcRect = new Rect();
    private final Rect mRenderDstRect = new Rect();
    private final boolean mDownscaleFrameToDrawableDimensions;
    private final Paint mTransparentPaint;
    @Nullable
    @GuardedBy(value="this")
    private Bitmap mTempBitmap;

    public AnimatedDrawableBackendImpl(AnimatedDrawableUtil animatedDrawableUtil, AnimatedImageResult animatedImageResult, @Nullable Rect bounds, boolean downscaleFrameToDrawableDimensions) {
        this.mAnimatedDrawableUtil = animatedDrawableUtil;
        this.mAnimatedImageResult = animatedImageResult;
        this.mAnimatedImage = animatedImageResult.getImage();
        this.mFrameDurationsMs = this.mAnimatedImage.getFrameDurations();
        this.mAnimatedDrawableUtil.fixFrameDurations(this.mFrameDurationsMs);
        this.mDurationMs = this.mAnimatedDrawableUtil.getTotalDurationFromFrameDurations(this.mFrameDurationsMs);
        this.mFrameTimestampsMs = this.mAnimatedDrawableUtil.getFrameTimeStampsFromDurations(this.mFrameDurationsMs);
        this.mRenderedBounds = AnimatedDrawableBackendImpl.getBoundsToUse(this.mAnimatedImage, bounds);
        this.mDownscaleFrameToDrawableDimensions = downscaleFrameToDrawableDimensions;
        this.mFrameInfos = new AnimatedDrawableFrameInfo[this.mAnimatedImage.getFrameCount()];
        for (int i = 0; i < this.mAnimatedImage.getFrameCount(); ++i) {
            this.mFrameInfos[i] = this.mAnimatedImage.getFrameInfo(i);
        }
        this.mTransparentPaint = new Paint();
        this.mTransparentPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
    }

    private static Rect getBoundsToUse(AnimatedImage image, @Nullable Rect targetBounds) {
        if (targetBounds == null) {
            return new Rect(0, 0, image.getWidth(), image.getHeight());
        }
        return new Rect(0, 0, Math.min(targetBounds.width(), image.getWidth()), Math.min(targetBounds.height(), image.getHeight()));
    }

    @Override
    public AnimatedImageResult getAnimatedImageResult() {
        return this.mAnimatedImageResult;
    }

    @Override
    public int getDurationMs() {
        return this.mDurationMs;
    }

    @Override
    public int getFrameCount() {
        return this.mAnimatedImage.getFrameCount();
    }

    @Override
    public int getLoopCount() {
        return this.mAnimatedImage.getLoopCount();
    }

    @Override
    public int getWidth() {
        return this.mAnimatedImage.getWidth();
    }

    @Override
    public int getHeight() {
        return this.mAnimatedImage.getHeight();
    }

    @Override
    public int getRenderedWidth() {
        return this.mRenderedBounds.width();
    }

    @Override
    public int getRenderedHeight() {
        return this.mRenderedBounds.height();
    }

    @Override
    public AnimatedDrawableFrameInfo getFrameInfo(int frameNumber) {
        return this.mFrameInfos[frameNumber];
    }

    @Override
    public int getFrameForTimestampMs(int timestampMs) {
        return this.mAnimatedDrawableUtil.getFrameForTimestampMs(this.mFrameTimestampsMs, timestampMs);
    }

    @Override
    public int getTimestampMsForFrame(int frameNumber) {
        Preconditions.checkElementIndex((int)frameNumber, (int)this.mFrameTimestampsMs.length);
        return this.mFrameTimestampsMs[frameNumber];
    }

    @Override
    public int getDurationMsForFrame(int frameNumber) {
        return this.mFrameDurationsMs[frameNumber];
    }

    @Override
    public int getFrameForPreview() {
        return this.mAnimatedImageResult.getFrameForPreview();
    }

    @Override
    public AnimatedDrawableBackend forNewBounds(@Nullable Rect bounds) {
        Rect boundsToUse = AnimatedDrawableBackendImpl.getBoundsToUse(this.mAnimatedImage, bounds);
        if (boundsToUse.equals((Object)this.mRenderedBounds)) {
            return this;
        }
        return new AnimatedDrawableBackendImpl(this.mAnimatedDrawableUtil, this.mAnimatedImageResult, bounds, this.mDownscaleFrameToDrawableDimensions);
    }

    @Override
    public synchronized int getMemoryUsage() {
        int bytes = 0;
        if (this.mTempBitmap != null) {
            bytes += this.mAnimatedDrawableUtil.getSizeOfBitmap(this.mTempBitmap);
        }
        return bytes += this.mAnimatedImage.getSizeInBytes();
    }

    @Override
    @Nullable
    public CloseableReference<Bitmap> getPreDecodedFrame(int frameNumber) {
        return this.mAnimatedImageResult.getDecodedFrame(frameNumber);
    }

    @Override
    public boolean hasPreDecodedFrame(int index) {
        return this.mAnimatedImageResult.hasDecodedFrame(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderFrame(int frameNumber, Canvas canvas) {
        AnimatedImageFrame frame = this.mAnimatedImage.getFrame(frameNumber);
        try {
            if (frame.getWidth() <= 0 || frame.getHeight() <= 0) {
                return;
            }
            if (this.mAnimatedImage.doesRenderSupportScaling()) {
                this.renderImageSupportsScaling(canvas, frame);
            } else {
                this.renderImageDoesNotSupportScaling(canvas, frame);
            }
        }
        finally {
            frame.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderDeltas(int frameNumber, Canvas canvas) {
        AnimatedImageFrame frame = this.mAnimatedImage.getFrame(frameNumber);
        AnimatedDrawableFrameInfo frameInfo = this.mAnimatedImage.getFrameInfo(frameNumber);
        AnimatedDrawableFrameInfo previousFrameInfo = frameNumber == 0 ? null : this.mAnimatedImage.getFrameInfo(frameNumber - 1);
        try {
            if (frame.getWidth() <= 0 || frame.getHeight() <= 0) {
                return;
            }
            if (this.mAnimatedImage.doesRenderSupportScaling()) {
                this.renderScalingFrames(canvas, frame, frameInfo, previousFrameInfo);
            } else {
                this.renderNonScalingFrames(canvas, frame, frameInfo, previousFrameInfo);
            }
        }
        finally {
            frame.dispose();
        }
    }

    private synchronized Bitmap prepareTempBitmapForThisSize(int width, int height) {
        if (this.mTempBitmap != null && (this.mTempBitmap.getWidth() < width || this.mTempBitmap.getHeight() < height)) {
            this.clearTempBitmap();
        }
        if (this.mTempBitmap == null) {
            this.mTempBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        this.mTempBitmap.eraseColor(0);
        return this.mTempBitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderImageSupportsScaling(Canvas canvas, AnimatedImageFrame frame) {
        double xScale = (double)this.mRenderedBounds.width() / (double)this.mAnimatedImage.getWidth();
        double yScale = (double)this.mRenderedBounds.height() / (double)this.mAnimatedImage.getHeight();
        int frameWidth = (int)Math.round((double)frame.getWidth() * xScale);
        int frameHeight = (int)Math.round((double)frame.getHeight() * yScale);
        int xOffset = (int)((double)frame.getXOffset() * xScale);
        int yOffset = (int)((double)frame.getYOffset() * yScale);
        AnimatedDrawableBackendImpl animatedDrawableBackendImpl = this;
        synchronized (animatedDrawableBackendImpl) {
            int renderedWidth = this.mRenderedBounds.width();
            int renderedHeight = this.mRenderedBounds.height();
            this.prepareTempBitmapForThisSize(renderedWidth, renderedHeight);
            if (this.mTempBitmap != null) {
                frame.renderFrame(frameWidth, frameHeight, this.mTempBitmap);
            }
            this.mRenderSrcRect.set(0, 0, renderedWidth, renderedHeight);
            this.mRenderDstRect.set(xOffset, yOffset, xOffset + renderedWidth, yOffset + renderedHeight);
            if (this.mTempBitmap != null) {
                canvas.drawBitmap(this.mTempBitmap, this.mRenderSrcRect, this.mRenderDstRect, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderScalingFrames(Canvas canvas, AnimatedImageFrame frame, AnimatedDrawableFrameInfo frameInfo, @Nullable AnimatedDrawableFrameInfo previousFrameInfo) {
        int assetWidth = this.mAnimatedImage.getWidth();
        int assetHeight = this.mAnimatedImage.getHeight();
        float scaledWidth = assetWidth;
        float scaledHeight = assetHeight;
        float xScale = 1.0f;
        float yScale = 1.0f;
        int frameWidth = frame.getWidth();
        int frameHeight = frame.getHeight();
        int xOffset = frame.getXOffset();
        int yOffset = frame.getYOffset();
        if (scaledWidth > (float)canvas.getWidth() || scaledHeight > (float)canvas.getHeight()) {
            int maxCanvasWidth = Math.min(canvas.getWidth(), assetWidth);
            int maxCanvasHeight = Math.min(canvas.getHeight(), assetHeight);
            float assetRatio = (float)assetWidth / (float)assetHeight;
            if (maxCanvasWidth > maxCanvasHeight) {
                scaledWidth = maxCanvasWidth;
                scaledHeight = (float)maxCanvasWidth / assetRatio;
            } else {
                scaledWidth = (float)maxCanvasHeight * assetRatio;
                scaledHeight = maxCanvasHeight;
            }
            xScale = scaledWidth / (float)assetWidth;
            yScale = scaledHeight / (float)assetHeight;
            frameWidth = (int)Math.ceil((float)frame.getWidth() * xScale);
            frameHeight = (int)Math.ceil((float)frame.getHeight() * yScale);
            xOffset = (int)Math.ceil((float)frame.getXOffset() * xScale);
            yOffset = (int)Math.ceil((float)frame.getYOffset() * yScale);
        }
        Rect renderSrcRect = new Rect(0, 0, frameWidth, frameHeight);
        Rect renderDstRect = new Rect(xOffset, yOffset, xOffset + frameWidth, yOffset + frameHeight);
        if (previousFrameInfo != null) {
            this.maybeDisposeBackground(canvas, xScale, yScale, previousFrameInfo);
        }
        if (frameInfo.blendOperation == AnimatedDrawableFrameInfo.BlendOperation.NO_BLEND) {
            canvas.drawRect(renderDstRect, this.mTransparentPaint);
        }
        AnimatedDrawableBackendImpl animatedDrawableBackendImpl = this;
        synchronized (animatedDrawableBackendImpl) {
            Bitmap frameBitmap = this.prepareTempBitmapForThisSize(frameWidth, frameHeight);
            frame.renderFrame(frameWidth, frameHeight, frameBitmap);
            canvas.drawBitmap(frameBitmap, renderSrcRect, renderDstRect, null);
        }
    }

    private void maybeDisposeBackground(Canvas canvas, float xScale, float yScale, AnimatedDrawableFrameInfo previousFrameInfo) {
        if (previousFrameInfo.disposalMethod == AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_TO_BACKGROUND) {
            int prevFrameWidth = (int)Math.ceil((float)previousFrameInfo.width * xScale);
            int prevFrameHeight = (int)Math.ceil((float)previousFrameInfo.height * yScale);
            int prevXOffset = (int)Math.ceil((float)previousFrameInfo.xOffset * xScale);
            int prevYOffset = (int)Math.ceil((float)previousFrameInfo.yOffset * yScale);
            Rect prevFrameSurface = new Rect(prevXOffset, prevYOffset, prevXOffset + prevFrameWidth, prevYOffset + prevFrameHeight);
            canvas.drawRect(prevFrameSurface, this.mTransparentPaint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderImageDoesNotSupportScaling(Canvas canvas, AnimatedImageFrame frame) {
        int yOffset;
        int xOffset;
        int frameHeight;
        int frameWidth;
        if (this.mDownscaleFrameToDrawableDimensions) {
            int fittedWidth = Math.min(frame.getWidth(), canvas.getWidth());
            int fittedHeight = Math.min(frame.getHeight(), canvas.getHeight());
            float scaleX = (float)frame.getWidth() / (float)fittedWidth;
            float scaleY = (float)frame.getHeight() / (float)fittedHeight;
            float scale = Math.max(scaleX, scaleY);
            frameWidth = (int)((float)frame.getWidth() / scale);
            frameHeight = (int)((float)frame.getHeight() / scale);
            xOffset = (int)((float)frame.getXOffset() / scale);
            yOffset = (int)((float)frame.getYOffset() / scale);
        } else {
            frameWidth = frame.getWidth();
            frameHeight = frame.getHeight();
            xOffset = frame.getXOffset();
            yOffset = frame.getYOffset();
        }
        AnimatedDrawableBackendImpl animatedDrawableBackendImpl = this;
        synchronized (animatedDrawableBackendImpl) {
            this.mTempBitmap = this.prepareTempBitmapForThisSize(frameWidth, frameHeight);
            frame.renderFrame(frameWidth, frameHeight, this.mTempBitmap);
            canvas.save();
            canvas.translate((float)xOffset, (float)yOffset);
            canvas.drawBitmap(this.mTempBitmap, 0.0f, 0.0f, null);
            canvas.restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderNonScalingFrames(Canvas canvas, AnimatedImageFrame frame, AnimatedDrawableFrameInfo frameInfo, @Nullable AnimatedDrawableFrameInfo previousFrameInfo) {
        if (this.mRenderedBounds == null || this.mRenderedBounds.width() <= 0 || this.mRenderedBounds.height() <= 0) {
            return;
        }
        float scale = (float)canvas.getWidth() / (float)this.mRenderedBounds.width();
        if (previousFrameInfo != null) {
            this.maybeDisposeBackground(canvas, scale, scale, previousFrameInfo);
        }
        int frameWidth = frame.getWidth();
        int frameHeight = frame.getHeight();
        Rect src = new Rect(0, 0, frameWidth, frameHeight);
        int resizedWidth = (int)((float)frameWidth * scale);
        int resizedHeight = (int)((float)frameHeight * scale);
        int xOffset = (int)((float)frame.getXOffset() * scale);
        int yOffset = (int)((float)frame.getYOffset() * scale);
        Rect renderDstRect = new Rect(xOffset, yOffset, xOffset + resizedWidth, yOffset + resizedHeight);
        if (frameInfo.blendOperation == AnimatedDrawableFrameInfo.BlendOperation.NO_BLEND) {
            canvas.drawRect(renderDstRect, this.mTransparentPaint);
        }
        AnimatedDrawableBackendImpl animatedDrawableBackendImpl = this;
        synchronized (animatedDrawableBackendImpl) {
            Bitmap bitmap = this.prepareTempBitmapForThisSize(frameWidth, frameHeight);
            frame.renderFrame(frameWidth, frameHeight, bitmap);
            canvas.drawBitmap(bitmap, src, renderDstRect, null);
        }
    }

    @Override
    public synchronized void dropCaches() {
        this.clearTempBitmap();
    }

    private synchronized void clearTempBitmap() {
        if (this.mTempBitmap != null) {
            this.mTempBitmap.recycle();
            this.mTempBitmap = null;
        }
    }
}

