/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.bitmap.cache;

import android.graphics.Bitmap;
import android.util.SparseArray;
import androidx.annotation.VisibleForTesting;
import com.facebook.common.logging.FLog;
import com.facebook.common.references.CloseableReference;
import com.facebook.fresco.animation.bitmap.BitmapFrameCache;
import com.facebook.imagepipeline.animated.impl.AnimatedFrameCache;
import com.facebook.imagepipeline.image.CloseableBitmap;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.CloseableStaticBitmap;
import com.facebook.imagepipeline.image.ImmutableQualityInfo;
import com.facebook.imagepipeline.image.QualityInfo;
import com.facebook.imageutils.BitmapUtil;
import java.io.Closeable;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\u0018\u0000 )2\u00020\u0001:\u0001)B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u0011\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J&\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\u0006\u0010\u001d\u001a\u00020\u0010H\u0016J&\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\u0006\u0010\u001d\u001a\u00020\u0010H\u0016J\u0012\u0010\u001f\u001a\u00020\u001a2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\"\u0010%\u001a\u00020\u00052\u0018\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\n0'H\u0016J\b\u0010(\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n0\t8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\"\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0018\u00a8\u0006*"}, d2={"Lcom/facebook/fresco/animation/bitmap/cache/FrescoFrameCache;", "Lcom/facebook/fresco/animation/bitmap/BitmapFrameCache;", "animatedFrameCache", "Lcom/facebook/imagepipeline/animated/impl/AnimatedFrameCache;", "enableBitmapReusing", "", "<init>", "(Lcom/facebook/imagepipeline/animated/impl/AnimatedFrameCache;Z)V", "preparedPendingFrames", "Landroid/util/SparseArray;", "Lcom/facebook/common/references/CloseableReference;", "Lcom/facebook/imagepipeline/image/CloseableImage;", "lastRenderedItem", "getCachedFrame", "Landroid/graphics/Bitmap;", "frameNumber", "", "getFallbackFrame", "getBitmapToReuseForFrame", "width", "height", "contains", "sizeInBytes", "getSizeInBytes", "()I", "clear", "", "onFrameRendered", "bitmapReference", "frameType", "onFramePrepared", "setFrameCacheListener", "frameCacheListener", "Lcom/facebook/fresco/animation/bitmap/BitmapFrameCache$FrameCacheListener;", "preparedPendingFramesSizeBytes", "getPreparedPendingFramesSizeBytes", "removePreparedReference", "onAnimationPrepared", "frameBitmaps", "", "isAnimationReady", "Companion", "animated-base_release"})
public final class FrescoFrameCache
implements BitmapFrameCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnimatedFrameCache animatedFrameCache;
    private final boolean enableBitmapReusing;
    @GuardedBy(value="this")
    @NotNull
    private final SparseArray<CloseableReference<CloseableImage>> preparedPendingFrames;
    @GuardedBy(value="this")
    @Nullable
    private CloseableReference<CloseableImage> lastRenderedItem;
    @NotNull
    private static final Class<?> TAG = FrescoFrameCache.class;

    public FrescoFrameCache(@NotNull AnimatedFrameCache animatedFrameCache, boolean enableBitmapReusing) {
        Intrinsics.checkNotNullParameter((Object)animatedFrameCache, (String)"animatedFrameCache");
        this.animatedFrameCache = animatedFrameCache;
        this.enableBitmapReusing = enableBitmapReusing;
        this.preparedPendingFrames = new SparseArray();
    }

    @Nullable
    public synchronized CloseableReference<Bitmap> getCachedFrame(int frameNumber) {
        return Companion.convertToBitmapReferenceAndClose(this.animatedFrameCache.get(frameNumber));
    }

    @Nullable
    public synchronized CloseableReference<Bitmap> getFallbackFrame(int frameNumber) {
        return Companion.convertToBitmapReferenceAndClose((CloseableReference<CloseableImage>)CloseableReference.cloneOrNull(this.lastRenderedItem));
    }

    @Nullable
    public synchronized CloseableReference<Bitmap> getBitmapToReuseForFrame(int frameNumber, int width, int height) {
        if (!this.enableBitmapReusing) {
            return null;
        }
        return Companion.convertToBitmapReferenceAndClose(this.animatedFrameCache.getForReuse());
    }

    public synchronized boolean contains(int frameNumber) {
        return this.animatedFrameCache.contains(frameNumber);
    }

    public synchronized int getSizeInBytes() {
        return FrescoFrameCache.Companion.getBitmapSizeBytes((CloseableReference<CloseableImage>)this.lastRenderedItem) + this.getPreparedPendingFramesSizeBytes();
    }

    public synchronized void clear() {
        CloseableReference.closeSafely(this.lastRenderedItem);
        this.lastRenderedItem = null;
        int n = this.preparedPendingFrames.size();
        for (int i = 0; i < n; ++i) {
            CloseableReference.closeSafely((CloseableReference)((CloseableReference)this.preparedPendingFrames.valueAt(i)));
        }
        this.preparedPendingFrames.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onFrameRendered(int frameNumber, @NotNull CloseableReference<Bitmap> bitmapReference, int frameType) {
        Intrinsics.checkNotNullParameter(bitmapReference, (String)"bitmapReference");
        this.removePreparedReference(frameNumber);
        CloseableReference closableReference = null;
        try {
            closableReference = FrescoFrameCache.Companion.createImageReference((CloseableReference<Bitmap>)bitmapReference);
            if (closableReference != null) {
                CloseableReference.closeSafely(this.lastRenderedItem);
                this.lastRenderedItem = this.animatedFrameCache.cache(frameNumber, (CloseableReference<CloseableImage>)closableReference);
            }
        }
        catch (Throwable throwable) {
            CloseableReference.closeSafely(closableReference);
            throw throwable;
        }
        CloseableReference.closeSafely((CloseableReference)closableReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onFramePrepared(int frameNumber, @NotNull CloseableReference<Bitmap> bitmapReference, int frameType) {
        CloseableReference closableReference;
        block4: {
            Intrinsics.checkNotNullParameter(bitmapReference, (String)"bitmapReference");
            closableReference = null;
            try {
                closableReference = FrescoFrameCache.Companion.createImageReference((CloseableReference<Bitmap>)bitmapReference);
                if (closableReference != null) break block4;
            }
            catch (Throwable throwable) {
                CloseableReference.closeSafely(closableReference);
                throw throwable;
            }
            CloseableReference.closeSafely((CloseableReference)closableReference);
            return;
        }
        CloseableReference<CloseableImage> newReference = this.animatedFrameCache.cache(frameNumber, (CloseableReference<CloseableImage>)closableReference);
        if (CloseableReference.isValid(newReference)) {
            CloseableReference oldReference = (CloseableReference)this.preparedPendingFrames.get(frameNumber);
            CloseableReference.closeSafely((CloseableReference)oldReference);
            this.preparedPendingFrames.put(frameNumber, newReference);
            FLog.v(TAG, (String)"cachePreparedFrame(%d) cached. Pending frames: %s", (Object)frameNumber, this.preparedPendingFrames);
        }
        CloseableReference.closeSafely((CloseableReference)closableReference);
    }

    public void setFrameCacheListener(@Nullable BitmapFrameCache.FrameCacheListener frameCacheListener) {
    }

    private final synchronized int getPreparedPendingFramesSizeBytes() {
        int size = 0;
        int n = this.preparedPendingFrames.size();
        for (int i = 0; i < n; ++i) {
            size += FrescoFrameCache.Companion.getBitmapSizeBytes((CloseableReference<CloseableImage>)((CloseableReference)this.preparedPendingFrames.valueAt(i)));
        }
        return size;
    }

    private final synchronized void removePreparedReference(int frameNumber) {
        CloseableReference existingPendingReference = (CloseableReference)this.preparedPendingFrames.get(frameNumber);
        if (existingPendingReference != null) {
            this.preparedPendingFrames.delete(frameNumber);
            CloseableReference.closeSafely((CloseableReference)existingPendingReference);
            FLog.v(TAG, (String)"removePreparedReference(%d) removed. Pending frames: %s", (Object)frameNumber, this.preparedPendingFrames);
        }
    }

    public boolean onAnimationPrepared(@NotNull Map<Integer, ? extends CloseableReference<Bitmap>> frameBitmaps) {
        Intrinsics.checkNotNullParameter(frameBitmaps, (String)"frameBitmaps");
        return true;
    }

    public boolean isAnimationReady() {
        return false;
    }

    @JvmStatic
    @VisibleForTesting
    @Nullable
    public static final CloseableReference<Bitmap> convertToBitmapReferenceAndClose(@Nullable CloseableReference<CloseableImage> closeableImage) {
        return Companion.convertToBitmapReferenceAndClose(closeableImage);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0007H\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0007H\u0002J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0002J \u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/facebook/fresco/animation/bitmap/cache/FrescoFrameCache$Companion;", "", "<init>", "()V", "TAG", "Ljava/lang/Class;", "convertToBitmapReferenceAndClose", "Lcom/facebook/common/references/CloseableReference;", "Landroid/graphics/Bitmap;", "closeableImage", "Lcom/facebook/imagepipeline/image/CloseableImage;", "getBitmapSizeBytes", "", "imageReference", "image", "createImageReference", "bitmapReference", "animated-base_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @VisibleForTesting
        @Nullable
        public final CloseableReference<Bitmap> convertToBitmapReferenceAndClose(@Nullable CloseableReference<CloseableImage> closeableImage) {
            try {
                if (CloseableReference.isValid(closeableImage)) {
                    CloseableReference<CloseableImage> closeableReference = closeableImage;
                    Intrinsics.checkNotNull(closeableReference);
                    if (closeableReference.get() instanceof CloseableStaticBitmap) {
                        Object object = closeableImage.get();
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.facebook.imagepipeline.image.CloseableStaticBitmap");
                        CloseableStaticBitmap closeableStaticBitmap = (CloseableStaticBitmap)object;
                        CloseableReference closeableReference2 = closeableStaticBitmap.cloneUnderlyingBitmapReference();
                        return closeableReference2;
                    }
                }
                CloseableReference<Bitmap> closeableReference = null;
                return closeableReference;
            }
            finally {
                CloseableReference.closeSafely(closeableImage);
            }
        }

        private final int getBitmapSizeBytes(CloseableReference<CloseableImage> imageReference) {
            if (!CloseableReference.isValid(imageReference)) {
                return 0;
            }
            CloseableReference<CloseableImage> closeableReference = imageReference;
            Intrinsics.checkNotNull(closeableReference);
            return this.getBitmapSizeBytes((CloseableImage)closeableReference.get());
        }

        private final int getBitmapSizeBytes(CloseableImage image) {
            if (!(image instanceof CloseableBitmap)) {
                return 0;
            }
            return BitmapUtil.getSizeInBytes((Bitmap)((CloseableBitmap)image).getUnderlyingBitmap());
        }

        private final CloseableReference<CloseableImage> createImageReference(CloseableReference<Bitmap> bitmapReference) {
            CloseableStaticBitmap closeableStaticBitmap = CloseableStaticBitmap.of(bitmapReference, (QualityInfo)ImmutableQualityInfo.FULL_QUALITY, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)closeableStaticBitmap, (String)"of(...)");
            CloseableStaticBitmap closeableImage = closeableStaticBitmap;
            return CloseableReference.of((Closeable)((Closeable)closeableImage));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

