/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.animated.base;

import android.graphics.Bitmap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.animated.base.AnimatedImage;
import com.facebook.imagepipeline.animated.base.AnimatedImageResultBuilder;
import com.facebook.imagepipeline.transformation.BitmapTransformation;
import com.facebook.infer.annotation.Nullsafe;
import java.util.List;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class AnimatedImageResult {
    private final AnimatedImage mImage;
    private final int mFrameForPreview;
    @Nullable
    private String mSource;
    @Nullable
    private CloseableReference<Bitmap> mPreviewBitmap;
    @Nullable
    private List<CloseableReference<Bitmap>> mDecodedFrames;
    @Nullable
    private BitmapTransformation mBitmapTransformation;

    AnimatedImageResult(AnimatedImageResultBuilder builder) {
        this.mImage = (AnimatedImage)Preconditions.checkNotNull((Object)builder.getImage());
        this.mFrameForPreview = builder.getFrameForPreview();
        this.mPreviewBitmap = builder.getPreviewBitmap();
        this.mDecodedFrames = builder.getDecodedFrames();
        this.mBitmapTransformation = builder.getBitmapTransformation();
        this.mSource = builder.getSource();
    }

    private AnimatedImageResult(AnimatedImage image) {
        this.mImage = (AnimatedImage)Preconditions.checkNotNull((Object)image);
        this.mFrameForPreview = 0;
    }

    public static AnimatedImageResult forAnimatedImage(AnimatedImage image) {
        return new AnimatedImageResult(image);
    }

    public static AnimatedImageResultBuilder newBuilder(AnimatedImage image) {
        return new AnimatedImageResultBuilder(image);
    }

    public AnimatedImage getImage() {
        return this.mImage;
    }

    @Nullable
    public String getSource() {
        return this.mSource;
    }

    public int getFrameForPreview() {
        return this.mFrameForPreview;
    }

    @Nullable
    public synchronized CloseableReference<Bitmap> getDecodedFrame(int index) {
        if (this.mDecodedFrames != null) {
            return CloseableReference.cloneOrNull(this.mDecodedFrames.get(index));
        }
        return null;
    }

    public synchronized boolean hasDecodedFrame(int index) {
        return this.mDecodedFrames != null && this.mDecodedFrames.get(index) != null;
    }

    @Nullable
    public BitmapTransformation getBitmapTransformation() {
        return this.mBitmapTransformation;
    }

    @Nullable
    public synchronized CloseableReference<Bitmap> getPreviewBitmap() {
        return CloseableReference.cloneOrNull(this.mPreviewBitmap);
    }

    public synchronized void dispose() {
        CloseableReference.closeSafely(this.mPreviewBitmap);
        this.mPreviewBitmap = null;
        CloseableReference.closeSafely(this.mDecodedFrames);
        this.mDecodedFrames = null;
    }
}

