/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.bitmap.cache;

import android.graphics.Bitmap;
import com.facebook.common.references.CloseableReference;
import com.facebook.fresco.animation.bitmap.BitmapFrameCache;
import com.facebook.fresco.animation.bitmap.preparation.loadframe.FpsCompressorInfo;
import com.facebook.imagepipeline.animated.base.AnimatedImage;
import com.facebook.imagepipeline.animated.base.AnimatedImageResult;
import com.facebook.imagepipeline.cache.AnimatedCache;
import com.facebook.imagepipeline.cache.AnimationFrames;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 -2\u00020\u0001:\u0001-B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J*\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\n0\u0016H\u0002J\u0011\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000fH\u0096\u0002J(\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000fH\u0016J\u0018\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\u000fH\u0016J\u0018\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\u000fH\u0016J\b\u0010 \u001a\u00020\u0019H\u0016J\"\u0010!\u001a\u00020\u00192\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\n0\u0016H\u0016J&\u0010\"\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u000f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00170\n2\u0006\u0010$\u001a\u00020\u000fH\u0016J&\u0010%\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u000f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00170\n2\u0006\u0010$\u001a\u00020\u000fH\u0016J\b\u0010&\u001a\u00020\u0013H\u0002J\n\u0010'\u001a\u0004\u0018\u00010\u000bH\u0002J\u0012\u0010(\u001a\u00020\u00132\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\f\u0010+\u001a\u00020\u000f*\u00020,H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006."}, d2={"Lcom/facebook/fresco/animation/bitmap/cache/FrescoFpsCache;", "Lcom/facebook/fresco/animation/bitmap/BitmapFrameCache;", "animatedImageResult", "Lcom/facebook/imagepipeline/animated/base/AnimatedImageResult;", "fpsCompressorInfo", "Lcom/facebook/fresco/animation/bitmap/preparation/loadframe/FpsCompressorInfo;", "animatedDrawableCache", "Lcom/facebook/imagepipeline/cache/AnimatedCache;", "(Lcom/facebook/imagepipeline/animated/base/AnimatedImageResult;Lcom/facebook/fresco/animation/bitmap/preparation/loadframe/FpsCompressorInfo;Lcom/facebook/imagepipeline/cache/AnimatedCache;)V", "animationFrames", "Lcom/facebook/common/references/CloseableReference;", "Lcom/facebook/imagepipeline/cache/AnimationFrames;", "cacheKey", "", "sizeInBytes", "", "getSizeInBytes", "()I", "clear", "", "compressAnimation", "frameBitmaps", "", "Landroid/graphics/Bitmap;", "contains", "", "frameNumber", "getBitmapToReuseForFrame", "width", "height", "getCachedFrame", "getFallbackFrame", "isAnimationReady", "onAnimationPrepared", "onFramePrepared", "bitmapReference", "frameType", "onFrameRendered", "releaseCache", "safeAnimationFrames", "setFrameCacheListener", "frameCacheListener", "Lcom/facebook/fresco/animation/bitmap/BitmapFrameCache$FrameCacheListener;", "fps", "Lcom/facebook/imagepipeline/animated/base/AnimatedImage;", "Companion", "animated-base_release"})
@SourceDebugExtension(value={"SMAP\nFrescoFpsCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrescoFpsCache.kt\ncom/facebook/fresco/animation/bitmap/cache/FrescoFpsCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1855#2,2:147\n1#3:149\n*S KotlinDebug\n*F\n+ 1 FrescoFpsCache.kt\ncom/facebook/fresco/animation/bitmap/cache/FrescoFpsCache\n*L\n109#1:147,2\n*E\n"})
public final class FrescoFpsCache
implements BitmapFrameCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnimatedImageResult animatedImageResult;
    @NotNull
    private final FpsCompressorInfo fpsCompressorInfo;
    @NotNull
    private final AnimatedCache animatedDrawableCache;
    @NotNull
    private final String cacheKey;
    @Nullable
    private CloseableReference<AnimationFrames> animationFrames;
    private static final int FPS_COMPRESSION_STEP = 1;

    public FrescoFpsCache(@NotNull AnimatedImageResult animatedImageResult, @NotNull FpsCompressorInfo fpsCompressorInfo, @NotNull AnimatedCache animatedDrawableCache) {
        Intrinsics.checkNotNullParameter((Object)animatedImageResult, (String)"animatedImageResult");
        Intrinsics.checkNotNullParameter((Object)fpsCompressorInfo, (String)"fpsCompressorInfo");
        Intrinsics.checkNotNullParameter((Object)animatedDrawableCache, (String)"animatedDrawableCache");
        this.animatedImageResult = animatedImageResult;
        this.fpsCompressorInfo = fpsCompressorInfo;
        this.animatedDrawableCache = animatedDrawableCache;
        String string = this.animatedImageResult.getSource();
        if (string == null) {
            string = String.valueOf(this.animatedImageResult.getImage().hashCode());
        }
        this.cacheKey = string;
        this.animationFrames = this.animatedDrawableCache.findAnimation(this.cacheKey);
    }

    @Nullable
    public CloseableReference<Bitmap> getCachedFrame(int frameNumber) {
        AnimationFrames animationFrames = this.safeAnimationFrames();
        return animationFrames != null ? animationFrames.getFrame(frameNumber) : null;
    }

    @Nullable
    public CloseableReference<Bitmap> getFallbackFrame(int frameNumber) {
        return null;
    }

    @Nullable
    public CloseableReference<Bitmap> getBitmapToReuseForFrame(int frameNumber, int width, int height) {
        return null;
    }

    public boolean contains(int frameNumber) {
        return this.getCachedFrame(frameNumber) != null;
    }

    public int getSizeInBytes() {
        AnimationFrames animationFrames = this.safeAnimationFrames();
        return animationFrames != null ? animationFrames.getSizeBytes() : 0;
    }

    public void clear() {
        this.releaseCache();
    }

    private final void releaseCache() {
        this.animatedDrawableCache.removeAnimation(this.cacheKey);
        this.animationFrames = null;
    }

    public boolean isAnimationReady() {
        AnimationFrames animationFrames = this.safeAnimationFrames();
        Map map = animationFrames != null ? animationFrames.getFrames() : null;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map.size() > 1;
    }

    public void onFrameRendered(int frameNumber, @NotNull CloseableReference<Bitmap> bitmapReference, int frameType) {
        Intrinsics.checkNotNullParameter(bitmapReference, (String)"bitmapReference");
    }

    public void onFramePrepared(int frameNumber, @NotNull CloseableReference<Bitmap> bitmapReference, int frameType) {
        Intrinsics.checkNotNullParameter(bitmapReference, (String)"bitmapReference");
    }

    public boolean onAnimationPrepared(@NotNull Map<Integer, ? extends CloseableReference<Bitmap>> frameBitmaps) {
        Intrinsics.checkNotNullParameter(frameBitmaps, (String)"frameBitmaps");
        AnimationFrames animationFrames = this.safeAnimationFrames();
        Map map = animationFrames != null ? animationFrames.getFrames() : null;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        int loadedFramesCount = map.size();
        if (frameBitmaps.size() < loadedFramesCount) {
            return true;
        }
        this.animationFrames = this.compressAnimation(frameBitmaps);
        return this.animationFrames != null;
    }

    private final CloseableReference<AnimationFrames> compressAnimation(Map<Integer, ? extends CloseableReference<Bitmap>> frameBitmaps) {
        Intrinsics.checkNotNullExpressionValue((Object)this.animatedImageResult.getImage(), (String)"animatedImageResult.image");
        CloseableReference animationFrames = null;
        for (int fps = this.fps(v109); animationFrames == null && fps > 1; --fps) {
            FpsCompressorInfo.CompressionResult compressionResult = this.fpsCompressorInfo.compress(this.animatedImageResult.getImage().getDuration(), frameBitmaps, fps);
            AnimationFrames animation = new AnimationFrames(compressionResult.getCompressedAnim(), compressionResult.getRealToReducedIndex());
            animationFrames = this.animatedDrawableCache.saveAnimation(this.cacheKey, animation);
            if (animationFrames == null) continue;
            Iterable $this$forEach$iv = compressionResult.getRemovedFrames();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CloseableReference it = (CloseableReference)element$iv;
                boolean bl = false;
                it.close();
            }
        }
        return animationFrames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized AnimationFrames safeAnimationFrames() {
        AnimationFrames animationFrames;
        CloseableReference animatedCache;
        CloseableReference closeableReference = this.animationFrames;
        if (closeableReference == null && (closeableReference = this.animatedDrawableCache.findAnimation(this.cacheKey)) == null) {
            return null;
        }
        CloseableReference closeableReference2 = animatedCache = closeableReference;
        synchronized (closeableReference2) {
            boolean bl = false;
            animationFrames = animatedCache.isValid() ? (AnimationFrames)animatedCache.get() : null;
        }
        return animationFrames;
    }

    public void setFrameCacheListener(@Nullable BitmapFrameCache.FrameCacheListener frameCacheListener) {
    }

    private final int fps(AnimatedImage $this$fps) {
        int frameMs = $this$fps.getDuration() / RangesKt.coerceAtLeast((int)$this$fps.getFrameCount(), (int)1);
        return (int)(TimeUnit.SECONDS.toMillis(1L) / (long)RangesKt.coerceAtLeast((int)frameMs, (int)1));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/facebook/fresco/animation/bitmap/cache/FrescoFpsCache$Companion;", "", "()V", "FPS_COMPRESSION_STEP", "", "animated-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

