/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.animated.impl;

import android.net.Uri;
import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.Objects;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.cache.CountingMemoryCache;
import com.facebook.imagepipeline.image.CloseableImage;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class AnimatedFrameCache {
    private final CacheKey mImageCacheKey;
    private final CountingMemoryCache<CacheKey, CloseableImage> mBackingCache;
    private final CountingMemoryCache.EntryStateObserver<CacheKey> mEntryStateObserver;
    @GuardedBy(value="this")
    private final LinkedHashSet<CacheKey> mFreeItemsPool;

    public AnimatedFrameCache(CacheKey imageCacheKey, CountingMemoryCache<CacheKey, CloseableImage> backingCache) {
        this.mImageCacheKey = imageCacheKey;
        this.mBackingCache = backingCache;
        this.mFreeItemsPool = new LinkedHashSet();
        this.mEntryStateObserver = new CountingMemoryCache.EntryStateObserver<CacheKey>(){

            public void onExclusivityChanged(CacheKey key, boolean isExclusive) {
                AnimatedFrameCache.this.onReusabilityChange(key, isExclusive);
            }
        };
    }

    public synchronized void onReusabilityChange(CacheKey key, boolean isReusable) {
        if (isReusable) {
            this.mFreeItemsPool.add(key);
        } else {
            this.mFreeItemsPool.remove(key);
        }
    }

    @Nullable
    public CloseableReference<CloseableImage> cache(int frameIndex, CloseableReference<CloseableImage> imageRef) {
        return this.mBackingCache.cache((Object)this.keyFor(frameIndex), imageRef, this.mEntryStateObserver);
    }

    @Nullable
    public CloseableReference<CloseableImage> get(int frameIndex) {
        return this.mBackingCache.get((Object)this.keyFor(frameIndex));
    }

    public boolean contains(int frameIndex) {
        return this.mBackingCache.contains((Object)this.keyFor(frameIndex));
    }

    @Nullable
    public CloseableReference<CloseableImage> getForReuse() {
        CacheKey key;
        CloseableReference imageRef;
        do {
            if ((key = this.popFirstFreeItemKey()) != null) continue;
            return null;
        } while ((imageRef = this.mBackingCache.reuse((Object)key)) == null);
        return imageRef;
    }

    @Nullable
    private synchronized CacheKey popFirstFreeItemKey() {
        CacheKey cacheKey = null;
        Iterator iterator = this.mFreeItemsPool.iterator();
        if (iterator.hasNext()) {
            cacheKey = (CacheKey)iterator.next();
            iterator.remove();
        }
        return cacheKey;
    }

    private FrameKey keyFor(int frameIndex) {
        return new FrameKey(this.mImageCacheKey, frameIndex);
    }

    @VisibleForTesting
    static class FrameKey
    implements CacheKey {
        private final CacheKey mImageCacheKey;
        private final int mFrameIndex;

        public FrameKey(CacheKey imageCacheKey, int frameIndex) {
            this.mImageCacheKey = imageCacheKey;
            this.mFrameIndex = frameIndex;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("imageCacheKey", (Object)this.mImageCacheKey).add("frameIndex", this.mFrameIndex).toString();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof FrameKey) {
                FrameKey that = (FrameKey)o;
                return this.mImageCacheKey == that.mImageCacheKey && this.mFrameIndex == that.mFrameIndex;
            }
            return false;
        }

        public int hashCode() {
            return this.mImageCacheKey.hashCode() * 1013 + this.mFrameIndex;
        }

        public boolean containsUri(Uri uri) {
            return this.mImageCacheKey.containsUri(uri);
        }

        public String getUriString() {
            return null;
        }
    }
}

