/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.factory;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import com.facebook.cache.common.CacheKey;
import com.facebook.common.executors.DefaultSerialExecutorService;
import com.facebook.common.executors.UiThreadImmediateExecutorService;
import com.facebook.common.internal.DoNotStrip;
import com.facebook.common.internal.Supplier;
import com.facebook.common.time.MonotonicClock;
import com.facebook.common.time.RealtimeSinceBootClock;
import com.facebook.fresco.animation.factory.ExperimentalBitmapAnimationDrawableFactory;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableBackend;
import com.facebook.imagepipeline.animated.base.AnimatedImageResult;
import com.facebook.imagepipeline.animated.factory.AnimatedFactory;
import com.facebook.imagepipeline.animated.factory.AnimatedImageFactory;
import com.facebook.imagepipeline.animated.factory.AnimatedImageFactoryImpl;
import com.facebook.imagepipeline.animated.impl.AnimatedDrawableBackendImpl;
import com.facebook.imagepipeline.animated.impl.AnimatedDrawableBackendProvider;
import com.facebook.imagepipeline.animated.util.AnimatedDrawableUtil;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.cache.CountingMemoryCache;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.core.ExecutorSupplier;
import com.facebook.imagepipeline.decoder.ImageDecoder;
import com.facebook.imagepipeline.drawable.DrawableFactory;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.image.QualityInfo;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
@DoNotStrip
public class AnimatedFactoryV2Impl
implements AnimatedFactory {
    private static final int NUMBER_OF_FRAMES_TO_PREPARE = 3;
    private final PlatformBitmapFactory mPlatformBitmapFactory;
    private final ExecutorSupplier mExecutorSupplier;
    private final CountingMemoryCache<CacheKey, CloseableImage> mBackingCache;
    @Nullable
    private AnimatedImageFactory mAnimatedImageFactory;
    @Nullable
    private AnimatedDrawableBackendProvider mAnimatedDrawableBackendProvider;
    @Nullable
    private AnimatedDrawableUtil mAnimatedDrawableUtil;
    @Nullable
    private DrawableFactory mAnimatedDrawableFactory;

    @DoNotStrip
    public AnimatedFactoryV2Impl(PlatformBitmapFactory platformBitmapFactory, ExecutorSupplier executorSupplier, CountingMemoryCache<CacheKey, CloseableImage> backingCache) {
        this.mPlatformBitmapFactory = platformBitmapFactory;
        this.mExecutorSupplier = executorSupplier;
        this.mBackingCache = backingCache;
    }

    @Nullable
    public DrawableFactory getAnimatedDrawableFactory(Context context) {
        if (this.mAnimatedDrawableFactory == null) {
            this.mAnimatedDrawableFactory = this.createDrawableFactory();
        }
        return this.mAnimatedDrawableFactory;
    }

    public ImageDecoder getGifDecoder(final Bitmap.Config bitmapConfig) {
        return new ImageDecoder(){

            public CloseableImage decode(EncodedImage encodedImage, int length, QualityInfo qualityInfo, ImageDecodeOptions options) {
                return AnimatedFactoryV2Impl.this.getAnimatedImageFactory().decodeGif(encodedImage, options, bitmapConfig);
            }
        };
    }

    public ImageDecoder getWebPDecoder(final Bitmap.Config bitmapConfig) {
        return new ImageDecoder(){

            public CloseableImage decode(EncodedImage encodedImage, int length, QualityInfo qualityInfo, ImageDecodeOptions options) {
                return AnimatedFactoryV2Impl.this.getAnimatedImageFactory().decodeWebP(encodedImage, options, bitmapConfig);
            }
        };
    }

    private ExperimentalBitmapAnimationDrawableFactory createDrawableFactory() {
        Supplier<Integer> cachingStrategySupplier = new Supplier<Integer>(){

            public Integer get() {
                return 2;
            }
        };
        DefaultSerialExecutorService serialExecutorServiceForFramePreparing = new DefaultSerialExecutorService(this.mExecutorSupplier.forDecode());
        Supplier<Integer> numberOfFramesToPrepareSupplier = new Supplier<Integer>(){

            public Integer get() {
                return 3;
            }
        };
        return new ExperimentalBitmapAnimationDrawableFactory(this.getAnimatedDrawableBackendProvider(), (ScheduledExecutorService)UiThreadImmediateExecutorService.getInstance(), (ExecutorService)serialExecutorServiceForFramePreparing, (MonotonicClock)RealtimeSinceBootClock.get(), this.mPlatformBitmapFactory, this.mBackingCache, cachingStrategySupplier, numberOfFramesToPrepareSupplier);
    }

    private AnimatedDrawableUtil getAnimatedDrawableUtil() {
        if (this.mAnimatedDrawableUtil == null) {
            this.mAnimatedDrawableUtil = new AnimatedDrawableUtil();
        }
        return this.mAnimatedDrawableUtil;
    }

    private AnimatedImageFactory getAnimatedImageFactory() {
        if (this.mAnimatedImageFactory == null) {
            this.mAnimatedImageFactory = this.buildAnimatedImageFactory();
        }
        return this.mAnimatedImageFactory;
    }

    private AnimatedDrawableBackendProvider getAnimatedDrawableBackendProvider() {
        if (this.mAnimatedDrawableBackendProvider == null) {
            this.mAnimatedDrawableBackendProvider = new AnimatedDrawableBackendProvider(){

                @Override
                public AnimatedDrawableBackend get(AnimatedImageResult animatedImageResult, Rect bounds) {
                    return new AnimatedDrawableBackendImpl(AnimatedFactoryV2Impl.this.getAnimatedDrawableUtil(), animatedImageResult, bounds);
                }
            };
        }
        return this.mAnimatedDrawableBackendProvider;
    }

    private AnimatedImageFactory buildAnimatedImageFactory() {
        AnimatedDrawableBackendProvider animatedDrawableBackendProvider = new AnimatedDrawableBackendProvider(){

            @Override
            public AnimatedDrawableBackend get(AnimatedImageResult imageResult, Rect bounds) {
                return new AnimatedDrawableBackendImpl(AnimatedFactoryV2Impl.this.getAnimatedDrawableUtil(), imageResult, bounds);
            }
        };
        return new AnimatedImageFactoryImpl(animatedDrawableBackendProvider, this.mPlatformBitmapFactory);
    }
}

