/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.animated.factory;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.os.Build;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableBackend;
import com.facebook.imagepipeline.animated.base.AnimatedImage;
import com.facebook.imagepipeline.animated.base.AnimatedImageResult;
import com.facebook.imagepipeline.animated.factory.AnimatedImageDecoder;
import com.facebook.imagepipeline.animated.factory.AnimatedImageFactory;
import com.facebook.imagepipeline.animated.impl.AnimatedDrawableBackendProvider;
import com.facebook.imagepipeline.animated.impl.AnimatedImageCompositor;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.image.CloseableAnimatedImage;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.CloseableStaticBitmap;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.image.ImmutableQualityInfo;
import java.util.ArrayList;
import java.util.List;

public class AnimatedImageFactoryImpl
implements AnimatedImageFactory {
    private final AnimatedDrawableBackendProvider mAnimatedDrawableBackendProvider;
    private final PlatformBitmapFactory mBitmapFactory;
    static AnimatedImageDecoder sGifAnimatedImageDecoder = null;
    static AnimatedImageDecoder sWebpAnimatedImageDecoder = null;

    private static AnimatedImageDecoder loadIfPresent(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (AnimatedImageDecoder)clazz.newInstance();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public AnimatedImageFactoryImpl(AnimatedDrawableBackendProvider animatedDrawableBackendProvider, PlatformBitmapFactory bitmapFactory) {
        this.mAnimatedDrawableBackendProvider = animatedDrawableBackendProvider;
        this.mBitmapFactory = bitmapFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableImage decodeGif(EncodedImage encodedImage, ImageDecodeOptions options, Bitmap.Config bitmapConfig) {
        if (sGifAnimatedImageDecoder == null) {
            throw new UnsupportedOperationException("To encode animated gif please add the dependency to the animated-gif module");
        }
        CloseableReference bytesRef = encodedImage.getByteBufferRef();
        Preconditions.checkNotNull((Object)bytesRef);
        try {
            PooledByteBuffer input = (PooledByteBuffer)bytesRef.get();
            AnimatedImage gifImage = sGifAnimatedImageDecoder.decode(input.getNativePtr(), input.size());
            CloseableImage closeableImage = this.getCloseableImage(options, gifImage, bitmapConfig);
            return closeableImage;
        }
        finally {
            CloseableReference.closeSafely((CloseableReference)bytesRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableImage decodeWebP(EncodedImage encodedImage, ImageDecodeOptions options, Bitmap.Config bitmapConfig) {
        if (sWebpAnimatedImageDecoder == null) {
            throw new UnsupportedOperationException("To encode animated webp please add the dependency to the animated-webp module");
        }
        CloseableReference bytesRef = encodedImage.getByteBufferRef();
        Preconditions.checkNotNull((Object)bytesRef);
        try {
            PooledByteBuffer input = (PooledByteBuffer)bytesRef.get();
            AnimatedImage webPImage = sWebpAnimatedImageDecoder.decode(input.getNativePtr(), input.size());
            CloseableImage closeableImage = this.getCloseableImage(options, webPImage, bitmapConfig);
            return closeableImage;
        }
        finally {
            CloseableReference.closeSafely((CloseableReference)bytesRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableImage getCloseableImage(ImageDecodeOptions options, AnimatedImage image, Bitmap.Config bitmapConfig) {
        List<CloseableReference<Bitmap>> decodedFrames = null;
        CloseableReference<Bitmap> previewBitmap = null;
        try {
            int frameForPreview;
            int n = frameForPreview = options.useLastFrameForPreview ? image.getFrameCount() - 1 : 0;
            if (options.forceStaticImage) {
                CloseableStaticBitmap closeableStaticBitmap = new CloseableStaticBitmap(this.createPreviewBitmap(image, bitmapConfig, frameForPreview), ImmutableQualityInfo.FULL_QUALITY, 0);
                return closeableStaticBitmap;
            }
            if (options.decodeAllFrames) {
                decodedFrames = this.decodeAllFrames(image, bitmapConfig);
                previewBitmap = CloseableReference.cloneOrNull(decodedFrames.get(frameForPreview));
            }
            if (options.decodePreviewFrame && previewBitmap == null) {
                previewBitmap = this.createPreviewBitmap(image, bitmapConfig, frameForPreview);
            }
            AnimatedImageResult animatedImageResult = AnimatedImageResult.newBuilder(image).setPreviewBitmap(previewBitmap).setFrameForPreview(frameForPreview).setDecodedFrames(decodedFrames).build();
            CloseableAnimatedImage closeableAnimatedImage = new CloseableAnimatedImage(animatedImageResult);
            return closeableAnimatedImage;
        }
        finally {
            CloseableReference.closeSafely(previewBitmap);
            CloseableReference.closeSafely(decodedFrames);
        }
    }

    private CloseableReference<Bitmap> createPreviewBitmap(AnimatedImage image, Bitmap.Config bitmapConfig, int frameForPreview) {
        CloseableReference<Bitmap> bitmap = this.createBitmap(image.getWidth(), image.getHeight(), bitmapConfig);
        AnimatedImageResult tempResult = AnimatedImageResult.forAnimatedImage(image);
        AnimatedDrawableBackend drawableBackend = this.mAnimatedDrawableBackendProvider.get(tempResult, null);
        AnimatedImageCompositor animatedImageCompositor = new AnimatedImageCompositor(drawableBackend, new AnimatedImageCompositor.Callback(){

            @Override
            public void onIntermediateResult(int frameNumber, Bitmap bitmap) {
            }

            @Override
            public CloseableReference<Bitmap> getCachedBitmap(int frameNumber) {
                return null;
            }
        });
        animatedImageCompositor.renderFrame(frameForPreview, (Bitmap)bitmap.get());
        return bitmap;
    }

    private List<CloseableReference<Bitmap>> decodeAllFrames(AnimatedImage image, Bitmap.Config bitmapConfig) {
        AnimatedImageResult tempResult = AnimatedImageResult.forAnimatedImage(image);
        AnimatedDrawableBackend drawableBackend = this.mAnimatedDrawableBackendProvider.get(tempResult, null);
        final ArrayList<CloseableReference<Bitmap>> bitmaps = new ArrayList<CloseableReference<Bitmap>>(drawableBackend.getFrameCount());
        AnimatedImageCompositor animatedImageCompositor = new AnimatedImageCompositor(drawableBackend, new AnimatedImageCompositor.Callback(){

            @Override
            public void onIntermediateResult(int frameNumber, Bitmap bitmap) {
            }

            @Override
            public CloseableReference<Bitmap> getCachedBitmap(int frameNumber) {
                return CloseableReference.cloneOrNull((CloseableReference)((CloseableReference)bitmaps.get(frameNumber)));
            }
        });
        for (int i = 0; i < drawableBackend.getFrameCount(); ++i) {
            CloseableReference<Bitmap> bitmap = this.createBitmap(drawableBackend.getWidth(), drawableBackend.getHeight(), bitmapConfig);
            animatedImageCompositor.renderFrame(i, (Bitmap)bitmap.get());
            bitmaps.add(bitmap);
        }
        return bitmaps;
    }

    @SuppressLint(value={"NewApi"})
    private CloseableReference<Bitmap> createBitmap(int width, int height, Bitmap.Config bitmapConfig) {
        CloseableReference bitmap = this.mBitmapFactory.createBitmapInternal(width, height, bitmapConfig);
        ((Bitmap)bitmap.get()).eraseColor(0);
        if (Build.VERSION.SDK_INT >= 12) {
            ((Bitmap)bitmap.get()).setHasAlpha(true);
        }
        return bitmap;
    }

    static {
        sGifAnimatedImageDecoder = AnimatedImageFactoryImpl.loadIfPresent("com.facebook.animated.gif.GifImage");
        sWebpAnimatedImageDecoder = AnimatedImageFactoryImpl.loadIfPresent("com.facebook.animated.webp.WebPImage");
    }
}

