/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdRuleExecutionOptions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdRuleExecutionSpec
extends APINode {
    @SerializedName(value="execution_options")
    private List<AdRuleExecutionOptions> mExecutionOptions = null;
    @SerializedName(value="execution_type")
    private EnumExecutionType mExecutionType = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdRuleExecutionSpec loadJSON(String json, APIContext context, String header) {
        AdRuleExecutionSpec adRuleExecutionSpec = (AdRuleExecutionSpec)AdRuleExecutionSpec.getGson().fromJson(json, AdRuleExecutionSpec.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adRuleExecutionSpec.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adRuleExecutionSpec.context = context;
        adRuleExecutionSpec.rawValue = json;
        adRuleExecutionSpec.header = header;
        return adRuleExecutionSpec;
    }

    public static APINodeList<AdRuleExecutionSpec> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdRuleExecutionSpec> adRuleExecutionSpecs = new APINodeList<AdRuleExecutionSpec>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adRuleExecutionSpecs.add(AdRuleExecutionSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adRuleExecutionSpecs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adRuleExecutionSpecs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adRuleExecutionSpecs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adRuleExecutionSpecs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adRuleExecutionSpecs.add(AdRuleExecutionSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adRuleExecutionSpecs.add(AdRuleExecutionSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adRuleExecutionSpecs.add(AdRuleExecutionSpec.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adRuleExecutionSpecs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adRuleExecutionSpecs.add(AdRuleExecutionSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adRuleExecutionSpecs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adRuleExecutionSpecs.add(AdRuleExecutionSpec.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adRuleExecutionSpecs;
                }
                adRuleExecutionSpecs.clear();
                adRuleExecutionSpecs.add(AdRuleExecutionSpec.loadJSON(json, context, header));
                return adRuleExecutionSpecs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdRuleExecutionSpec.getGson().toJson((Object)this);
    }

    public List<AdRuleExecutionOptions> getFieldExecutionOptions() {
        return this.mExecutionOptions;
    }

    public AdRuleExecutionSpec setFieldExecutionOptions(List<AdRuleExecutionOptions> value) {
        this.mExecutionOptions = value;
        return this;
    }

    public AdRuleExecutionSpec setFieldExecutionOptions(String value) {
        Type type = new TypeToken<List<AdRuleExecutionOptions>>(){}.getType();
        this.mExecutionOptions = (List)AdRuleExecutionOptions.getGson().fromJson(value, type);
        return this;
    }

    public EnumExecutionType getFieldExecutionType() {
        return this.mExecutionType;
    }

    public AdRuleExecutionSpec setFieldExecutionType(EnumExecutionType value) {
        this.mExecutionType = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdRuleExecutionSpec copyFrom(AdRuleExecutionSpec instance) {
        this.mExecutionOptions = instance.mExecutionOptions;
        this.mExecutionType = instance.mExecutionType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdRuleExecutionSpec> getParser() {
        return new APIRequest.ResponseParser<AdRuleExecutionSpec>(){

            @Override
            public APINodeList<AdRuleExecutionSpec> parseResponse(String response, APIContext context, APIRequest<AdRuleExecutionSpec> request, String header) throws APIException.MalformedResponseException {
                return AdRuleExecutionSpec.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumExecutionType {
        VALUE_ADD_INTEREST_RELAXATION("ADD_INTEREST_RELAXATION"),
        VALUE_ADD_QUESTIONNAIRE_INTERESTS("ADD_QUESTIONNAIRE_INTERESTS"),
        VALUE_CHANGE_BID("CHANGE_BID"),
        VALUE_CHANGE_BUDGET("CHANGE_BUDGET"),
        VALUE_CHANGE_CAMPAIGN_BUDGET("CHANGE_CAMPAIGN_BUDGET"),
        VALUE_INCREASE_RADIUS("INCREASE_RADIUS"),
        VALUE_NOTIFICATION("NOTIFICATION"),
        VALUE_PAUSE("PAUSE"),
        VALUE_PING_ENDPOINT("PING_ENDPOINT"),
        VALUE_REBALANCE_BUDGET("REBALANCE_BUDGET"),
        VALUE_ROTATE("ROTATE"),
        VALUE_UNPAUSE("UNPAUSE"),
        VALUE_UPDATE_CREATIVE("UPDATE_CREATIVE");

        private String value;

        private EnumExecutionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

