/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrandSafetyBlockListUsage
extends APINode {
    @SerializedName(value="current_usage")
    private Long mCurrentUsage = null;
    @SerializedName(value="new_usage")
    private Long mNewUsage = null;
    @SerializedName(value="platform")
    private String mPlatform = null;
    @SerializedName(value="position")
    private String mPosition = null;
    @SerializedName(value="threshold")
    private Long mThreshold = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static BrandSafetyBlockListUsage loadJSON(String json, APIContext context, String header) {
        BrandSafetyBlockListUsage brandSafetyBlockListUsage = (BrandSafetyBlockListUsage)BrandSafetyBlockListUsage.getGson().fromJson(json, BrandSafetyBlockListUsage.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(brandSafetyBlockListUsage.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        brandSafetyBlockListUsage.context = context;
        brandSafetyBlockListUsage.rawValue = json;
        brandSafetyBlockListUsage.header = header;
        return brandSafetyBlockListUsage;
    }

    public static APINodeList<BrandSafetyBlockListUsage> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BrandSafetyBlockListUsage> brandSafetyBlockListUsages = new APINodeList<BrandSafetyBlockListUsage>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        brandSafetyBlockListUsages.add(BrandSafetyBlockListUsage.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return brandSafetyBlockListUsages;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            brandSafetyBlockListUsages.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        brandSafetyBlockListUsages.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            brandSafetyBlockListUsages.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            brandSafetyBlockListUsages.add(BrandSafetyBlockListUsage.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                brandSafetyBlockListUsages.add(BrandSafetyBlockListUsage.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            brandSafetyBlockListUsages.add(BrandSafetyBlockListUsage.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return brandSafetyBlockListUsages;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        brandSafetyBlockListUsages.add(BrandSafetyBlockListUsage.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return brandSafetyBlockListUsages;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        brandSafetyBlockListUsages.add(BrandSafetyBlockListUsage.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return brandSafetyBlockListUsages;
                }
                brandSafetyBlockListUsages.clear();
                brandSafetyBlockListUsages.add(BrandSafetyBlockListUsage.loadJSON(json, context, header));
                return brandSafetyBlockListUsages;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BrandSafetyBlockListUsage.getGson().toJson((Object)this);
    }

    public Long getFieldCurrentUsage() {
        return this.mCurrentUsage;
    }

    public BrandSafetyBlockListUsage setFieldCurrentUsage(Long value) {
        this.mCurrentUsage = value;
        return this;
    }

    public Long getFieldNewUsage() {
        return this.mNewUsage;
    }

    public BrandSafetyBlockListUsage setFieldNewUsage(Long value) {
        this.mNewUsage = value;
        return this;
    }

    public String getFieldPlatform() {
        return this.mPlatform;
    }

    public BrandSafetyBlockListUsage setFieldPlatform(String value) {
        this.mPlatform = value;
        return this;
    }

    public String getFieldPosition() {
        return this.mPosition;
    }

    public BrandSafetyBlockListUsage setFieldPosition(String value) {
        this.mPosition = value;
        return this;
    }

    public Long getFieldThreshold() {
        return this.mThreshold;
    }

    public BrandSafetyBlockListUsage setFieldThreshold(Long value) {
        this.mThreshold = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BrandSafetyBlockListUsage copyFrom(BrandSafetyBlockListUsage instance) {
        this.mCurrentUsage = instance.mCurrentUsage;
        this.mNewUsage = instance.mNewUsage;
        this.mPlatform = instance.mPlatform;
        this.mPosition = instance.mPosition;
        this.mThreshold = instance.mThreshold;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BrandSafetyBlockListUsage> getParser() {
        return new APIRequest.ResponseParser<BrandSafetyBlockListUsage>(){

            @Override
            public APINodeList<BrandSafetyBlockListUsage> parseResponse(String response, APIContext context, APIRequest<BrandSafetyBlockListUsage> request, String header) throws APIException.MalformedResponseException {
                return BrandSafetyBlockListUsage.parseResponse(response, context, request, header);
            }
        };
    }
}

