/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoGameShow
extends APINode {
    @SerializedName(value="end_time")
    private String mEndTime = null;
    @SerializedName(value="game_status")
    private String mGameStatus = null;
    @SerializedName(value="game_type")
    private String mGameType = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="start_time")
    private String mStartTime = null;
    protected static Gson gson = null;

    VideoGameShow() {
    }

    public VideoGameShow(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public VideoGameShow(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public VideoGameShow fetch() throws APIException {
        VideoGameShow newInstance = VideoGameShow.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static VideoGameShow fetchById(Long id, APIContext context) throws APIException {
        return VideoGameShow.fetchById(id.toString(), context);
    }

    public static ListenableFuture<VideoGameShow> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return VideoGameShow.fetchByIdAsync(id.toString(), context);
    }

    public static VideoGameShow fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<VideoGameShow> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<VideoGameShow> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<VideoGameShow>(context, "", "/", "GET", VideoGameShow.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<VideoGameShow>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<VideoGameShow>(context, "", "/", "GET", VideoGameShow.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static VideoGameShow loadJSON(String json, APIContext context, String header) {
        VideoGameShow videoGameShow = (VideoGameShow)VideoGameShow.getGson().fromJson(json, VideoGameShow.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(videoGameShow.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        videoGameShow.context = context;
        videoGameShow.rawValue = json;
        videoGameShow.header = header;
        return videoGameShow;
    }

    public static APINodeList<VideoGameShow> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<VideoGameShow> videoGameShows = new APINodeList<VideoGameShow>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        videoGameShows.add(VideoGameShow.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return videoGameShows;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            videoGameShows.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        videoGameShows.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            videoGameShows.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            videoGameShows.add(VideoGameShow.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                videoGameShows.add(VideoGameShow.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            videoGameShows.add(VideoGameShow.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return videoGameShows;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        videoGameShows.add(VideoGameShow.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return videoGameShows;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        videoGameShows.add(VideoGameShow.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return videoGameShows;
                }
                videoGameShows.clear();
                videoGameShows.add(VideoGameShow.loadJSON(json, context, header));
                return videoGameShows;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return VideoGameShow.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldEndTime() {
        return this.mEndTime;
    }

    public String getFieldGameStatus() {
        return this.mGameStatus;
    }

    public String getFieldGameType() {
        return this.mGameType;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldStartTime() {
        return this.mStartTime;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public VideoGameShow copyFrom(VideoGameShow instance) {
        this.mEndTime = instance.mEndTime;
        this.mGameStatus = instance.mGameStatus;
        this.mGameType = instance.mGameType;
        this.mId = instance.mId;
        this.mStartTime = instance.mStartTime;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<VideoGameShow> getParser() {
        return new APIRequest.ResponseParser<VideoGameShow>(){

            @Override
            public APINodeList<VideoGameShow> parseResponse(String response, APIContext context, APIRequest<VideoGameShow> request, String header) throws APIException.MalformedResponseException {
                return VideoGameShow.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<VideoGameShow> {
        VideoGameShow lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"end_time", "game_status", "game_type", "id", "start_time"};

        @Override
        public VideoGameShow getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public VideoGameShow parseResponse(String response, String header) throws APIException {
            return VideoGameShow.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public VideoGameShow execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public VideoGameShow execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<VideoGameShow> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<VideoGameShow> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, VideoGameShow>(){

                public VideoGameShow apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGet requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGet requestGameStatusField() {
            return this.requestGameStatusField(true);
        }

        public APIRequestGet requestGameStatusField(boolean value) {
            this.requestField("game_status", value);
            return this;
        }

        public APIRequestGet requestGameTypeField() {
            return this.requestGameTypeField(true);
        }

        public APIRequestGet requestGameTypeField(boolean value) {
            this.requestField("game_type", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGet requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }
    }
}

