/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AssignedUser;
import com.facebook.ads.sdk.Business;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusinessCreativeFolder
extends APINode {
    @SerializedName(value="business")
    private Business mBusiness = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="creative_insight_permissions")
    private Map<String, String> mCreativeInsightPermissions = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="media_library_url")
    private String mMediaLibraryUrl = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="parent_folder")
    private BusinessCreativeFolder mParentFolder = null;
    protected static Gson gson = null;

    BusinessCreativeFolder() {
    }

    public BusinessCreativeFolder(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public BusinessCreativeFolder(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public BusinessCreativeFolder fetch() throws APIException {
        BusinessCreativeFolder newInstance = BusinessCreativeFolder.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static BusinessCreativeFolder fetchById(Long id, APIContext context) throws APIException {
        return BusinessCreativeFolder.fetchById(id.toString(), context);
    }

    public static ListenableFuture<BusinessCreativeFolder> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return BusinessCreativeFolder.fetchByIdAsync(id.toString(), context);
    }

    public static BusinessCreativeFolder fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<BusinessCreativeFolder> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<BusinessCreativeFolder> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<BusinessCreativeFolder>(context, "", "/", "GET", BusinessCreativeFolder.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<BusinessCreativeFolder>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<BusinessCreativeFolder>(context, "", "/", "GET", BusinessCreativeFolder.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static BusinessCreativeFolder loadJSON(String json, APIContext context, String header) {
        BusinessCreativeFolder businessCreativeFolder = (BusinessCreativeFolder)BusinessCreativeFolder.getGson().fromJson(json, BusinessCreativeFolder.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(businessCreativeFolder.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        businessCreativeFolder.context = context;
        businessCreativeFolder.rawValue = json;
        businessCreativeFolder.header = header;
        return businessCreativeFolder;
    }

    public static APINodeList<BusinessCreativeFolder> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BusinessCreativeFolder> businessCreativeFolders = new APINodeList<BusinessCreativeFolder>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        businessCreativeFolders.add(BusinessCreativeFolder.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return businessCreativeFolders;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            businessCreativeFolders.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        businessCreativeFolders.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            businessCreativeFolders.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            businessCreativeFolders.add(BusinessCreativeFolder.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                businessCreativeFolders.add(BusinessCreativeFolder.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            businessCreativeFolders.add(BusinessCreativeFolder.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return businessCreativeFolders;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        businessCreativeFolders.add(BusinessCreativeFolder.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return businessCreativeFolders;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        businessCreativeFolders.add(BusinessCreativeFolder.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return businessCreativeFolders;
                }
                businessCreativeFolders.clear();
                businessCreativeFolders.add(BusinessCreativeFolder.loadJSON(json, context, header));
                return businessCreativeFolders;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BusinessCreativeFolder.getGson().toJson((Object)this);
    }

    public APIRequestDeleteAgencies deleteAgencies() {
        return new APIRequestDeleteAgencies(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAgencies getAgencies() {
        return new APIRequestGetAgencies(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAgency createAgency() {
        return new APIRequestCreateAgency(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAssignedUsers getAssignedUsers() {
        return new APIRequestGetAssignedUsers(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAssignedUser createAssignedUser() {
        return new APIRequestCreateAssignedUser(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetSubFolders getSubFolders() {
        return new APIRequestGetSubFolders(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public Business getFieldBusiness() {
        if (this.mBusiness != null) {
            this.mBusiness.context = this.getContext();
        }
        return this.mBusiness;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public Map<String, String> getFieldCreativeInsightPermissions() {
        return this.mCreativeInsightPermissions;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldMediaLibraryUrl() {
        return this.mMediaLibraryUrl;
    }

    public String getFieldName() {
        return this.mName;
    }

    public BusinessCreativeFolder getFieldParentFolder() {
        if (this.mParentFolder != null) {
            this.mParentFolder.context = this.getContext();
        }
        return this.mParentFolder;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BusinessCreativeFolder copyFrom(BusinessCreativeFolder instance) {
        this.mBusiness = instance.mBusiness;
        this.mCreationTime = instance.mCreationTime;
        this.mCreativeInsightPermissions = instance.mCreativeInsightPermissions;
        this.mDescription = instance.mDescription;
        this.mId = instance.mId;
        this.mMediaLibraryUrl = instance.mMediaLibraryUrl;
        this.mName = instance.mName;
        this.mParentFolder = instance.mParentFolder;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BusinessCreativeFolder> getParser() {
        return new APIRequest.ResponseParser<BusinessCreativeFolder>(){

            @Override
            public APINodeList<BusinessCreativeFolder> parseResponse(String response, APIContext context, APIRequest<BusinessCreativeFolder> request, String header) throws APIException.MalformedResponseException {
                return BusinessCreativeFolder.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumTasks {
        VALUE_CREATE_CONTENT("CREATE_CONTENT"),
        VALUE_MANAGE_CONTENT("MANAGE_CONTENT"),
        VALUE_MANAGE_PERMISSIONS("MANAGE_PERMISSIONS"),
        VALUE_VIEW_CONTENT("VIEW_CONTENT"),
        VALUE_VIEW_INSIGHTS("VIEW_INSIGHTS");

        private String value;

        private EnumTasks(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumPermittedTasks {
        VALUE_CREATE_CONTENT("CREATE_CONTENT"),
        VALUE_MANAGE_CONTENT("MANAGE_CONTENT"),
        VALUE_MANAGE_PERMISSIONS("MANAGE_PERMISSIONS"),
        VALUE_VIEW_CONTENT("VIEW_CONTENT"),
        VALUE_VIEW_INSIGHTS("VIEW_INSIGHTS");

        private String value;

        private EnumPermittedTasks(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<BusinessCreativeFolder> {
        BusinessCreativeFolder lastResponse = null;
        public static final String[] PARAMS = new String[]{"creative_insight_permissions", "description", "name"};
        public static final String[] FIELDS = new String[0];

        @Override
        public BusinessCreativeFolder getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BusinessCreativeFolder parseResponse(String response, String header) throws APIException {
            return BusinessCreativeFolder.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public BusinessCreativeFolder execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BusinessCreativeFolder execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<BusinessCreativeFolder> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BusinessCreativeFolder> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, BusinessCreativeFolder>(){

                public BusinessCreativeFolder apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setCreativeInsightPermissions(Map<String, String> creativeInsightPermissions) {
            this.setParam("creative_insight_permissions", creativeInsightPermissions);
            return this;
        }

        public APIRequestUpdate setCreativeInsightPermissions(String creativeInsightPermissions) {
            this.setParam("creative_insight_permissions", creativeInsightPermissions);
            return this;
        }

        public APIRequestUpdate setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<BusinessCreativeFolder> {
        BusinessCreativeFolder lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"business", "creation_time", "creative_insight_permissions", "description", "id", "media_library_url", "name", "parent_folder"};

        @Override
        public BusinessCreativeFolder getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BusinessCreativeFolder parseResponse(String response, String header) throws APIException {
            return BusinessCreativeFolder.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public BusinessCreativeFolder execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BusinessCreativeFolder execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<BusinessCreativeFolder> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BusinessCreativeFolder> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, BusinessCreativeFolder>(){

                public BusinessCreativeFolder apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGet requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestCreativeInsightPermissionsField() {
            return this.requestCreativeInsightPermissionsField(true);
        }

        public APIRequestGet requestCreativeInsightPermissionsField(boolean value) {
            this.requestField("creative_insight_permissions", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestMediaLibraryUrlField() {
            return this.requestMediaLibraryUrlField(true);
        }

        public APIRequestGet requestMediaLibraryUrlField(boolean value) {
            this.requestField("media_library_url", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestParentFolderField() {
            return this.requestParentFolderField(true);
        }

        public APIRequestGet requestParentFolderField(boolean value) {
            this.requestField("parent_folder", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetSubFolders
    extends APIRequest<BusinessCreativeFolder> {
        APINodeList<BusinessCreativeFolder> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"business", "creation_time", "creative_insight_permissions", "description", "id", "media_library_url", "name", "parent_folder"};

        @Override
        public APINodeList<BusinessCreativeFolder> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<BusinessCreativeFolder> parseResponse(String response, String header) throws APIException {
            return BusinessCreativeFolder.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<BusinessCreativeFolder> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<BusinessCreativeFolder> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<BusinessCreativeFolder>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<BusinessCreativeFolder>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<BusinessCreativeFolder>>(){

                public APINodeList<BusinessCreativeFolder> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetSubFolders.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetSubFolders(String nodeId, APIContext context) {
            super(context, nodeId, "/subfolders", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetSubFolders setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetSubFolders setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetSubFolders requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetSubFolders requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSubFolders requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetSubFolders requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSubFolders requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetSubFolders requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetSubFolders requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetSubFolders requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetSubFolders requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGetSubFolders requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGetSubFolders requestCreativeInsightPermissionsField() {
            return this.requestCreativeInsightPermissionsField(true);
        }

        public APIRequestGetSubFolders requestCreativeInsightPermissionsField(boolean value) {
            this.requestField("creative_insight_permissions", value);
            return this;
        }

        public APIRequestGetSubFolders requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetSubFolders requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetSubFolders requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetSubFolders requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetSubFolders requestMediaLibraryUrlField() {
            return this.requestMediaLibraryUrlField(true);
        }

        public APIRequestGetSubFolders requestMediaLibraryUrlField(boolean value) {
            this.requestField("media_library_url", value);
            return this;
        }

        public APIRequestGetSubFolders requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetSubFolders requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetSubFolders requestParentFolderField() {
            return this.requestParentFolderField(true);
        }

        public APIRequestGetSubFolders requestParentFolderField(boolean value) {
            this.requestField("parent_folder", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateAssignedUser
    extends APIRequest<BusinessCreativeFolder> {
        BusinessCreativeFolder lastResponse = null;
        public static final String[] PARAMS = new String[]{"tasks", "user"};
        public static final String[] FIELDS = new String[0];

        @Override
        public BusinessCreativeFolder getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BusinessCreativeFolder parseResponse(String response, String header) throws APIException {
            return BusinessCreativeFolder.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public BusinessCreativeFolder execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BusinessCreativeFolder execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<BusinessCreativeFolder> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BusinessCreativeFolder> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, BusinessCreativeFolder>(){

                public BusinessCreativeFolder apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateAssignedUser.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateAssignedUser(String nodeId, APIContext context) {
            super(context, nodeId, "/assigned_users", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAssignedUser setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAssignedUser setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAssignedUser setTasks(List<EnumTasks> tasks) {
            this.setParam("tasks", tasks);
            return this;
        }

        public APIRequestCreateAssignedUser setTasks(String tasks) {
            this.setParam("tasks", tasks);
            return this;
        }

        public APIRequestCreateAssignedUser setUser(Long user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestCreateAssignedUser setUser(String user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestCreateAssignedUser requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAssignedUser requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAssignedUser requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAssignedUser requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAssignedUser requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAssignedUser requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAssignedUsers
    extends APIRequest<AssignedUser> {
        APINodeList<AssignedUser> lastResponse = null;
        public static final String[] PARAMS = new String[]{"business"};
        public static final String[] FIELDS = new String[]{"business", "id", "name", "user_type"};

        @Override
        public APINodeList<AssignedUser> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AssignedUser> parseResponse(String response, String header) throws APIException {
            return AssignedUser.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AssignedUser> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AssignedUser> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AssignedUser>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AssignedUser>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AssignedUser>>(){

                public APINodeList<AssignedUser> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetAssignedUsers.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAssignedUsers(String nodeId, APIContext context) {
            super(context, nodeId, "/assigned_users", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAssignedUsers setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAssignedUsers setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAssignedUsers setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestGetAssignedUsers requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAssignedUsers requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAssignedUsers requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAssignedUsers requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAssignedUsers requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAssignedUsers requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAssignedUsers requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetAssignedUsers requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetAssignedUsers requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAssignedUsers requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAssignedUsers requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAssignedUsers requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAssignedUsers requestUserTypeField() {
            return this.requestUserTypeField(true);
        }

        public APIRequestGetAssignedUsers requestUserTypeField(boolean value) {
            this.requestField("user_type", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateAgency
    extends APIRequest<BusinessCreativeFolder> {
        BusinessCreativeFolder lastResponse = null;
        public static final String[] PARAMS = new String[]{"business", "permitted_tasks"};
        public static final String[] FIELDS = new String[0];

        @Override
        public BusinessCreativeFolder getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BusinessCreativeFolder parseResponse(String response, String header) throws APIException {
            return BusinessCreativeFolder.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public BusinessCreativeFolder execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BusinessCreativeFolder execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<BusinessCreativeFolder> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BusinessCreativeFolder> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, BusinessCreativeFolder>(){

                public BusinessCreativeFolder apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateAgency.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateAgency(String nodeId, APIContext context) {
            super(context, nodeId, "/agencies", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAgency setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAgency setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAgency setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestCreateAgency setPermittedTasks(List<EnumPermittedTasks> permittedTasks) {
            this.setParam("permitted_tasks", permittedTasks);
            return this;
        }

        public APIRequestCreateAgency setPermittedTasks(String permittedTasks) {
            this.setParam("permitted_tasks", permittedTasks);
            return this;
        }

        public APIRequestCreateAgency requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAgency requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAgency requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAgency requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAgency requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAgency requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAgencies
    extends APIRequest<Business> {
        APINodeList<Business> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"block_offline_analytics", "created_by", "created_time", "extended_updated_time", "id", "is_hidden", "is_instagram_enabled_in_fb_analytics", "link", "name", "primary_page", "profile_picture_uri", "timezone_id", "two_factor_type", "updated_by", "updated_time", "verification_status", "vertical", "vertical_id"};

        @Override
        public APINodeList<Business> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Business> parseResponse(String response, String header) throws APIException {
            return Business.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Business> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Business> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Business>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Business>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Business>>(){

                public APINodeList<Business> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetAgencies.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAgencies(String nodeId, APIContext context) {
            super(context, nodeId, "/agencies", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAgencies setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAgencies setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAgencies requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAgencies requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAgencies requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAgencies requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAgencies requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAgencies requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAgencies requestBlockOfflineAnalyticsField() {
            return this.requestBlockOfflineAnalyticsField(true);
        }

        public APIRequestGetAgencies requestBlockOfflineAnalyticsField(boolean value) {
            this.requestField("block_offline_analytics", value);
            return this;
        }

        public APIRequestGetAgencies requestCreatedByField() {
            return this.requestCreatedByField(true);
        }

        public APIRequestGetAgencies requestCreatedByField(boolean value) {
            this.requestField("created_by", value);
            return this;
        }

        public APIRequestGetAgencies requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAgencies requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAgencies requestExtendedUpdatedTimeField() {
            return this.requestExtendedUpdatedTimeField(true);
        }

        public APIRequestGetAgencies requestExtendedUpdatedTimeField(boolean value) {
            this.requestField("extended_updated_time", value);
            return this;
        }

        public APIRequestGetAgencies requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAgencies requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAgencies requestIsHiddenField() {
            return this.requestIsHiddenField(true);
        }

        public APIRequestGetAgencies requestIsHiddenField(boolean value) {
            this.requestField("is_hidden", value);
            return this;
        }

        public APIRequestGetAgencies requestIsInstagramEnabledInFbAnalyticsField() {
            return this.requestIsInstagramEnabledInFbAnalyticsField(true);
        }

        public APIRequestGetAgencies requestIsInstagramEnabledInFbAnalyticsField(boolean value) {
            this.requestField("is_instagram_enabled_in_fb_analytics", value);
            return this;
        }

        public APIRequestGetAgencies requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetAgencies requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetAgencies requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAgencies requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAgencies requestPrimaryPageField() {
            return this.requestPrimaryPageField(true);
        }

        public APIRequestGetAgencies requestPrimaryPageField(boolean value) {
            this.requestField("primary_page", value);
            return this;
        }

        public APIRequestGetAgencies requestProfilePictureUriField() {
            return this.requestProfilePictureUriField(true);
        }

        public APIRequestGetAgencies requestProfilePictureUriField(boolean value) {
            this.requestField("profile_picture_uri", value);
            return this;
        }

        public APIRequestGetAgencies requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGetAgencies requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }

        public APIRequestGetAgencies requestTwoFactorTypeField() {
            return this.requestTwoFactorTypeField(true);
        }

        public APIRequestGetAgencies requestTwoFactorTypeField(boolean value) {
            this.requestField("two_factor_type", value);
            return this;
        }

        public APIRequestGetAgencies requestUpdatedByField() {
            return this.requestUpdatedByField(true);
        }

        public APIRequestGetAgencies requestUpdatedByField(boolean value) {
            this.requestField("updated_by", value);
            return this;
        }

        public APIRequestGetAgencies requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetAgencies requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetAgencies requestVerificationStatusField() {
            return this.requestVerificationStatusField(true);
        }

        public APIRequestGetAgencies requestVerificationStatusField(boolean value) {
            this.requestField("verification_status", value);
            return this;
        }

        public APIRequestGetAgencies requestVerticalField() {
            return this.requestVerticalField(true);
        }

        public APIRequestGetAgencies requestVerticalField(boolean value) {
            this.requestField("vertical", value);
            return this;
        }

        public APIRequestGetAgencies requestVerticalIdField() {
            return this.requestVerticalIdField(true);
        }

        public APIRequestGetAgencies requestVerticalIdField(boolean value) {
            this.requestField("vertical_id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteAgencies
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"business"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestDeleteAgencies.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteAgencies(String nodeId, APIContext context) {
            super(context, nodeId, "/agencies", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteAgencies setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteAgencies setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteAgencies setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestDeleteAgencies requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteAgencies requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteAgencies requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteAgencies requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteAgencies requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteAgencies requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

