/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Business;
import com.facebook.ads.sdk.CurrencyAmount;
import com.facebook.ads.sdk.ExtendedCreditAllocationConfig;
import com.facebook.ads.sdk.ExtendedCreditInvoiceGroup;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedCredit
extends APINode {
    @SerializedName(value="allocated_amount")
    private CurrencyAmount mAllocatedAmount = null;
    @SerializedName(value="balance")
    private CurrencyAmount mBalance = null;
    @SerializedName(value="credit_available")
    private CurrencyAmount mCreditAvailable = null;
    @SerializedName(value="credit_type")
    private String mCreditType = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_access_revoked")
    private Boolean mIsAccessRevoked = null;
    @SerializedName(value="is_automated_experience")
    private Boolean mIsAutomatedExperience = null;
    @SerializedName(value="last_payment_time")
    private String mLastPaymentTime = null;
    @SerializedName(value="legal_entity_name")
    private String mLegalEntityName = null;
    @SerializedName(value="liable_biz_name")
    private String mLiableBizName = null;
    @SerializedName(value="max_balance")
    private CurrencyAmount mMaxBalance = null;
    @SerializedName(value="online_max_balance")
    private CurrencyAmount mOnlineMaxBalance = null;
    @SerializedName(value="owner_business")
    private Business mOwnerBusiness = null;
    @SerializedName(value="owner_business_name")
    private String mOwnerBusinessName = null;
    @SerializedName(value="partition_from")
    private String mPartitionFrom = null;
    @SerializedName(value="send_bill_to_biz_name")
    private String mSendBillToBizName = null;
    protected static Gson gson = null;

    ExtendedCredit() {
    }

    public ExtendedCredit(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ExtendedCredit(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ExtendedCredit fetch() throws APIException {
        ExtendedCredit newInstance = ExtendedCredit.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ExtendedCredit fetchById(Long id, APIContext context) throws APIException {
        return ExtendedCredit.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ExtendedCredit> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ExtendedCredit.fetchByIdAsync(id.toString(), context);
    }

    public static ExtendedCredit fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ExtendedCredit> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ExtendedCredit> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ExtendedCredit>(context, "", "/", "GET", ExtendedCredit.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ExtendedCredit>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ExtendedCredit>(context, "", "/", "GET", ExtendedCredit.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ExtendedCredit loadJSON(String json, APIContext context, String header) {
        ExtendedCredit extendedCredit = (ExtendedCredit)ExtendedCredit.getGson().fromJson(json, ExtendedCredit.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(extendedCredit.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        extendedCredit.context = context;
        extendedCredit.rawValue = json;
        extendedCredit.header = header;
        return extendedCredit;
    }

    public static APINodeList<ExtendedCredit> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ExtendedCredit> extendedCredits = new APINodeList<ExtendedCredit>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        extendedCredits.add(ExtendedCredit.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return extendedCredits;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            extendedCredits.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        extendedCredits.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            extendedCredits.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            extendedCredits.add(ExtendedCredit.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                extendedCredits.add(ExtendedCredit.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            extendedCredits.add(ExtendedCredit.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return extendedCredits;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        extendedCredits.add(ExtendedCredit.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return extendedCredits;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        extendedCredits.add(ExtendedCredit.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return extendedCredits;
                }
                extendedCredits.clear();
                extendedCredits.add(ExtendedCredit.loadJSON(json, context, header));
                return extendedCredits;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ExtendedCredit.getGson().toJson((Object)this);
    }

    public APIRequestGetExtendedCreditEmails getExtendedCreditEmails() {
        return new APIRequestGetExtendedCreditEmails(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetExtendedCreditInvoiceGroups getExtendedCreditInvoiceGroups() {
        return new APIRequestGetExtendedCreditInvoiceGroups(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateExtendedCreditInvoiceGroup createExtendedCreditInvoiceGroup() {
        return new APIRequestCreateExtendedCreditInvoiceGroup(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetOwningCreditAllocationConfigs getOwningCreditAllocationConfigs() {
        return new APIRequestGetOwningCreditAllocationConfigs(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateOwningCreditAllocationConfig createOwningCreditAllocationConfig() {
        return new APIRequestCreateOwningCreditAllocationConfig(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public CurrencyAmount getFieldAllocatedAmount() {
        return this.mAllocatedAmount;
    }

    public CurrencyAmount getFieldBalance() {
        return this.mBalance;
    }

    public CurrencyAmount getFieldCreditAvailable() {
        return this.mCreditAvailable;
    }

    public String getFieldCreditType() {
        return this.mCreditType;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsAccessRevoked() {
        return this.mIsAccessRevoked;
    }

    public Boolean getFieldIsAutomatedExperience() {
        return this.mIsAutomatedExperience;
    }

    public String getFieldLastPaymentTime() {
        return this.mLastPaymentTime;
    }

    public String getFieldLegalEntityName() {
        return this.mLegalEntityName;
    }

    public String getFieldLiableBizName() {
        return this.mLiableBizName;
    }

    public CurrencyAmount getFieldMaxBalance() {
        return this.mMaxBalance;
    }

    public CurrencyAmount getFieldOnlineMaxBalance() {
        return this.mOnlineMaxBalance;
    }

    public Business getFieldOwnerBusiness() {
        if (this.mOwnerBusiness != null) {
            this.mOwnerBusiness.context = this.getContext();
        }
        return this.mOwnerBusiness;
    }

    public String getFieldOwnerBusinessName() {
        return this.mOwnerBusinessName;
    }

    public String getFieldPartitionFrom() {
        return this.mPartitionFrom;
    }

    public String getFieldSendBillToBizName() {
        return this.mSendBillToBizName;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ExtendedCredit copyFrom(ExtendedCredit instance) {
        this.mAllocatedAmount = instance.mAllocatedAmount;
        this.mBalance = instance.mBalance;
        this.mCreditAvailable = instance.mCreditAvailable;
        this.mCreditType = instance.mCreditType;
        this.mId = instance.mId;
        this.mIsAccessRevoked = instance.mIsAccessRevoked;
        this.mIsAutomatedExperience = instance.mIsAutomatedExperience;
        this.mLastPaymentTime = instance.mLastPaymentTime;
        this.mLegalEntityName = instance.mLegalEntityName;
        this.mLiableBizName = instance.mLiableBizName;
        this.mMaxBalance = instance.mMaxBalance;
        this.mOnlineMaxBalance = instance.mOnlineMaxBalance;
        this.mOwnerBusiness = instance.mOwnerBusiness;
        this.mOwnerBusinessName = instance.mOwnerBusinessName;
        this.mPartitionFrom = instance.mPartitionFrom;
        this.mSendBillToBizName = instance.mSendBillToBizName;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ExtendedCredit> getParser() {
        return new APIRequest.ResponseParser<ExtendedCredit>(){

            @Override
            public APINodeList<ExtendedCredit> parseResponse(String response, APIContext context, APIRequest<ExtendedCredit> request, String header) throws APIException.MalformedResponseException {
                return ExtendedCredit.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<ExtendedCredit> {
        ExtendedCredit lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"allocated_amount", "balance", "credit_available", "credit_type", "id", "is_access_revoked", "is_automated_experience", "last_payment_time", "legal_entity_name", "liable_biz_name", "max_balance", "online_max_balance", "owner_business", "owner_business_name", "partition_from", "send_bill_to_biz_name"};

        @Override
        public ExtendedCredit getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ExtendedCredit parseResponse(String response, String header) throws APIException {
            return ExtendedCredit.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ExtendedCredit execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ExtendedCredit execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ExtendedCredit> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ExtendedCredit> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, ExtendedCredit>(){

                public ExtendedCredit apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAllocatedAmountField() {
            return this.requestAllocatedAmountField(true);
        }

        public APIRequestGet requestAllocatedAmountField(boolean value) {
            this.requestField("allocated_amount", value);
            return this;
        }

        public APIRequestGet requestBalanceField() {
            return this.requestBalanceField(true);
        }

        public APIRequestGet requestBalanceField(boolean value) {
            this.requestField("balance", value);
            return this;
        }

        public APIRequestGet requestCreditAvailableField() {
            return this.requestCreditAvailableField(true);
        }

        public APIRequestGet requestCreditAvailableField(boolean value) {
            this.requestField("credit_available", value);
            return this;
        }

        public APIRequestGet requestCreditTypeField() {
            return this.requestCreditTypeField(true);
        }

        public APIRequestGet requestCreditTypeField(boolean value) {
            this.requestField("credit_type", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsAccessRevokedField() {
            return this.requestIsAccessRevokedField(true);
        }

        public APIRequestGet requestIsAccessRevokedField(boolean value) {
            this.requestField("is_access_revoked", value);
            return this;
        }

        public APIRequestGet requestIsAutomatedExperienceField() {
            return this.requestIsAutomatedExperienceField(true);
        }

        public APIRequestGet requestIsAutomatedExperienceField(boolean value) {
            this.requestField("is_automated_experience", value);
            return this;
        }

        public APIRequestGet requestLastPaymentTimeField() {
            return this.requestLastPaymentTimeField(true);
        }

        public APIRequestGet requestLastPaymentTimeField(boolean value) {
            this.requestField("last_payment_time", value);
            return this;
        }

        public APIRequestGet requestLegalEntityNameField() {
            return this.requestLegalEntityNameField(true);
        }

        public APIRequestGet requestLegalEntityNameField(boolean value) {
            this.requestField("legal_entity_name", value);
            return this;
        }

        public APIRequestGet requestLiableBizNameField() {
            return this.requestLiableBizNameField(true);
        }

        public APIRequestGet requestLiableBizNameField(boolean value) {
            this.requestField("liable_biz_name", value);
            return this;
        }

        public APIRequestGet requestMaxBalanceField() {
            return this.requestMaxBalanceField(true);
        }

        public APIRequestGet requestMaxBalanceField(boolean value) {
            this.requestField("max_balance", value);
            return this;
        }

        public APIRequestGet requestOnlineMaxBalanceField() {
            return this.requestOnlineMaxBalanceField(true);
        }

        public APIRequestGet requestOnlineMaxBalanceField(boolean value) {
            this.requestField("online_max_balance", value);
            return this;
        }

        public APIRequestGet requestOwnerBusinessField() {
            return this.requestOwnerBusinessField(true);
        }

        public APIRequestGet requestOwnerBusinessField(boolean value) {
            this.requestField("owner_business", value);
            return this;
        }

        public APIRequestGet requestOwnerBusinessNameField() {
            return this.requestOwnerBusinessNameField(true);
        }

        public APIRequestGet requestOwnerBusinessNameField(boolean value) {
            this.requestField("owner_business_name", value);
            return this;
        }

        public APIRequestGet requestPartitionFromField() {
            return this.requestPartitionFromField(true);
        }

        public APIRequestGet requestPartitionFromField(boolean value) {
            this.requestField("partition_from", value);
            return this;
        }

        public APIRequestGet requestSendBillToBizNameField() {
            return this.requestSendBillToBizNameField(true);
        }

        public APIRequestGet requestSendBillToBizNameField(boolean value) {
            this.requestField("send_bill_to_biz_name", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateOwningCreditAllocationConfig
    extends APIRequest<ExtendedCreditAllocationConfig> {
        ExtendedCreditAllocationConfig lastResponse = null;
        public static final String[] PARAMS = new String[]{"amount", "liability_type", "partition_type", "receiving_business_id", "send_bill_to"};
        public static final String[] FIELDS = new String[0];

        @Override
        public ExtendedCreditAllocationConfig getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ExtendedCreditAllocationConfig parseResponse(String response, String header) throws APIException {
            return ExtendedCreditAllocationConfig.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ExtendedCreditAllocationConfig execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ExtendedCreditAllocationConfig execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ExtendedCreditAllocationConfig> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ExtendedCreditAllocationConfig> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, ExtendedCreditAllocationConfig>(){

                public ExtendedCreditAllocationConfig apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateOwningCreditAllocationConfig.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateOwningCreditAllocationConfig(String nodeId, APIContext context) {
            super(context, nodeId, "/owning_credit_allocation_configs", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateOwningCreditAllocationConfig setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateOwningCreditAllocationConfig setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateOwningCreditAllocationConfig setAmount(Object amount) {
            this.setParam("amount", amount);
            return this;
        }

        public APIRequestCreateOwningCreditAllocationConfig setAmount(String amount) {
            this.setParam("amount", amount);
            return this;
        }

        public APIRequestCreateOwningCreditAllocationConfig setLiabilityType(ExtendedCreditAllocationConfig.EnumLiabilityType liabilityType) {
            this.setParam("liability_type", (Object)liabilityType);
            return this;
        }

        public APIRequestCreateOwningCreditAllocationConfig setLiabilityType(String liabilityType) {
            this.setParam("liability_type", liabilityType);
            return this;
        }

        public APIRequestCreateOwningCreditAllocationConfig setPartitionType(ExtendedCreditAllocationConfig.EnumPartitionType partitionType) {
            this.setParam("partition_type", (Object)partitionType);
            return this;
        }

        public APIRequestCreateOwningCreditAllocationConfig setPartitionType(String partitionType) {
            this.setParam("partition_type", partitionType);
            return this;
        }

        public APIRequestCreateOwningCreditAllocationConfig setReceivingBusinessId(String receivingBusinessId) {
            this.setParam("receiving_business_id", receivingBusinessId);
            return this;
        }

        public APIRequestCreateOwningCreditAllocationConfig setSendBillTo(ExtendedCreditAllocationConfig.EnumSendBillTo sendBillTo) {
            this.setParam("send_bill_to", (Object)sendBillTo);
            return this;
        }

        public APIRequestCreateOwningCreditAllocationConfig setSendBillTo(String sendBillTo) {
            this.setParam("send_bill_to", sendBillTo);
            return this;
        }

        public APIRequestCreateOwningCreditAllocationConfig requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateOwningCreditAllocationConfig requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateOwningCreditAllocationConfig requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateOwningCreditAllocationConfig requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateOwningCreditAllocationConfig requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateOwningCreditAllocationConfig requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetOwningCreditAllocationConfigs
    extends APIRequest<ExtendedCreditAllocationConfig> {
        APINodeList<ExtendedCreditAllocationConfig> lastResponse = null;
        public static final String[] PARAMS = new String[]{"receiving_business_id"};
        public static final String[] FIELDS = new String[]{"currency_amount", "id", "liability_type", "owning_business", "owning_credential", "partition_type", "receiving_business", "receiving_credential", "request_status", "send_bill_to"};

        @Override
        public APINodeList<ExtendedCreditAllocationConfig> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<ExtendedCreditAllocationConfig> parseResponse(String response, String header) throws APIException {
            return ExtendedCreditAllocationConfig.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<ExtendedCreditAllocationConfig> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<ExtendedCreditAllocationConfig> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<ExtendedCreditAllocationConfig>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<ExtendedCreditAllocationConfig>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<ExtendedCreditAllocationConfig>>(){

                public APINodeList<ExtendedCreditAllocationConfig> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetOwningCreditAllocationConfigs.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetOwningCreditAllocationConfigs(String nodeId, APIContext context) {
            super(context, nodeId, "/owning_credit_allocation_configs", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetOwningCreditAllocationConfigs setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetOwningCreditAllocationConfigs setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetOwningCreditAllocationConfigs setReceivingBusinessId(String receivingBusinessId) {
            this.setParam("receiving_business_id", receivingBusinessId);
            return this;
        }

        public APIRequestGetOwningCreditAllocationConfigs requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetOwningCreditAllocationConfigs requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOwningCreditAllocationConfigs requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetOwningCreditAllocationConfigs requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOwningCreditAllocationConfigs requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetOwningCreditAllocationConfigs requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetOwningCreditAllocationConfigs requestCurrencyAmountField() {
            return this.requestCurrencyAmountField(true);
        }

        public APIRequestGetOwningCreditAllocationConfigs requestCurrencyAmountField(boolean value) {
            this.requestField("currency_amount", value);
            return this;
        }

        public APIRequestGetOwningCreditAllocationConfigs requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetOwningCreditAllocationConfigs requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetOwningCreditAllocationConfigs requestLiabilityTypeField() {
            return this.requestLiabilityTypeField(true);
        }

        public APIRequestGetOwningCreditAllocationConfigs requestLiabilityTypeField(boolean value) {
            this.requestField("liability_type", value);
            return this;
        }

        public APIRequestGetOwningCreditAllocationConfigs requestOwningBusinessField() {
            return this.requestOwningBusinessField(true);
        }

        public APIRequestGetOwningCreditAllocationConfigs requestOwningBusinessField(boolean value) {
            this.requestField("owning_business", value);
            return this;
        }

        public APIRequestGetOwningCreditAllocationConfigs requestOwningCredentialField() {
            return this.requestOwningCredentialField(true);
        }

        public APIRequestGetOwningCreditAllocationConfigs requestOwningCredentialField(boolean value) {
            this.requestField("owning_credential", value);
            return this;
        }

        public APIRequestGetOwningCreditAllocationConfigs requestPartitionTypeField() {
            return this.requestPartitionTypeField(true);
        }

        public APIRequestGetOwningCreditAllocationConfigs requestPartitionTypeField(boolean value) {
            this.requestField("partition_type", value);
            return this;
        }

        public APIRequestGetOwningCreditAllocationConfigs requestReceivingBusinessField() {
            return this.requestReceivingBusinessField(true);
        }

        public APIRequestGetOwningCreditAllocationConfigs requestReceivingBusinessField(boolean value) {
            this.requestField("receiving_business", value);
            return this;
        }

        public APIRequestGetOwningCreditAllocationConfigs requestReceivingCredentialField() {
            return this.requestReceivingCredentialField(true);
        }

        public APIRequestGetOwningCreditAllocationConfigs requestReceivingCredentialField(boolean value) {
            this.requestField("receiving_credential", value);
            return this;
        }

        public APIRequestGetOwningCreditAllocationConfigs requestRequestStatusField() {
            return this.requestRequestStatusField(true);
        }

        public APIRequestGetOwningCreditAllocationConfigs requestRequestStatusField(boolean value) {
            this.requestField("request_status", value);
            return this;
        }

        public APIRequestGetOwningCreditAllocationConfigs requestSendBillToField() {
            return this.requestSendBillToField(true);
        }

        public APIRequestGetOwningCreditAllocationConfigs requestSendBillToField(boolean value) {
            this.requestField("send_bill_to", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateExtendedCreditInvoiceGroup
    extends APIRequest<ExtendedCreditInvoiceGroup> {
        ExtendedCreditInvoiceGroup lastResponse = null;
        public static final String[] PARAMS = new String[]{"emails", "name"};
        public static final String[] FIELDS = new String[0];

        @Override
        public ExtendedCreditInvoiceGroup getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ExtendedCreditInvoiceGroup parseResponse(String response, String header) throws APIException {
            return ExtendedCreditInvoiceGroup.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ExtendedCreditInvoiceGroup execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ExtendedCreditInvoiceGroup execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ExtendedCreditInvoiceGroup> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ExtendedCreditInvoiceGroup> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, ExtendedCreditInvoiceGroup>(){

                public ExtendedCreditInvoiceGroup apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateExtendedCreditInvoiceGroup.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateExtendedCreditInvoiceGroup(String nodeId, APIContext context) {
            super(context, nodeId, "/extended_credit_invoice_groups", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateExtendedCreditInvoiceGroup setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateExtendedCreditInvoiceGroup setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateExtendedCreditInvoiceGroup setEmails(List<String> emails) {
            this.setParam("emails", emails);
            return this;
        }

        public APIRequestCreateExtendedCreditInvoiceGroup setEmails(String emails) {
            this.setParam("emails", emails);
            return this;
        }

        public APIRequestCreateExtendedCreditInvoiceGroup setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateExtendedCreditInvoiceGroup requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateExtendedCreditInvoiceGroup requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateExtendedCreditInvoiceGroup requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateExtendedCreditInvoiceGroup requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateExtendedCreditInvoiceGroup requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateExtendedCreditInvoiceGroup requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetExtendedCreditInvoiceGroups
    extends APIRequest<ExtendedCreditInvoiceGroup> {
        APINodeList<ExtendedCreditInvoiceGroup> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"auto_enroll", "customer_po_number", "email", "emails", "id", "name"};

        @Override
        public APINodeList<ExtendedCreditInvoiceGroup> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<ExtendedCreditInvoiceGroup> parseResponse(String response, String header) throws APIException {
            return ExtendedCreditInvoiceGroup.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<ExtendedCreditInvoiceGroup> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<ExtendedCreditInvoiceGroup> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<ExtendedCreditInvoiceGroup>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<ExtendedCreditInvoiceGroup>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<ExtendedCreditInvoiceGroup>>(){

                public APINodeList<ExtendedCreditInvoiceGroup> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetExtendedCreditInvoiceGroups.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetExtendedCreditInvoiceGroups(String nodeId, APIContext context) {
            super(context, nodeId, "/extended_credit_invoice_groups", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetExtendedCreditInvoiceGroups setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetExtendedCreditInvoiceGroups setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetExtendedCreditInvoiceGroups requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetExtendedCreditInvoiceGroups requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetExtendedCreditInvoiceGroups requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetExtendedCreditInvoiceGroups requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetExtendedCreditInvoiceGroups requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetExtendedCreditInvoiceGroups requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetExtendedCreditInvoiceGroups requestAutoEnrollField() {
            return this.requestAutoEnrollField(true);
        }

        public APIRequestGetExtendedCreditInvoiceGroups requestAutoEnrollField(boolean value) {
            this.requestField("auto_enroll", value);
            return this;
        }

        public APIRequestGetExtendedCreditInvoiceGroups requestCustomerPoNumberField() {
            return this.requestCustomerPoNumberField(true);
        }

        public APIRequestGetExtendedCreditInvoiceGroups requestCustomerPoNumberField(boolean value) {
            this.requestField("customer_po_number", value);
            return this;
        }

        public APIRequestGetExtendedCreditInvoiceGroups requestEmailField() {
            return this.requestEmailField(true);
        }

        public APIRequestGetExtendedCreditInvoiceGroups requestEmailField(boolean value) {
            this.requestField("email", value);
            return this;
        }

        public APIRequestGetExtendedCreditInvoiceGroups requestEmailsField() {
            return this.requestEmailsField(true);
        }

        public APIRequestGetExtendedCreditInvoiceGroups requestEmailsField(boolean value) {
            this.requestField("emails", value);
            return this;
        }

        public APIRequestGetExtendedCreditInvoiceGroups requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetExtendedCreditInvoiceGroups requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetExtendedCreditInvoiceGroups requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetExtendedCreditInvoiceGroups requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetExtendedCreditEmails
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetExtendedCreditEmails.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetExtendedCreditEmails(String nodeId, APIContext context) {
            super(context, nodeId, "/extended_credit_emails", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetExtendedCreditEmails setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetExtendedCreditEmails setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetExtendedCreditEmails requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetExtendedCreditEmails requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetExtendedCreditEmails requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetExtendedCreditEmails requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetExtendedCreditEmails requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetExtendedCreditEmails requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

