/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Application;
import com.facebook.ads.sdk.Event;
import com.facebook.ads.sdk.Place;
import com.facebook.ads.sdk.Privacy;
import com.facebook.ads.sdk.Profile;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Post
extends APINode {
    @SerializedName(value="actions")
    private JsonArray mActions = null;
    @SerializedName(value="admin_creator")
    private Object mAdminCreator = null;
    @SerializedName(value="allowed_advertising_objectives")
    private List<String> mAllowedAdvertisingObjectives = null;
    @SerializedName(value="application")
    private Application mApplication = null;
    @SerializedName(value="backdated_time")
    private String mBackdatedTime = null;
    @SerializedName(value="call_to_action")
    private Object mCallToAction = null;
    @SerializedName(value="can_reply_privately")
    private Boolean mCanReplyPrivately = null;
    @SerializedName(value="caption")
    private String mCaption = null;
    @SerializedName(value="child_attachments")
    private JsonArray mChildAttachments = null;
    @SerializedName(value="comments_mirroring_domain")
    private String mCommentsMirroringDomain = null;
    @SerializedName(value="coordinates")
    private Object mCoordinates = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="event")
    private Event mEvent = null;
    @SerializedName(value="expanded_height")
    private Long mExpandedHeight = null;
    @SerializedName(value="expanded_width")
    private Long mExpandedWidth = null;
    @SerializedName(value="feed_targeting")
    private Object mFeedTargeting = null;
    @SerializedName(value="from")
    private Object mFrom = null;
    @SerializedName(value="full_picture")
    private String mFullPicture = null;
    @SerializedName(value="height")
    private Long mHeight = null;
    @SerializedName(value="icon")
    private String mIcon = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="instagram_eligibility")
    private String mInstagramEligibility = null;
    @SerializedName(value="is_app_share")
    private Boolean mIsAppShare = null;
    @SerializedName(value="is_eligible_for_promotion")
    private Boolean mIsEligibleForPromotion = null;
    @SerializedName(value="is_expired")
    private Boolean mIsExpired = null;
    @SerializedName(value="is_hidden")
    private Boolean mIsHidden = null;
    @SerializedName(value="is_instagram_eligible")
    private Boolean mIsInstagramEligible = null;
    @SerializedName(value="is_popular")
    private Boolean mIsPopular = null;
    @SerializedName(value="is_published")
    private Boolean mIsPublished = null;
    @SerializedName(value="is_spherical")
    private Boolean mIsSpherical = null;
    @SerializedName(value="link")
    private String mLink = null;
    @SerializedName(value="message")
    private String mMessage = null;
    @SerializedName(value="message_tags")
    private JsonArray mMessageTags = null;
    @SerializedName(value="multi_share_end_card")
    private Boolean mMultiShareEndCard = null;
    @SerializedName(value="multi_share_optimized")
    private Boolean mMultiShareOptimized = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="object_id")
    private String mObjectId = null;
    @SerializedName(value="parent_id")
    private String mParentId = null;
    @SerializedName(value="permalink_url")
    private Object mPermalinkUrl = null;
    @SerializedName(value="picture")
    private String mPicture = null;
    @SerializedName(value="place")
    private Place mPlace = null;
    @SerializedName(value="privacy")
    private Privacy mPrivacy = null;
    @SerializedName(value="promotable_id")
    private String mPromotableId = null;
    @SerializedName(value="promotion_status")
    private String mPromotionStatus = null;
    @SerializedName(value="properties")
    private JsonArray mProperties = null;
    @SerializedName(value="scheduled_publish_time")
    private Double mScheduledPublishTime = null;
    @SerializedName(value="shares")
    private Object mShares = null;
    @SerializedName(value="source")
    private String mSource = null;
    @SerializedName(value="status_type")
    private String mStatusType = null;
    @SerializedName(value="story")
    private String mStory = null;
    @SerializedName(value="story_tags")
    private JsonArray mStoryTags = null;
    @SerializedName(value="subscribed")
    private Boolean mSubscribed = null;
    @SerializedName(value="target")
    private Profile mTarget = null;
    @SerializedName(value="targeting")
    private Object mTargeting = null;
    @SerializedName(value="timeline_visibility")
    private String mTimelineVisibility = null;
    @SerializedName(value="type")
    private String mType = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    @SerializedName(value="via")
    private Object mVia = null;
    @SerializedName(value="video_buying_eligibility")
    private List<String> mVideoBuyingEligibility = null;
    @SerializedName(value="width")
    private Long mWidth = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static Post loadJSON(String json, APIContext context, String header) {
        Post post = (Post)Post.getGson().fromJson(json, Post.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(post.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        post.context = context;
        post.rawValue = json;
        post.header = header;
        return post;
    }

    public static APINodeList<Post> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<Post> posts = new APINodeList<Post>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        posts.add(Post.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return posts;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            posts.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        posts.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            posts.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            posts.add(Post.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                posts.add(Post.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            posts.add(Post.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return posts;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        posts.add(Post.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return posts;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        posts.add(Post.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return posts;
                }
                posts.clear();
                posts.add(Post.loadJSON(json, context, header));
                return posts;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Post.getGson().toJson((Object)this);
    }

    public JsonArray getFieldActions() {
        return this.mActions;
    }

    public Post setFieldActions(JsonArray value) {
        this.mActions = value;
        return this;
    }

    public Object getFieldAdminCreator() {
        return this.mAdminCreator;
    }

    public Post setFieldAdminCreator(Object value) {
        this.mAdminCreator = value;
        return this;
    }

    public List<String> getFieldAllowedAdvertisingObjectives() {
        return this.mAllowedAdvertisingObjectives;
    }

    public Post setFieldAllowedAdvertisingObjectives(List<String> value) {
        this.mAllowedAdvertisingObjectives = value;
        return this;
    }

    public Application getFieldApplication() {
        if (this.mApplication != null) {
            this.mApplication.context = this.getContext();
        }
        return this.mApplication;
    }

    public Post setFieldApplication(Application value) {
        this.mApplication = value;
        return this;
    }

    public Post setFieldApplication(String value) {
        Type type = new TypeToken<Application>(){}.getType();
        this.mApplication = (Application)Application.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldBackdatedTime() {
        return this.mBackdatedTime;
    }

    public Post setFieldBackdatedTime(String value) {
        this.mBackdatedTime = value;
        return this;
    }

    public Object getFieldCallToAction() {
        return this.mCallToAction;
    }

    public Post setFieldCallToAction(Object value) {
        this.mCallToAction = value;
        return this;
    }

    public Boolean getFieldCanReplyPrivately() {
        return this.mCanReplyPrivately;
    }

    public Post setFieldCanReplyPrivately(Boolean value) {
        this.mCanReplyPrivately = value;
        return this;
    }

    public String getFieldCaption() {
        return this.mCaption;
    }

    public Post setFieldCaption(String value) {
        this.mCaption = value;
        return this;
    }

    public JsonArray getFieldChildAttachments() {
        return this.mChildAttachments;
    }

    public Post setFieldChildAttachments(JsonArray value) {
        this.mChildAttachments = value;
        return this;
    }

    public String getFieldCommentsMirroringDomain() {
        return this.mCommentsMirroringDomain;
    }

    public Post setFieldCommentsMirroringDomain(String value) {
        this.mCommentsMirroringDomain = value;
        return this;
    }

    public Object getFieldCoordinates() {
        return this.mCoordinates;
    }

    public Post setFieldCoordinates(Object value) {
        this.mCoordinates = value;
        return this;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public Post setFieldCreatedTime(String value) {
        this.mCreatedTime = value;
        return this;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public Post setFieldDescription(String value) {
        this.mDescription = value;
        return this;
    }

    public Event getFieldEvent() {
        if (this.mEvent != null) {
            this.mEvent.context = this.getContext();
        }
        return this.mEvent;
    }

    public Post setFieldEvent(Event value) {
        this.mEvent = value;
        return this;
    }

    public Post setFieldEvent(String value) {
        Type type = new TypeToken<Event>(){}.getType();
        this.mEvent = (Event)Event.getGson().fromJson(value, type);
        return this;
    }

    public Long getFieldExpandedHeight() {
        return this.mExpandedHeight;
    }

    public Post setFieldExpandedHeight(Long value) {
        this.mExpandedHeight = value;
        return this;
    }

    public Long getFieldExpandedWidth() {
        return this.mExpandedWidth;
    }

    public Post setFieldExpandedWidth(Long value) {
        this.mExpandedWidth = value;
        return this;
    }

    public Object getFieldFeedTargeting() {
        return this.mFeedTargeting;
    }

    public Post setFieldFeedTargeting(Object value) {
        this.mFeedTargeting = value;
        return this;
    }

    public Object getFieldFrom() {
        return this.mFrom;
    }

    public Post setFieldFrom(Object value) {
        this.mFrom = value;
        return this;
    }

    public String getFieldFullPicture() {
        return this.mFullPicture;
    }

    public Post setFieldFullPicture(String value) {
        this.mFullPicture = value;
        return this;
    }

    public Long getFieldHeight() {
        return this.mHeight;
    }

    public Post setFieldHeight(Long value) {
        this.mHeight = value;
        return this;
    }

    public String getFieldIcon() {
        return this.mIcon;
    }

    public Post setFieldIcon(String value) {
        this.mIcon = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Post setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldInstagramEligibility() {
        return this.mInstagramEligibility;
    }

    public Post setFieldInstagramEligibility(String value) {
        this.mInstagramEligibility = value;
        return this;
    }

    public Boolean getFieldIsAppShare() {
        return this.mIsAppShare;
    }

    public Post setFieldIsAppShare(Boolean value) {
        this.mIsAppShare = value;
        return this;
    }

    public Boolean getFieldIsEligibleForPromotion() {
        return this.mIsEligibleForPromotion;
    }

    public Post setFieldIsEligibleForPromotion(Boolean value) {
        this.mIsEligibleForPromotion = value;
        return this;
    }

    public Boolean getFieldIsExpired() {
        return this.mIsExpired;
    }

    public Post setFieldIsExpired(Boolean value) {
        this.mIsExpired = value;
        return this;
    }

    public Boolean getFieldIsHidden() {
        return this.mIsHidden;
    }

    public Post setFieldIsHidden(Boolean value) {
        this.mIsHidden = value;
        return this;
    }

    public Boolean getFieldIsInstagramEligible() {
        return this.mIsInstagramEligible;
    }

    public Post setFieldIsInstagramEligible(Boolean value) {
        this.mIsInstagramEligible = value;
        return this;
    }

    public Boolean getFieldIsPopular() {
        return this.mIsPopular;
    }

    public Post setFieldIsPopular(Boolean value) {
        this.mIsPopular = value;
        return this;
    }

    public Boolean getFieldIsPublished() {
        return this.mIsPublished;
    }

    public Post setFieldIsPublished(Boolean value) {
        this.mIsPublished = value;
        return this;
    }

    public Boolean getFieldIsSpherical() {
        return this.mIsSpherical;
    }

    public Post setFieldIsSpherical(Boolean value) {
        this.mIsSpherical = value;
        return this;
    }

    public String getFieldLink() {
        return this.mLink;
    }

    public Post setFieldLink(String value) {
        this.mLink = value;
        return this;
    }

    public String getFieldMessage() {
        return this.mMessage;
    }

    public Post setFieldMessage(String value) {
        this.mMessage = value;
        return this;
    }

    public JsonArray getFieldMessageTags() {
        return this.mMessageTags;
    }

    public Post setFieldMessageTags(JsonArray value) {
        this.mMessageTags = value;
        return this;
    }

    public Boolean getFieldMultiShareEndCard() {
        return this.mMultiShareEndCard;
    }

    public Post setFieldMultiShareEndCard(Boolean value) {
        this.mMultiShareEndCard = value;
        return this;
    }

    public Boolean getFieldMultiShareOptimized() {
        return this.mMultiShareOptimized;
    }

    public Post setFieldMultiShareOptimized(Boolean value) {
        this.mMultiShareOptimized = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Post setFieldName(String value) {
        this.mName = value;
        return this;
    }

    public String getFieldObjectId() {
        return this.mObjectId;
    }

    public Post setFieldObjectId(String value) {
        this.mObjectId = value;
        return this;
    }

    public String getFieldParentId() {
        return this.mParentId;
    }

    public Post setFieldParentId(String value) {
        this.mParentId = value;
        return this;
    }

    public Object getFieldPermalinkUrl() {
        return this.mPermalinkUrl;
    }

    public Post setFieldPermalinkUrl(Object value) {
        this.mPermalinkUrl = value;
        return this;
    }

    public String getFieldPicture() {
        return this.mPicture;
    }

    public Post setFieldPicture(String value) {
        this.mPicture = value;
        return this;
    }

    public Place getFieldPlace() {
        if (this.mPlace != null) {
            this.mPlace.context = this.getContext();
        }
        return this.mPlace;
    }

    public Post setFieldPlace(Place value) {
        this.mPlace = value;
        return this;
    }

    public Post setFieldPlace(String value) {
        Type type = new TypeToken<Place>(){}.getType();
        this.mPlace = (Place)Place.getGson().fromJson(value, type);
        return this;
    }

    public Privacy getFieldPrivacy() {
        return this.mPrivacy;
    }

    public Post setFieldPrivacy(Privacy value) {
        this.mPrivacy = value;
        return this;
    }

    public Post setFieldPrivacy(String value) {
        Type type = new TypeToken<Privacy>(){}.getType();
        this.mPrivacy = (Privacy)Privacy.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldPromotableId() {
        return this.mPromotableId;
    }

    public Post setFieldPromotableId(String value) {
        this.mPromotableId = value;
        return this;
    }

    public String getFieldPromotionStatus() {
        return this.mPromotionStatus;
    }

    public Post setFieldPromotionStatus(String value) {
        this.mPromotionStatus = value;
        return this;
    }

    public JsonArray getFieldProperties() {
        return this.mProperties;
    }

    public Post setFieldProperties(JsonArray value) {
        this.mProperties = value;
        return this;
    }

    public Double getFieldScheduledPublishTime() {
        return this.mScheduledPublishTime;
    }

    public Post setFieldScheduledPublishTime(Double value) {
        this.mScheduledPublishTime = value;
        return this;
    }

    public Object getFieldShares() {
        return this.mShares;
    }

    public Post setFieldShares(Object value) {
        this.mShares = value;
        return this;
    }

    public String getFieldSource() {
        return this.mSource;
    }

    public Post setFieldSource(String value) {
        this.mSource = value;
        return this;
    }

    public String getFieldStatusType() {
        return this.mStatusType;
    }

    public Post setFieldStatusType(String value) {
        this.mStatusType = value;
        return this;
    }

    public String getFieldStory() {
        return this.mStory;
    }

    public Post setFieldStory(String value) {
        this.mStory = value;
        return this;
    }

    public JsonArray getFieldStoryTags() {
        return this.mStoryTags;
    }

    public Post setFieldStoryTags(JsonArray value) {
        this.mStoryTags = value;
        return this;
    }

    public Boolean getFieldSubscribed() {
        return this.mSubscribed;
    }

    public Post setFieldSubscribed(Boolean value) {
        this.mSubscribed = value;
        return this;
    }

    public Profile getFieldTarget() {
        if (this.mTarget != null) {
            this.mTarget.context = this.getContext();
        }
        return this.mTarget;
    }

    public Post setFieldTarget(Profile value) {
        this.mTarget = value;
        return this;
    }

    public Post setFieldTarget(String value) {
        Type type = new TypeToken<Profile>(){}.getType();
        this.mTarget = (Profile)Profile.getGson().fromJson(value, type);
        return this;
    }

    public Object getFieldTargeting() {
        return this.mTargeting;
    }

    public Post setFieldTargeting(Object value) {
        this.mTargeting = value;
        return this;
    }

    public String getFieldTimelineVisibility() {
        return this.mTimelineVisibility;
    }

    public Post setFieldTimelineVisibility(String value) {
        this.mTimelineVisibility = value;
        return this;
    }

    public String getFieldType() {
        return this.mType;
    }

    public Post setFieldType(String value) {
        this.mType = value;
        return this;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    public Post setFieldUpdatedTime(String value) {
        this.mUpdatedTime = value;
        return this;
    }

    public Object getFieldVia() {
        return this.mVia;
    }

    public Post setFieldVia(Object value) {
        this.mVia = value;
        return this;
    }

    public List<String> getFieldVideoBuyingEligibility() {
        return this.mVideoBuyingEligibility;
    }

    public Post setFieldVideoBuyingEligibility(List<String> value) {
        this.mVideoBuyingEligibility = value;
        return this;
    }

    public Long getFieldWidth() {
        return this.mWidth;
    }

    public Post setFieldWidth(Long value) {
        this.mWidth = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Post copyFrom(Post instance) {
        this.mActions = instance.mActions;
        this.mAdminCreator = instance.mAdminCreator;
        this.mAllowedAdvertisingObjectives = instance.mAllowedAdvertisingObjectives;
        this.mApplication = instance.mApplication;
        this.mBackdatedTime = instance.mBackdatedTime;
        this.mCallToAction = instance.mCallToAction;
        this.mCanReplyPrivately = instance.mCanReplyPrivately;
        this.mCaption = instance.mCaption;
        this.mChildAttachments = instance.mChildAttachments;
        this.mCommentsMirroringDomain = instance.mCommentsMirroringDomain;
        this.mCoordinates = instance.mCoordinates;
        this.mCreatedTime = instance.mCreatedTime;
        this.mDescription = instance.mDescription;
        this.mEvent = instance.mEvent;
        this.mExpandedHeight = instance.mExpandedHeight;
        this.mExpandedWidth = instance.mExpandedWidth;
        this.mFeedTargeting = instance.mFeedTargeting;
        this.mFrom = instance.mFrom;
        this.mFullPicture = instance.mFullPicture;
        this.mHeight = instance.mHeight;
        this.mIcon = instance.mIcon;
        this.mId = instance.mId;
        this.mInstagramEligibility = instance.mInstagramEligibility;
        this.mIsAppShare = instance.mIsAppShare;
        this.mIsEligibleForPromotion = instance.mIsEligibleForPromotion;
        this.mIsExpired = instance.mIsExpired;
        this.mIsHidden = instance.mIsHidden;
        this.mIsInstagramEligible = instance.mIsInstagramEligible;
        this.mIsPopular = instance.mIsPopular;
        this.mIsPublished = instance.mIsPublished;
        this.mIsSpherical = instance.mIsSpherical;
        this.mLink = instance.mLink;
        this.mMessage = instance.mMessage;
        this.mMessageTags = instance.mMessageTags;
        this.mMultiShareEndCard = instance.mMultiShareEndCard;
        this.mMultiShareOptimized = instance.mMultiShareOptimized;
        this.mName = instance.mName;
        this.mObjectId = instance.mObjectId;
        this.mParentId = instance.mParentId;
        this.mPermalinkUrl = instance.mPermalinkUrl;
        this.mPicture = instance.mPicture;
        this.mPlace = instance.mPlace;
        this.mPrivacy = instance.mPrivacy;
        this.mPromotableId = instance.mPromotableId;
        this.mPromotionStatus = instance.mPromotionStatus;
        this.mProperties = instance.mProperties;
        this.mScheduledPublishTime = instance.mScheduledPublishTime;
        this.mShares = instance.mShares;
        this.mSource = instance.mSource;
        this.mStatusType = instance.mStatusType;
        this.mStory = instance.mStory;
        this.mStoryTags = instance.mStoryTags;
        this.mSubscribed = instance.mSubscribed;
        this.mTarget = instance.mTarget;
        this.mTargeting = instance.mTargeting;
        this.mTimelineVisibility = instance.mTimelineVisibility;
        this.mType = instance.mType;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.mVia = instance.mVia;
        this.mVideoBuyingEligibility = instance.mVideoBuyingEligibility;
        this.mWidth = instance.mWidth;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Post> getParser() {
        return new APIRequest.ResponseParser<Post>(){

            @Override
            public APINodeList<Post> parseResponse(String response, APIContext context, APIRequest<Post> request, String header) throws APIException.MalformedResponseException {
                return Post.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumWith {
        VALUE_LOCATION("LOCATION");

        private String value;

        private EnumWith(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

