/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APIRequest;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrashReporter
implements Thread.UncaughtExceptionHandler {
    private static final String TAG = CrashReporter.class.getSimpleName();
    private static CrashReporter instance = null;
    private final Thread.UncaughtExceptionHandler prevHandler;
    private final String appID;
    private static PrintStream logger = System.out;

    private CrashReporter(Thread.UncaughtExceptionHandler prevHandler, String appID) {
        this.prevHandler = prevHandler;
        this.appID = appID;
    }

    public static synchronized void enable(APIContext context) {
        if (instance != null) {
            CrashReporter.log("Already enabled!");
            return;
        }
        String appID = context.getAppID();
        if (appID == null) {
            CrashReporter.log("Unrecognized appID, cannot enable CrashReporter!");
            return;
        }
        Thread.UncaughtExceptionHandler mPrevHandler = Thread.getDefaultUncaughtExceptionHandler();
        instance = new CrashReporter(mPrevHandler, appID);
        Thread.setDefaultUncaughtExceptionHandler(instance);
        CrashReporter.log("Enabled!");
    }

    public static synchronized void disable() {
        if (instance == null) {
            CrashReporter.log("Already disabled!");
            return;
        }
        Thread.UncaughtExceptionHandler mPrevHandler = CrashReporter.instance.prevHandler;
        instance = null;
        CrashReporter.log("Disabled!");
        Thread.setDefaultUncaughtExceptionHandler(mPrevHandler);
    }

    public static void setLogger(PrintStream logger) {
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Map<String, Object> report = CrashReporter.parseIfIsSDKException(e);
        if (report != null) {
            CrashReporter.log("Crashes detected!");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("bizsdk_crash_report", report);
            this.sendOutReporter(params);
        }
        if (this.prevHandler != null) {
            this.prevHandler.uncaughtException(t, e);
        } else {
            e.printStackTrace();
        }
    }

    private void sendOutReporter(Map<String, Object> params) {
        try {
            APIRequest.DefaultRequestExecutor executor = new APIRequest.DefaultRequestExecutor();
            APIContext anonymous = new APIContext(null);
            String apiUrl = "https://graph.facebook.com/v4.0/" + this.appID + "/instruments";
            APIRequest.ResponseWrapper response = executor.execute("POST", apiUrl, params, anonymous);
            CrashReporter.log("Sucess to send out crash reporter");
        }
        catch (Exception e) {
            CrashReporter.log("Fail to send out crash reporter");
        }
    }

    private static Map<String, Object> parseIfIsSDKException(Throwable e) {
        String reason = null;
        StackTraceElement[] eles = e.getStackTrace();
        String[] stacktrace = new String[eles.length];
        int i = 0;
        for (StackTraceElement ele : eles) {
            String str = ele.toString();
            if (reason == null && str.contains("com.facebook.ads.")) {
                reason = "SDK Exception:" + e.getClass().getSimpleName();
            }
            stacktrace[i++] = ele.toString();
        }
        if (e instanceof APIException) {
            reason = "API Exception:" + e.getClass().getSimpleName();
        }
        if (reason != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("reason", reason);
            map.put("platform", System.getProperty("java.version"));
            map.put("callstack", stacktrace);
            return map;
        }
        return null;
    }

    private static void log(String content) {
        if (logger != null) {
            logger.println(String.format("%s : %s", TAG, content));
        }
    }
}

