/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagePaymentOptions
extends APINode {
    @SerializedName(value="amex")
    private Long mAmex = null;
    @SerializedName(value="cash_only")
    private Long mCashOnly = null;
    @SerializedName(value="discover")
    private Long mDiscover = null;
    @SerializedName(value="mastercard")
    private Long mMastercard = null;
    @SerializedName(value="visa")
    private Long mVisa = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static PagePaymentOptions loadJSON(String json, APIContext context, String header) {
        PagePaymentOptions pagePaymentOptions = (PagePaymentOptions)PagePaymentOptions.getGson().fromJson(json, PagePaymentOptions.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(pagePaymentOptions.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        pagePaymentOptions.context = context;
        pagePaymentOptions.rawValue = json;
        pagePaymentOptions.header = header;
        return pagePaymentOptions;
    }

    public static APINodeList<PagePaymentOptions> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PagePaymentOptions> pagePaymentOptionss = new APINodeList<PagePaymentOptions>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        pagePaymentOptionss.add(PagePaymentOptions.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return pagePaymentOptionss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            pagePaymentOptionss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        pagePaymentOptionss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            pagePaymentOptionss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            pagePaymentOptionss.add(PagePaymentOptions.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                pagePaymentOptionss.add(PagePaymentOptions.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            pagePaymentOptionss.add(PagePaymentOptions.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return pagePaymentOptionss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        pagePaymentOptionss.add(PagePaymentOptions.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return pagePaymentOptionss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        pagePaymentOptionss.add(PagePaymentOptions.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return pagePaymentOptionss;
                }
                pagePaymentOptionss.clear();
                pagePaymentOptionss.add(PagePaymentOptions.loadJSON(json, context, header));
                return pagePaymentOptionss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PagePaymentOptions.getGson().toJson((Object)this);
    }

    public Long getFieldAmex() {
        return this.mAmex;
    }

    public PagePaymentOptions setFieldAmex(Long value) {
        this.mAmex = value;
        return this;
    }

    public Long getFieldCashOnly() {
        return this.mCashOnly;
    }

    public PagePaymentOptions setFieldCashOnly(Long value) {
        this.mCashOnly = value;
        return this;
    }

    public Long getFieldDiscover() {
        return this.mDiscover;
    }

    public PagePaymentOptions setFieldDiscover(Long value) {
        this.mDiscover = value;
        return this;
    }

    public Long getFieldMastercard() {
        return this.mMastercard;
    }

    public PagePaymentOptions setFieldMastercard(Long value) {
        this.mMastercard = value;
        return this;
    }

    public Long getFieldVisa() {
        return this.mVisa;
    }

    public PagePaymentOptions setFieldVisa(Long value) {
        this.mVisa = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PagePaymentOptions copyFrom(PagePaymentOptions instance) {
        this.mAmex = instance.mAmex;
        this.mCashOnly = instance.mCashOnly;
        this.mDiscover = instance.mDiscover;
        this.mMastercard = instance.mMastercard;
        this.mVisa = instance.mVisa;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PagePaymentOptions> getParser() {
        return new APIRequest.ResponseParser<PagePaymentOptions>(){

            @Override
            public APINodeList<PagePaymentOptions> parseResponse(String response, APIContext context, APIRequest<PagePaymentOptions> request, String header) throws APIException.MalformedResponseException {
                return PagePaymentOptions.parseResponse(response, context, request, header);
            }
        };
    }
}

