/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusinessActivityLogEvent
extends APINode {
    @SerializedName(value="acted_upon_business_id")
    private String mActedUponBusinessId = null;
    @SerializedName(value="acted_upon_business_name")
    private String mActedUponBusinessName = null;
    @SerializedName(value="acted_upon_business_object_id")
    private String mActedUponBusinessObjectId = null;
    @SerializedName(value="acted_upon_business_object_name")
    private String mActedUponBusinessObjectName = null;
    @SerializedName(value="acted_upon_business_object_type")
    private String mActedUponBusinessObjectType = null;
    @SerializedName(value="acted_upon_user_id")
    private String mActedUponUserId = null;
    @SerializedName(value="acted_upon_user_name")
    private String mActedUponUserName = null;
    @SerializedName(value="acting_business_id")
    private String mActingBusinessId = null;
    @SerializedName(value="acting_business_name")
    private String mActingBusinessName = null;
    @SerializedName(value="acting_user_id")
    private String mActingUserId = null;
    @SerializedName(value="acting_user_name")
    private String mActingUserName = null;
    @SerializedName(value="event_time")
    private Long mEventTime = null;
    @SerializedName(value="event_type")
    private String mEventType = null;
    @SerializedName(value="extra_data")
    private Map<String, String> mExtraData = null;
    @SerializedName(value="target_business_id")
    private String mTargetBusinessId = null;
    @SerializedName(value="target_business_name")
    private String mTargetBusinessName = null;
    @SerializedName(value="target_business_object_id")
    private String mTargetBusinessObjectId = null;
    @SerializedName(value="target_business_object_name")
    private String mTargetBusinessObjectName = null;
    @SerializedName(value="target_business_object_type")
    private String mTargetBusinessObjectType = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static BusinessActivityLogEvent loadJSON(String json, APIContext context, String header) {
        BusinessActivityLogEvent businessActivityLogEvent = (BusinessActivityLogEvent)BusinessActivityLogEvent.getGson().fromJson(json, BusinessActivityLogEvent.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(businessActivityLogEvent.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        businessActivityLogEvent.context = context;
        businessActivityLogEvent.rawValue = json;
        businessActivityLogEvent.header = header;
        return businessActivityLogEvent;
    }

    public static APINodeList<BusinessActivityLogEvent> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BusinessActivityLogEvent> businessActivityLogEvents = new APINodeList<BusinessActivityLogEvent>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        businessActivityLogEvents.add(BusinessActivityLogEvent.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return businessActivityLogEvents;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            businessActivityLogEvents.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        businessActivityLogEvents.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            businessActivityLogEvents.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            businessActivityLogEvents.add(BusinessActivityLogEvent.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                businessActivityLogEvents.add(BusinessActivityLogEvent.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            businessActivityLogEvents.add(BusinessActivityLogEvent.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return businessActivityLogEvents;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        businessActivityLogEvents.add(BusinessActivityLogEvent.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return businessActivityLogEvents;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        businessActivityLogEvents.add(BusinessActivityLogEvent.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return businessActivityLogEvents;
                }
                businessActivityLogEvents.clear();
                businessActivityLogEvents.add(BusinessActivityLogEvent.loadJSON(json, context, header));
                return businessActivityLogEvents;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BusinessActivityLogEvent.getGson().toJson((Object)this);
    }

    public String getFieldActedUponBusinessId() {
        return this.mActedUponBusinessId;
    }

    public BusinessActivityLogEvent setFieldActedUponBusinessId(String value) {
        this.mActedUponBusinessId = value;
        return this;
    }

    public String getFieldActedUponBusinessName() {
        return this.mActedUponBusinessName;
    }

    public BusinessActivityLogEvent setFieldActedUponBusinessName(String value) {
        this.mActedUponBusinessName = value;
        return this;
    }

    public String getFieldActedUponBusinessObjectId() {
        return this.mActedUponBusinessObjectId;
    }

    public BusinessActivityLogEvent setFieldActedUponBusinessObjectId(String value) {
        this.mActedUponBusinessObjectId = value;
        return this;
    }

    public String getFieldActedUponBusinessObjectName() {
        return this.mActedUponBusinessObjectName;
    }

    public BusinessActivityLogEvent setFieldActedUponBusinessObjectName(String value) {
        this.mActedUponBusinessObjectName = value;
        return this;
    }

    public String getFieldActedUponBusinessObjectType() {
        return this.mActedUponBusinessObjectType;
    }

    public BusinessActivityLogEvent setFieldActedUponBusinessObjectType(String value) {
        this.mActedUponBusinessObjectType = value;
        return this;
    }

    public String getFieldActedUponUserId() {
        return this.mActedUponUserId;
    }

    public BusinessActivityLogEvent setFieldActedUponUserId(String value) {
        this.mActedUponUserId = value;
        return this;
    }

    public String getFieldActedUponUserName() {
        return this.mActedUponUserName;
    }

    public BusinessActivityLogEvent setFieldActedUponUserName(String value) {
        this.mActedUponUserName = value;
        return this;
    }

    public String getFieldActingBusinessId() {
        return this.mActingBusinessId;
    }

    public BusinessActivityLogEvent setFieldActingBusinessId(String value) {
        this.mActingBusinessId = value;
        return this;
    }

    public String getFieldActingBusinessName() {
        return this.mActingBusinessName;
    }

    public BusinessActivityLogEvent setFieldActingBusinessName(String value) {
        this.mActingBusinessName = value;
        return this;
    }

    public String getFieldActingUserId() {
        return this.mActingUserId;
    }

    public BusinessActivityLogEvent setFieldActingUserId(String value) {
        this.mActingUserId = value;
        return this;
    }

    public String getFieldActingUserName() {
        return this.mActingUserName;
    }

    public BusinessActivityLogEvent setFieldActingUserName(String value) {
        this.mActingUserName = value;
        return this;
    }

    public Long getFieldEventTime() {
        return this.mEventTime;
    }

    public BusinessActivityLogEvent setFieldEventTime(Long value) {
        this.mEventTime = value;
        return this;
    }

    public String getFieldEventType() {
        return this.mEventType;
    }

    public BusinessActivityLogEvent setFieldEventType(String value) {
        this.mEventType = value;
        return this;
    }

    public Map<String, String> getFieldExtraData() {
        return this.mExtraData;
    }

    public BusinessActivityLogEvent setFieldExtraData(Map<String, String> value) {
        this.mExtraData = value;
        return this;
    }

    public String getFieldTargetBusinessId() {
        return this.mTargetBusinessId;
    }

    public BusinessActivityLogEvent setFieldTargetBusinessId(String value) {
        this.mTargetBusinessId = value;
        return this;
    }

    public String getFieldTargetBusinessName() {
        return this.mTargetBusinessName;
    }

    public BusinessActivityLogEvent setFieldTargetBusinessName(String value) {
        this.mTargetBusinessName = value;
        return this;
    }

    public String getFieldTargetBusinessObjectId() {
        return this.mTargetBusinessObjectId;
    }

    public BusinessActivityLogEvent setFieldTargetBusinessObjectId(String value) {
        this.mTargetBusinessObjectId = value;
        return this;
    }

    public String getFieldTargetBusinessObjectName() {
        return this.mTargetBusinessObjectName;
    }

    public BusinessActivityLogEvent setFieldTargetBusinessObjectName(String value) {
        this.mTargetBusinessObjectName = value;
        return this;
    }

    public String getFieldTargetBusinessObjectType() {
        return this.mTargetBusinessObjectType;
    }

    public BusinessActivityLogEvent setFieldTargetBusinessObjectType(String value) {
        this.mTargetBusinessObjectType = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BusinessActivityLogEvent copyFrom(BusinessActivityLogEvent instance) {
        this.mActedUponBusinessId = instance.mActedUponBusinessId;
        this.mActedUponBusinessName = instance.mActedUponBusinessName;
        this.mActedUponBusinessObjectId = instance.mActedUponBusinessObjectId;
        this.mActedUponBusinessObjectName = instance.mActedUponBusinessObjectName;
        this.mActedUponBusinessObjectType = instance.mActedUponBusinessObjectType;
        this.mActedUponUserId = instance.mActedUponUserId;
        this.mActedUponUserName = instance.mActedUponUserName;
        this.mActingBusinessId = instance.mActingBusinessId;
        this.mActingBusinessName = instance.mActingBusinessName;
        this.mActingUserId = instance.mActingUserId;
        this.mActingUserName = instance.mActingUserName;
        this.mEventTime = instance.mEventTime;
        this.mEventType = instance.mEventType;
        this.mExtraData = instance.mExtraData;
        this.mTargetBusinessId = instance.mTargetBusinessId;
        this.mTargetBusinessName = instance.mTargetBusinessName;
        this.mTargetBusinessObjectId = instance.mTargetBusinessObjectId;
        this.mTargetBusinessObjectName = instance.mTargetBusinessObjectName;
        this.mTargetBusinessObjectType = instance.mTargetBusinessObjectType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BusinessActivityLogEvent> getParser() {
        return new APIRequest.ResponseParser<BusinessActivityLogEvent>(){

            @Override
            public APINodeList<BusinessActivityLogEvent> parseResponse(String response, APIContext context, APIRequest<BusinessActivityLogEvent> request, String header) throws APIException.MalformedResponseException {
                return BusinessActivityLogEvent.parseResponse(response, context, request, header);
            }
        };
    }
}

