/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAccount;
import com.facebook.ads.sdk.AdsPixelStatsResult;
import com.facebook.ads.sdk.AssignedUser;
import com.facebook.ads.sdk.Business;
import com.facebook.ads.sdk.CustomAudience;
import com.facebook.ads.sdk.DACheck;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdsPixel
extends APINode {
    @SerializedName(value="automatic_matching_fields")
    private List<String> mAutomaticMatchingFields = null;
    @SerializedName(value="can_proxy")
    private Boolean mCanProxy = null;
    @SerializedName(value="code")
    private String mCode = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="creator")
    private User mCreator = null;
    @SerializedName(value="data_use_setting")
    private String mDataUseSetting = null;
    @SerializedName(value="enable_automatic_matching")
    private Boolean mEnableAutomaticMatching = null;
    @SerializedName(value="first_party_cookie_status")
    private String mFirstPartyCookieStatus = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_created_by_business")
    private Boolean mIsCreatedByBusiness = null;
    @SerializedName(value="last_fired_time")
    private String mLastFiredTime = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="owner_ad_account")
    private AdAccount mOwnerAdAccount = null;
    @SerializedName(value="owner_business")
    private Business mOwnerBusiness = null;
    protected static Gson gson = null;

    AdsPixel() {
    }

    public AdsPixel(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdsPixel(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdsPixel fetch() throws APIException {
        AdsPixel newInstance = AdsPixel.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdsPixel fetchById(Long id, APIContext context) throws APIException {
        return AdsPixel.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdsPixel> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdsPixel.fetchByIdAsync(id.toString(), context);
    }

    public static AdsPixel fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdsPixel> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdsPixel> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdsPixel>(context, "", "/", "GET", AdsPixel.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdsPixel>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdsPixel>(context, "", "/", "GET", AdsPixel.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdsPixel loadJSON(String json, APIContext context, String header) {
        AdsPixel adsPixel = (AdsPixel)AdsPixel.getGson().fromJson(json, AdsPixel.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adsPixel.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adsPixel.context = context;
        adsPixel.rawValue = json;
        adsPixel.header = header;
        return adsPixel;
    }

    public static APINodeList<AdsPixel> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdsPixel> adsPixels = new APINodeList<AdsPixel>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adsPixels.add(AdsPixel.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adsPixels;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adsPixels.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adsPixels.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adsPixels.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adsPixels.add(AdsPixel.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adsPixels.add(AdsPixel.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adsPixels.add(AdsPixel.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adsPixels;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adsPixels.add(AdsPixel.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adsPixels;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adsPixels.add(AdsPixel.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adsPixels;
                }
                adsPixels.clear();
                adsPixels.add(AdsPixel.loadJSON(json, context, header));
                return adsPixels;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdsPixel.getGson().toJson((Object)this);
    }

    public APIRequestDeleteAssignedUsers deleteAssignedUsers() {
        return new APIRequestDeleteAssignedUsers(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAssignedUsers getAssignedUsers() {
        return new APIRequestGetAssignedUsers(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAssignedUser createAssignedUser() {
        return new APIRequestCreateAssignedUser(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAudiences getAudiences() {
        return new APIRequestGetAudiences(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateCreateServerToServerKey createCreateServerToServerKey() {
        return new APIRequestCreateCreateServerToServerKey(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetDaChecks getDaChecks() {
        return new APIRequestGetDaChecks(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPendingSharedAgencies getPendingSharedAgencies() {
        return new APIRequestGetPendingSharedAgencies(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateResetServerToServerKey createResetServerToServerKey() {
        return new APIRequestCreateResetServerToServerKey(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteSharedAccounts deleteSharedAccounts() {
        return new APIRequestDeleteSharedAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetSharedAccounts getSharedAccounts() {
        return new APIRequestGetSharedAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateSharedAccount createSharedAccount() {
        return new APIRequestCreateSharedAccount(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteSharedAgencies deleteSharedAgencies() {
        return new APIRequestDeleteSharedAgencies(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetSharedAgencies getSharedAgencies() {
        return new APIRequestGetSharedAgencies(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetStats getStats() {
        return new APIRequestGetStats(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public List<String> getFieldAutomaticMatchingFields() {
        return this.mAutomaticMatchingFields;
    }

    public Boolean getFieldCanProxy() {
        return this.mCanProxy;
    }

    public String getFieldCode() {
        return this.mCode;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public User getFieldCreator() {
        if (this.mCreator != null) {
            this.mCreator.context = this.getContext();
        }
        return this.mCreator;
    }

    public String getFieldDataUseSetting() {
        return this.mDataUseSetting;
    }

    public Boolean getFieldEnableAutomaticMatching() {
        return this.mEnableAutomaticMatching;
    }

    public String getFieldFirstPartyCookieStatus() {
        return this.mFirstPartyCookieStatus;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsCreatedByBusiness() {
        return this.mIsCreatedByBusiness;
    }

    public String getFieldLastFiredTime() {
        return this.mLastFiredTime;
    }

    public String getFieldName() {
        return this.mName;
    }

    public AdAccount getFieldOwnerAdAccount() {
        if (this.mOwnerAdAccount != null) {
            this.mOwnerAdAccount.context = this.getContext();
        }
        return this.mOwnerAdAccount;
    }

    public Business getFieldOwnerBusiness() {
        if (this.mOwnerBusiness != null) {
            this.mOwnerBusiness.context = this.getContext();
        }
        return this.mOwnerBusiness;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdsPixel copyFrom(AdsPixel instance) {
        this.mAutomaticMatchingFields = instance.mAutomaticMatchingFields;
        this.mCanProxy = instance.mCanProxy;
        this.mCode = instance.mCode;
        this.mCreationTime = instance.mCreationTime;
        this.mCreator = instance.mCreator;
        this.mDataUseSetting = instance.mDataUseSetting;
        this.mEnableAutomaticMatching = instance.mEnableAutomaticMatching;
        this.mFirstPartyCookieStatus = instance.mFirstPartyCookieStatus;
        this.mId = instance.mId;
        this.mIsCreatedByBusiness = instance.mIsCreatedByBusiness;
        this.mLastFiredTime = instance.mLastFiredTime;
        this.mName = instance.mName;
        this.mOwnerAdAccount = instance.mOwnerAdAccount;
        this.mOwnerBusiness = instance.mOwnerBusiness;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdsPixel> getParser() {
        return new APIRequest.ResponseParser<AdsPixel>(){

            @Override
            public APINodeList<AdsPixel> parseResponse(String response, APIContext context, APIRequest<AdsPixel> request, String header) throws APIException.MalformedResponseException {
                return AdsPixel.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumType {
        VALUE_PRIMARY("PRIMARY"),
        VALUE_SECONDARY("SECONDARY"),
        NULL(null);

        private String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumTasks {
        VALUE_ANALYZE("ANALYZE"),
        VALUE_EDIT("EDIT"),
        NULL(null);

        private String value;

        private EnumTasks(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumFirstPartyCookieStatus {
        VALUE_EMPTY("EMPTY"),
        VALUE_FIRST_PARTY_COOKIE_DISABLED("FIRST_PARTY_COOKIE_DISABLED"),
        VALUE_FIRST_PARTY_COOKIE_ENABLED("FIRST_PARTY_COOKIE_ENABLED"),
        NULL(null);

        private String value;

        private EnumFirstPartyCookieStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumDataUseSetting {
        VALUE_ADVERTISING_AND_ANALYTICS("ADVERTISING_AND_ANALYTICS"),
        VALUE_ANALYTICS_ONLY("ANALYTICS_ONLY"),
        VALUE_EMPTY("EMPTY"),
        NULL(null);

        private String value;

        private EnumDataUseSetting(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumAutomaticMatchingFields {
        VALUE_CT("ct"),
        VALUE_EM("em"),
        VALUE_FN("fn"),
        VALUE_GE("ge"),
        VALUE_LN("ln"),
        VALUE_PH("ph"),
        VALUE_ST("st"),
        VALUE_ZP("zp"),
        NULL(null);

        private String value;

        private EnumAutomaticMatchingFields(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumSortBy {
        VALUE_LAST_FIRED_TIME("LAST_FIRED_TIME"),
        VALUE_NAME("NAME"),
        NULL(null);

        private String value;

        private EnumSortBy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<AdsPixel> {
        AdsPixel lastResponse = null;
        public static final String[] PARAMS = new String[]{"name", "enable_automatic_matching", "automatic_matching_fields", "first_party_cookie_status", "data_use_setting"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdsPixel getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdsPixel parseResponse(String response, String header) throws APIException {
            return AdsPixel.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdsPixel execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdsPixel execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdsPixel> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdsPixel> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdsPixel>(){

                public AdsPixel apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate setEnableAutomaticMatching(Boolean enableAutomaticMatching) {
            this.setParam("enable_automatic_matching", enableAutomaticMatching);
            return this;
        }

        public APIRequestUpdate setEnableAutomaticMatching(String enableAutomaticMatching) {
            this.setParam("enable_automatic_matching", enableAutomaticMatching);
            return this;
        }

        public APIRequestUpdate setAutomaticMatchingFields(List<EnumAutomaticMatchingFields> automaticMatchingFields) {
            this.setParam("automatic_matching_fields", automaticMatchingFields);
            return this;
        }

        public APIRequestUpdate setAutomaticMatchingFields(String automaticMatchingFields) {
            this.setParam("automatic_matching_fields", automaticMatchingFields);
            return this;
        }

        public APIRequestUpdate setFirstPartyCookieStatus(EnumFirstPartyCookieStatus firstPartyCookieStatus) {
            this.setParam("first_party_cookie_status", (Object)firstPartyCookieStatus);
            return this;
        }

        public APIRequestUpdate setFirstPartyCookieStatus(String firstPartyCookieStatus) {
            this.setParam("first_party_cookie_status", firstPartyCookieStatus);
            return this;
        }

        public APIRequestUpdate setDataUseSetting(EnumDataUseSetting dataUseSetting) {
            this.setParam("data_use_setting", (Object)dataUseSetting);
            return this;
        }

        public APIRequestUpdate setDataUseSetting(String dataUseSetting) {
            this.setParam("data_use_setting", dataUseSetting);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdsPixel> {
        AdsPixel lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"automatic_matching_fields", "can_proxy", "code", "creation_time", "creator", "data_use_setting", "enable_automatic_matching", "first_party_cookie_status", "id", "is_created_by_business", "last_fired_time", "name", "owner_ad_account", "owner_business"};

        @Override
        public AdsPixel getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdsPixel parseResponse(String response, String header) throws APIException {
            return AdsPixel.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdsPixel execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdsPixel execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdsPixel> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdsPixel> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdsPixel>(){

                public AdsPixel apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAutomaticMatchingFieldsField() {
            return this.requestAutomaticMatchingFieldsField(true);
        }

        public APIRequestGet requestAutomaticMatchingFieldsField(boolean value) {
            this.requestField("automatic_matching_fields", value);
            return this;
        }

        public APIRequestGet requestCanProxyField() {
            return this.requestCanProxyField(true);
        }

        public APIRequestGet requestCanProxyField(boolean value) {
            this.requestField("can_proxy", value);
            return this;
        }

        public APIRequestGet requestCodeField() {
            return this.requestCodeField(true);
        }

        public APIRequestGet requestCodeField(boolean value) {
            this.requestField("code", value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestCreatorField() {
            return this.requestCreatorField(true);
        }

        public APIRequestGet requestCreatorField(boolean value) {
            this.requestField("creator", value);
            return this;
        }

        public APIRequestGet requestDataUseSettingField() {
            return this.requestDataUseSettingField(true);
        }

        public APIRequestGet requestDataUseSettingField(boolean value) {
            this.requestField("data_use_setting", value);
            return this;
        }

        public APIRequestGet requestEnableAutomaticMatchingField() {
            return this.requestEnableAutomaticMatchingField(true);
        }

        public APIRequestGet requestEnableAutomaticMatchingField(boolean value) {
            this.requestField("enable_automatic_matching", value);
            return this;
        }

        public APIRequestGet requestFirstPartyCookieStatusField() {
            return this.requestFirstPartyCookieStatusField(true);
        }

        public APIRequestGet requestFirstPartyCookieStatusField(boolean value) {
            this.requestField("first_party_cookie_status", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsCreatedByBusinessField() {
            return this.requestIsCreatedByBusinessField(true);
        }

        public APIRequestGet requestIsCreatedByBusinessField(boolean value) {
            this.requestField("is_created_by_business", value);
            return this;
        }

        public APIRequestGet requestLastFiredTimeField() {
            return this.requestLastFiredTimeField(true);
        }

        public APIRequestGet requestLastFiredTimeField(boolean value) {
            this.requestField("last_fired_time", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestOwnerAdAccountField() {
            return this.requestOwnerAdAccountField(true);
        }

        public APIRequestGet requestOwnerAdAccountField(boolean value) {
            this.requestField("owner_ad_account", value);
            return this;
        }

        public APIRequestGet requestOwnerBusinessField() {
            return this.requestOwnerBusinessField(true);
        }

        public APIRequestGet requestOwnerBusinessField(boolean value) {
            this.requestField("owner_business", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetStats
    extends APIRequest<AdsPixelStatsResult> {
        APINodeList<AdsPixelStatsResult> lastResponse = null;
        public static final String[] PARAMS = new String[]{"start_time", "end_time", "aggregation", "event", "event_source"};
        public static final String[] FIELDS = new String[]{"aggregation", "data", "start_time", "id"};

        @Override
        public APINodeList<AdsPixelStatsResult> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdsPixelStatsResult> parseResponse(String response, String header) throws APIException {
            return AdsPixelStatsResult.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdsPixelStatsResult> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdsPixelStatsResult> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdsPixelStatsResult>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdsPixelStatsResult>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AdsPixelStatsResult>>(){

                public APINodeList<AdsPixelStatsResult> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetStats.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetStats(String nodeId, APIContext context) {
            super(context, nodeId, "/stats", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetStats setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetStats setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetStats setStartTime(String startTime) {
            this.setParam("start_time", startTime);
            return this;
        }

        public APIRequestGetStats setEndTime(String endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestGetStats setAggregation(AdsPixelStatsResult.EnumAggregation aggregation) {
            this.setParam("aggregation", (Object)aggregation);
            return this;
        }

        public APIRequestGetStats setAggregation(String aggregation) {
            this.setParam("aggregation", aggregation);
            return this;
        }

        public APIRequestGetStats setEvent(String event) {
            this.setParam("event", event);
            return this;
        }

        public APIRequestGetStats setEventSource(String eventSource) {
            this.setParam("event_source", eventSource);
            return this;
        }

        public APIRequestGetStats requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetStats requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetStats requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetStats requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetStats requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetStats requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetStats requestAggregationField() {
            return this.requestAggregationField(true);
        }

        public APIRequestGetStats requestAggregationField(boolean value) {
            this.requestField("aggregation", value);
            return this;
        }

        public APIRequestGetStats requestDataField() {
            return this.requestDataField(true);
        }

        public APIRequestGetStats requestDataField(boolean value) {
            this.requestField("data", value);
            return this;
        }

        public APIRequestGetStats requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGetStats requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGetStats requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetStats requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetSharedAgencies
    extends APIRequest<Business> {
        APINodeList<Business> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"block_offline_analytics", "created_by", "created_time", "extended_updated_time", "id", "is_hidden", "is_instagram_enabled_in_fb_analytics", "link", "name", "primary_page", "profile_picture_uri", "timezone_id", "two_factor_type", "updated_by", "updated_time", "verification_status", "vertical", "vertical_id"};

        @Override
        public APINodeList<Business> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Business> parseResponse(String response, String header) throws APIException {
            return Business.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Business> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Business> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Business>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Business>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Business>>(){

                public APINodeList<Business> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetSharedAgencies.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetSharedAgencies(String nodeId, APIContext context) {
            super(context, nodeId, "/shared_agencies", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetSharedAgencies setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetSharedAgencies setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetSharedAgencies requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetSharedAgencies requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSharedAgencies requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetSharedAgencies requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSharedAgencies requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetSharedAgencies requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetSharedAgencies requestBlockOfflineAnalyticsField() {
            return this.requestBlockOfflineAnalyticsField(true);
        }

        public APIRequestGetSharedAgencies requestBlockOfflineAnalyticsField(boolean value) {
            this.requestField("block_offline_analytics", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestCreatedByField() {
            return this.requestCreatedByField(true);
        }

        public APIRequestGetSharedAgencies requestCreatedByField(boolean value) {
            this.requestField("created_by", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetSharedAgencies requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestExtendedUpdatedTimeField() {
            return this.requestExtendedUpdatedTimeField(true);
        }

        public APIRequestGetSharedAgencies requestExtendedUpdatedTimeField(boolean value) {
            this.requestField("extended_updated_time", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetSharedAgencies requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestIsHiddenField() {
            return this.requestIsHiddenField(true);
        }

        public APIRequestGetSharedAgencies requestIsHiddenField(boolean value) {
            this.requestField("is_hidden", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestIsInstagramEnabledInFbAnalyticsField() {
            return this.requestIsInstagramEnabledInFbAnalyticsField(true);
        }

        public APIRequestGetSharedAgencies requestIsInstagramEnabledInFbAnalyticsField(boolean value) {
            this.requestField("is_instagram_enabled_in_fb_analytics", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetSharedAgencies requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetSharedAgencies requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestPrimaryPageField() {
            return this.requestPrimaryPageField(true);
        }

        public APIRequestGetSharedAgencies requestPrimaryPageField(boolean value) {
            this.requestField("primary_page", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestProfilePictureUriField() {
            return this.requestProfilePictureUriField(true);
        }

        public APIRequestGetSharedAgencies requestProfilePictureUriField(boolean value) {
            this.requestField("profile_picture_uri", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGetSharedAgencies requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestTwoFactorTypeField() {
            return this.requestTwoFactorTypeField(true);
        }

        public APIRequestGetSharedAgencies requestTwoFactorTypeField(boolean value) {
            this.requestField("two_factor_type", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestUpdatedByField() {
            return this.requestUpdatedByField(true);
        }

        public APIRequestGetSharedAgencies requestUpdatedByField(boolean value) {
            this.requestField("updated_by", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetSharedAgencies requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestVerificationStatusField() {
            return this.requestVerificationStatusField(true);
        }

        public APIRequestGetSharedAgencies requestVerificationStatusField(boolean value) {
            this.requestField("verification_status", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestVerticalField() {
            return this.requestVerticalField(true);
        }

        public APIRequestGetSharedAgencies requestVerticalField(boolean value) {
            this.requestField("vertical", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestVerticalIdField() {
            return this.requestVerticalIdField(true);
        }

        public APIRequestGetSharedAgencies requestVerticalIdField(boolean value) {
            this.requestField("vertical_id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteSharedAgencies
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"agency_id", "business"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestDeleteSharedAgencies.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteSharedAgencies(String nodeId, APIContext context) {
            super(context, nodeId, "/shared_agencies", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteSharedAgencies setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteSharedAgencies setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteSharedAgencies setAgencyId(String agencyId) {
            this.setParam("agency_id", agencyId);
            return this;
        }

        public APIRequestDeleteSharedAgencies setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestDeleteSharedAgencies requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteSharedAgencies requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteSharedAgencies requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteSharedAgencies requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteSharedAgencies requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteSharedAgencies requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateSharedAccount
    extends APIRequest<AdsPixel> {
        AdsPixel lastResponse = null;
        public static final String[] PARAMS = new String[]{"account_id", "business"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdsPixel getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdsPixel parseResponse(String response, String header) throws APIException {
            return AdsPixel.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdsPixel execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdsPixel execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdsPixel> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdsPixel> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdsPixel>(){

                public AdsPixel apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateSharedAccount.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateSharedAccount(String nodeId, APIContext context) {
            super(context, nodeId, "/shared_accounts", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateSharedAccount setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateSharedAccount setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateSharedAccount setAccountId(String accountId) {
            this.setParam("account_id", accountId);
            return this;
        }

        public APIRequestCreateSharedAccount setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestCreateSharedAccount requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateSharedAccount requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateSharedAccount requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateSharedAccount requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateSharedAccount requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateSharedAccount requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetSharedAccounts
    extends APIRequest<AdAccount> {
        APINodeList<AdAccount> lastResponse = null;
        public static final String[] PARAMS = new String[]{"business"};
        public static final String[] FIELDS = new String[]{"account_id", "account_status", "ad_account_creation_request", "ad_account_promotable_objects", "age", "agency_client_declaration", "amount_spent", "attribution_spec", "balance", "business", "business_city", "business_country_code", "business_name", "business_state", "business_street", "business_street2", "business_zip", "capabilities", "created_time", "currency", "direct_deals_tos_accepted", "disable_reason", "end_advertiser", "end_advertiser_name", "extended_credit_invoice_group", "failed_delivery_checks", "funding_source", "funding_source_details", "has_migrated_permissions", "has_page_authorized_adaccount", "id", "io_number", "is_attribution_spec_system_default", "is_direct_deals_enabled", "is_in_3ds_authorization_enabled_market", "is_in_middle_of_local_entity_migration", "is_notifications_enabled", "is_personal", "is_prepay_account", "is_tax_id_required", "line_numbers", "media_agency", "min_campaign_group_spend_cap", "min_daily_budget", "name", "offsite_pixels_tos_accepted", "owner", "partner", "rf_spec", "show_checkout_experience", "spend_cap", "tax_id", "tax_id_status", "tax_id_type", "timezone_id", "timezone_name", "timezone_offset_hours_utc", "tos_accepted", "user_role", "user_tos_accepted"};

        @Override
        public APINodeList<AdAccount> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccount> parseResponse(String response, String header) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdAccount> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccount> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAccount>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAccount>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AdAccount>>(){

                public APINodeList<AdAccount> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetSharedAccounts.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetSharedAccounts(String nodeId, APIContext context) {
            super(context, nodeId, "/shared_accounts", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetSharedAccounts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetSharedAccounts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetSharedAccounts setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestGetSharedAccounts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetSharedAccounts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSharedAccounts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetSharedAccounts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSharedAccounts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetSharedAccounts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetSharedAccounts requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetSharedAccounts requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestAccountStatusField() {
            return this.requestAccountStatusField(true);
        }

        public APIRequestGetSharedAccounts requestAccountStatusField(boolean value) {
            this.requestField("account_status", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestAdAccountCreationRequestField() {
            return this.requestAdAccountCreationRequestField(true);
        }

        public APIRequestGetSharedAccounts requestAdAccountCreationRequestField(boolean value) {
            this.requestField("ad_account_creation_request", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestAdAccountPromotableObjectsField() {
            return this.requestAdAccountPromotableObjectsField(true);
        }

        public APIRequestGetSharedAccounts requestAdAccountPromotableObjectsField(boolean value) {
            this.requestField("ad_account_promotable_objects", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestAgeField() {
            return this.requestAgeField(true);
        }

        public APIRequestGetSharedAccounts requestAgeField(boolean value) {
            this.requestField("age", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestAgencyClientDeclarationField() {
            return this.requestAgencyClientDeclarationField(true);
        }

        public APIRequestGetSharedAccounts requestAgencyClientDeclarationField(boolean value) {
            this.requestField("agency_client_declaration", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestAmountSpentField() {
            return this.requestAmountSpentField(true);
        }

        public APIRequestGetSharedAccounts requestAmountSpentField(boolean value) {
            this.requestField("amount_spent", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestAttributionSpecField() {
            return this.requestAttributionSpecField(true);
        }

        public APIRequestGetSharedAccounts requestAttributionSpecField(boolean value) {
            this.requestField("attribution_spec", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestBalanceField() {
            return this.requestBalanceField(true);
        }

        public APIRequestGetSharedAccounts requestBalanceField(boolean value) {
            this.requestField("balance", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetSharedAccounts requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestBusinessCityField() {
            return this.requestBusinessCityField(true);
        }

        public APIRequestGetSharedAccounts requestBusinessCityField(boolean value) {
            this.requestField("business_city", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestBusinessCountryCodeField() {
            return this.requestBusinessCountryCodeField(true);
        }

        public APIRequestGetSharedAccounts requestBusinessCountryCodeField(boolean value) {
            this.requestField("business_country_code", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestBusinessNameField() {
            return this.requestBusinessNameField(true);
        }

        public APIRequestGetSharedAccounts requestBusinessNameField(boolean value) {
            this.requestField("business_name", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestBusinessStateField() {
            return this.requestBusinessStateField(true);
        }

        public APIRequestGetSharedAccounts requestBusinessStateField(boolean value) {
            this.requestField("business_state", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestBusinessStreetField() {
            return this.requestBusinessStreetField(true);
        }

        public APIRequestGetSharedAccounts requestBusinessStreetField(boolean value) {
            this.requestField("business_street", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestBusinessStreet2Field() {
            return this.requestBusinessStreet2Field(true);
        }

        public APIRequestGetSharedAccounts requestBusinessStreet2Field(boolean value) {
            this.requestField("business_street2", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestBusinessZipField() {
            return this.requestBusinessZipField(true);
        }

        public APIRequestGetSharedAccounts requestBusinessZipField(boolean value) {
            this.requestField("business_zip", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestCapabilitiesField() {
            return this.requestCapabilitiesField(true);
        }

        public APIRequestGetSharedAccounts requestCapabilitiesField(boolean value) {
            this.requestField("capabilities", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetSharedAccounts requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGetSharedAccounts requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestDirectDealsTosAcceptedField() {
            return this.requestDirectDealsTosAcceptedField(true);
        }

        public APIRequestGetSharedAccounts requestDirectDealsTosAcceptedField(boolean value) {
            this.requestField("direct_deals_tos_accepted", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestDisableReasonField() {
            return this.requestDisableReasonField(true);
        }

        public APIRequestGetSharedAccounts requestDisableReasonField(boolean value) {
            this.requestField("disable_reason", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestEndAdvertiserField() {
            return this.requestEndAdvertiserField(true);
        }

        public APIRequestGetSharedAccounts requestEndAdvertiserField(boolean value) {
            this.requestField("end_advertiser", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestEndAdvertiserNameField() {
            return this.requestEndAdvertiserNameField(true);
        }

        public APIRequestGetSharedAccounts requestEndAdvertiserNameField(boolean value) {
            this.requestField("end_advertiser_name", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestExtendedCreditInvoiceGroupField() {
            return this.requestExtendedCreditInvoiceGroupField(true);
        }

        public APIRequestGetSharedAccounts requestExtendedCreditInvoiceGroupField(boolean value) {
            this.requestField("extended_credit_invoice_group", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestFailedDeliveryChecksField() {
            return this.requestFailedDeliveryChecksField(true);
        }

        public APIRequestGetSharedAccounts requestFailedDeliveryChecksField(boolean value) {
            this.requestField("failed_delivery_checks", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestFundingSourceField() {
            return this.requestFundingSourceField(true);
        }

        public APIRequestGetSharedAccounts requestFundingSourceField(boolean value) {
            this.requestField("funding_source", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestFundingSourceDetailsField() {
            return this.requestFundingSourceDetailsField(true);
        }

        public APIRequestGetSharedAccounts requestFundingSourceDetailsField(boolean value) {
            this.requestField("funding_source_details", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestHasMigratedPermissionsField() {
            return this.requestHasMigratedPermissionsField(true);
        }

        public APIRequestGetSharedAccounts requestHasMigratedPermissionsField(boolean value) {
            this.requestField("has_migrated_permissions", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestHasPageAuthorizedAdaccountField() {
            return this.requestHasPageAuthorizedAdaccountField(true);
        }

        public APIRequestGetSharedAccounts requestHasPageAuthorizedAdaccountField(boolean value) {
            this.requestField("has_page_authorized_adaccount", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetSharedAccounts requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestIoNumberField() {
            return this.requestIoNumberField(true);
        }

        public APIRequestGetSharedAccounts requestIoNumberField(boolean value) {
            this.requestField("io_number", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestIsAttributionSpecSystemDefaultField() {
            return this.requestIsAttributionSpecSystemDefaultField(true);
        }

        public APIRequestGetSharedAccounts requestIsAttributionSpecSystemDefaultField(boolean value) {
            this.requestField("is_attribution_spec_system_default", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestIsDirectDealsEnabledField() {
            return this.requestIsDirectDealsEnabledField(true);
        }

        public APIRequestGetSharedAccounts requestIsDirectDealsEnabledField(boolean value) {
            this.requestField("is_direct_deals_enabled", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestIsIn3dsAuthorizationEnabledMarketField() {
            return this.requestIsIn3dsAuthorizationEnabledMarketField(true);
        }

        public APIRequestGetSharedAccounts requestIsIn3dsAuthorizationEnabledMarketField(boolean value) {
            this.requestField("is_in_3ds_authorization_enabled_market", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestIsInMiddleOfLocalEntityMigrationField() {
            return this.requestIsInMiddleOfLocalEntityMigrationField(true);
        }

        public APIRequestGetSharedAccounts requestIsInMiddleOfLocalEntityMigrationField(boolean value) {
            this.requestField("is_in_middle_of_local_entity_migration", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestIsNotificationsEnabledField() {
            return this.requestIsNotificationsEnabledField(true);
        }

        public APIRequestGetSharedAccounts requestIsNotificationsEnabledField(boolean value) {
            this.requestField("is_notifications_enabled", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestIsPersonalField() {
            return this.requestIsPersonalField(true);
        }

        public APIRequestGetSharedAccounts requestIsPersonalField(boolean value) {
            this.requestField("is_personal", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestIsPrepayAccountField() {
            return this.requestIsPrepayAccountField(true);
        }

        public APIRequestGetSharedAccounts requestIsPrepayAccountField(boolean value) {
            this.requestField("is_prepay_account", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestIsTaxIdRequiredField() {
            return this.requestIsTaxIdRequiredField(true);
        }

        public APIRequestGetSharedAccounts requestIsTaxIdRequiredField(boolean value) {
            this.requestField("is_tax_id_required", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestLineNumbersField() {
            return this.requestLineNumbersField(true);
        }

        public APIRequestGetSharedAccounts requestLineNumbersField(boolean value) {
            this.requestField("line_numbers", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestMediaAgencyField() {
            return this.requestMediaAgencyField(true);
        }

        public APIRequestGetSharedAccounts requestMediaAgencyField(boolean value) {
            this.requestField("media_agency", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestMinCampaignGroupSpendCapField() {
            return this.requestMinCampaignGroupSpendCapField(true);
        }

        public APIRequestGetSharedAccounts requestMinCampaignGroupSpendCapField(boolean value) {
            this.requestField("min_campaign_group_spend_cap", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestMinDailyBudgetField() {
            return this.requestMinDailyBudgetField(true);
        }

        public APIRequestGetSharedAccounts requestMinDailyBudgetField(boolean value) {
            this.requestField("min_daily_budget", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetSharedAccounts requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestOffsitePixelsTosAcceptedField() {
            return this.requestOffsitePixelsTosAcceptedField(true);
        }

        public APIRequestGetSharedAccounts requestOffsitePixelsTosAcceptedField(boolean value) {
            this.requestField("offsite_pixels_tos_accepted", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGetSharedAccounts requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestPartnerField() {
            return this.requestPartnerField(true);
        }

        public APIRequestGetSharedAccounts requestPartnerField(boolean value) {
            this.requestField("partner", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestRfSpecField() {
            return this.requestRfSpecField(true);
        }

        public APIRequestGetSharedAccounts requestRfSpecField(boolean value) {
            this.requestField("rf_spec", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestShowCheckoutExperienceField() {
            return this.requestShowCheckoutExperienceField(true);
        }

        public APIRequestGetSharedAccounts requestShowCheckoutExperienceField(boolean value) {
            this.requestField("show_checkout_experience", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestSpendCapField() {
            return this.requestSpendCapField(true);
        }

        public APIRequestGetSharedAccounts requestSpendCapField(boolean value) {
            this.requestField("spend_cap", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestTaxIdField() {
            return this.requestTaxIdField(true);
        }

        public APIRequestGetSharedAccounts requestTaxIdField(boolean value) {
            this.requestField("tax_id", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestTaxIdStatusField() {
            return this.requestTaxIdStatusField(true);
        }

        public APIRequestGetSharedAccounts requestTaxIdStatusField(boolean value) {
            this.requestField("tax_id_status", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestTaxIdTypeField() {
            return this.requestTaxIdTypeField(true);
        }

        public APIRequestGetSharedAccounts requestTaxIdTypeField(boolean value) {
            this.requestField("tax_id_type", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGetSharedAccounts requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestTimezoneNameField() {
            return this.requestTimezoneNameField(true);
        }

        public APIRequestGetSharedAccounts requestTimezoneNameField(boolean value) {
            this.requestField("timezone_name", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestTimezoneOffsetHoursUtcField() {
            return this.requestTimezoneOffsetHoursUtcField(true);
        }

        public APIRequestGetSharedAccounts requestTimezoneOffsetHoursUtcField(boolean value) {
            this.requestField("timezone_offset_hours_utc", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestTosAcceptedField() {
            return this.requestTosAcceptedField(true);
        }

        public APIRequestGetSharedAccounts requestTosAcceptedField(boolean value) {
            this.requestField("tos_accepted", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestUserRoleField() {
            return this.requestUserRoleField(true);
        }

        public APIRequestGetSharedAccounts requestUserRoleField(boolean value) {
            this.requestField("user_role", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestUserTosAcceptedField() {
            return this.requestUserTosAcceptedField(true);
        }

        public APIRequestGetSharedAccounts requestUserTosAcceptedField(boolean value) {
            this.requestField("user_tos_accepted", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteSharedAccounts
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"account_id", "business"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestDeleteSharedAccounts.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteSharedAccounts(String nodeId, APIContext context) {
            super(context, nodeId, "/shared_accounts", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteSharedAccounts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteSharedAccounts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteSharedAccounts setAccountId(String accountId) {
            this.setParam("account_id", accountId);
            return this;
        }

        public APIRequestDeleteSharedAccounts setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestDeleteSharedAccounts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteSharedAccounts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteSharedAccounts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteSharedAccounts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteSharedAccounts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteSharedAccounts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateResetServerToServerKey
    extends APIRequest<AdsPixel> {
        AdsPixel lastResponse = null;
        public static final String[] PARAMS = new String[]{"type"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdsPixel getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdsPixel parseResponse(String response, String header) throws APIException {
            return AdsPixel.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdsPixel execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdsPixel execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdsPixel> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdsPixel> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdsPixel>(){

                public AdsPixel apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateResetServerToServerKey.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateResetServerToServerKey(String nodeId, APIContext context) {
            super(context, nodeId, "/reset_server_to_server_key", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateResetServerToServerKey setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateResetServerToServerKey setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateResetServerToServerKey setType(EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestCreateResetServerToServerKey setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestCreateResetServerToServerKey requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateResetServerToServerKey requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateResetServerToServerKey requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateResetServerToServerKey requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateResetServerToServerKey requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateResetServerToServerKey requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetPendingSharedAgencies
    extends APIRequest<Business> {
        APINodeList<Business> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"block_offline_analytics", "created_by", "created_time", "extended_updated_time", "id", "is_hidden", "is_instagram_enabled_in_fb_analytics", "link", "name", "primary_page", "profile_picture_uri", "timezone_id", "two_factor_type", "updated_by", "updated_time", "verification_status", "vertical", "vertical_id"};

        @Override
        public APINodeList<Business> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Business> parseResponse(String response, String header) throws APIException {
            return Business.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Business> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Business> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Business>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Business>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Business>>(){

                public APINodeList<Business> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetPendingSharedAgencies.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPendingSharedAgencies(String nodeId, APIContext context) {
            super(context, nodeId, "/pending_shared_agencies", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPendingSharedAgencies setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPendingSharedAgencies setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPendingSharedAgencies requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPendingSharedAgencies requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPendingSharedAgencies requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPendingSharedAgencies requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPendingSharedAgencies requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPendingSharedAgencies requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPendingSharedAgencies requestBlockOfflineAnalyticsField() {
            return this.requestBlockOfflineAnalyticsField(true);
        }

        public APIRequestGetPendingSharedAgencies requestBlockOfflineAnalyticsField(boolean value) {
            this.requestField("block_offline_analytics", value);
            return this;
        }

        public APIRequestGetPendingSharedAgencies requestCreatedByField() {
            return this.requestCreatedByField(true);
        }

        public APIRequestGetPendingSharedAgencies requestCreatedByField(boolean value) {
            this.requestField("created_by", value);
            return this;
        }

        public APIRequestGetPendingSharedAgencies requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetPendingSharedAgencies requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetPendingSharedAgencies requestExtendedUpdatedTimeField() {
            return this.requestExtendedUpdatedTimeField(true);
        }

        public APIRequestGetPendingSharedAgencies requestExtendedUpdatedTimeField(boolean value) {
            this.requestField("extended_updated_time", value);
            return this;
        }

        public APIRequestGetPendingSharedAgencies requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetPendingSharedAgencies requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetPendingSharedAgencies requestIsHiddenField() {
            return this.requestIsHiddenField(true);
        }

        public APIRequestGetPendingSharedAgencies requestIsHiddenField(boolean value) {
            this.requestField("is_hidden", value);
            return this;
        }

        public APIRequestGetPendingSharedAgencies requestIsInstagramEnabledInFbAnalyticsField() {
            return this.requestIsInstagramEnabledInFbAnalyticsField(true);
        }

        public APIRequestGetPendingSharedAgencies requestIsInstagramEnabledInFbAnalyticsField(boolean value) {
            this.requestField("is_instagram_enabled_in_fb_analytics", value);
            return this;
        }

        public APIRequestGetPendingSharedAgencies requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetPendingSharedAgencies requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetPendingSharedAgencies requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetPendingSharedAgencies requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetPendingSharedAgencies requestPrimaryPageField() {
            return this.requestPrimaryPageField(true);
        }

        public APIRequestGetPendingSharedAgencies requestPrimaryPageField(boolean value) {
            this.requestField("primary_page", value);
            return this;
        }

        public APIRequestGetPendingSharedAgencies requestProfilePictureUriField() {
            return this.requestProfilePictureUriField(true);
        }

        public APIRequestGetPendingSharedAgencies requestProfilePictureUriField(boolean value) {
            this.requestField("profile_picture_uri", value);
            return this;
        }

        public APIRequestGetPendingSharedAgencies requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGetPendingSharedAgencies requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }

        public APIRequestGetPendingSharedAgencies requestTwoFactorTypeField() {
            return this.requestTwoFactorTypeField(true);
        }

        public APIRequestGetPendingSharedAgencies requestTwoFactorTypeField(boolean value) {
            this.requestField("two_factor_type", value);
            return this;
        }

        public APIRequestGetPendingSharedAgencies requestUpdatedByField() {
            return this.requestUpdatedByField(true);
        }

        public APIRequestGetPendingSharedAgencies requestUpdatedByField(boolean value) {
            this.requestField("updated_by", value);
            return this;
        }

        public APIRequestGetPendingSharedAgencies requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetPendingSharedAgencies requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetPendingSharedAgencies requestVerificationStatusField() {
            return this.requestVerificationStatusField(true);
        }

        public APIRequestGetPendingSharedAgencies requestVerificationStatusField(boolean value) {
            this.requestField("verification_status", value);
            return this;
        }

        public APIRequestGetPendingSharedAgencies requestVerticalField() {
            return this.requestVerticalField(true);
        }

        public APIRequestGetPendingSharedAgencies requestVerticalField(boolean value) {
            this.requestField("vertical", value);
            return this;
        }

        public APIRequestGetPendingSharedAgencies requestVerticalIdField() {
            return this.requestVerticalIdField(true);
        }

        public APIRequestGetPendingSharedAgencies requestVerticalIdField(boolean value) {
            this.requestField("vertical_id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetDaChecks
    extends APIRequest<DACheck> {
        APINodeList<DACheck> lastResponse = null;
        public static final String[] PARAMS = new String[]{"checks"};
        public static final String[] FIELDS = new String[]{"action_uri", "description", "key", "result", "title", "user_message", "id"};

        @Override
        public APINodeList<DACheck> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<DACheck> parseResponse(String response, String header) throws APIException {
            return DACheck.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<DACheck> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<DACheck> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<DACheck>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<DACheck>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<DACheck>>(){

                public APINodeList<DACheck> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetDaChecks.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetDaChecks(String nodeId, APIContext context) {
            super(context, nodeId, "/da_checks", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetDaChecks setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetDaChecks setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetDaChecks setChecks(List<String> checks) {
            this.setParam("checks", checks);
            return this;
        }

        public APIRequestGetDaChecks setChecks(String checks) {
            this.setParam("checks", checks);
            return this;
        }

        public APIRequestGetDaChecks requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetDaChecks requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetDaChecks requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetDaChecks requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetDaChecks requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetDaChecks requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetDaChecks requestActionUriField() {
            return this.requestActionUriField(true);
        }

        public APIRequestGetDaChecks requestActionUriField(boolean value) {
            this.requestField("action_uri", value);
            return this;
        }

        public APIRequestGetDaChecks requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetDaChecks requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetDaChecks requestKeyField() {
            return this.requestKeyField(true);
        }

        public APIRequestGetDaChecks requestKeyField(boolean value) {
            this.requestField("key", value);
            return this;
        }

        public APIRequestGetDaChecks requestResultField() {
            return this.requestResultField(true);
        }

        public APIRequestGetDaChecks requestResultField(boolean value) {
            this.requestField("result", value);
            return this;
        }

        public APIRequestGetDaChecks requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGetDaChecks requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGetDaChecks requestUserMessageField() {
            return this.requestUserMessageField(true);
        }

        public APIRequestGetDaChecks requestUserMessageField(boolean value) {
            this.requestField("user_message", value);
            return this;
        }

        public APIRequestGetDaChecks requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetDaChecks requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateCreateServerToServerKey
    extends APIRequest<AdsPixel> {
        AdsPixel lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public AdsPixel getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdsPixel parseResponse(String response, String header) throws APIException {
            return AdsPixel.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdsPixel execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdsPixel execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdsPixel> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdsPixel> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdsPixel>(){

                public AdsPixel apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateCreateServerToServerKey.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateCreateServerToServerKey(String nodeId, APIContext context) {
            super(context, nodeId, "/create_server_to_server_keys", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateCreateServerToServerKey setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateCreateServerToServerKey setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateCreateServerToServerKey requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateCreateServerToServerKey requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateCreateServerToServerKey requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateCreateServerToServerKey requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateCreateServerToServerKey requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateCreateServerToServerKey requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAudiences
    extends APIRequest<CustomAudience> {
        APINodeList<CustomAudience> lastResponse = null;
        public static final String[] PARAMS = new String[]{"ad_account"};
        public static final String[] FIELDS = new String[]{"account_id", "approximate_count", "customer_file_source", "data_source", "data_source_types", "datafile_custom_audience_uploading_status", "delivery_status", "description", "excluded_custom_audiences", "expiry_time", "external_event_source", "household_audience", "id", "included_custom_audiences", "is_household", "is_snapshot", "is_value_based", "list_of_accounts", "lookalike_audience_ids", "lookalike_spec", "name", "operation_status", "opt_out_link", "permission_for_actions", "pixel_id", "retention_days", "rev_share_policy_id", "rule", "rule_aggregation", "rule_v2", "seed_audience", "sharing_status", "study_spec", "subtype", "time_content_updated", "time_created", "time_updated"};

        @Override
        public APINodeList<CustomAudience> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<CustomAudience> parseResponse(String response, String header) throws APIException {
            return CustomAudience.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<CustomAudience> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<CustomAudience> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<CustomAudience>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<CustomAudience>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<CustomAudience>>(){

                public APINodeList<CustomAudience> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetAudiences.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAudiences(String nodeId, APIContext context) {
            super(context, nodeId, "/audiences", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAudiences setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAudiences setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAudiences setAdAccount(String adAccount) {
            this.setParam("ad_account", adAccount);
            return this;
        }

        public APIRequestGetAudiences requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAudiences requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAudiences requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAudiences requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAudiences requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAudiences requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAudiences requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetAudiences requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetAudiences requestApproximateCountField() {
            return this.requestApproximateCountField(true);
        }

        public APIRequestGetAudiences requestApproximateCountField(boolean value) {
            this.requestField("approximate_count", value);
            return this;
        }

        public APIRequestGetAudiences requestCustomerFileSourceField() {
            return this.requestCustomerFileSourceField(true);
        }

        public APIRequestGetAudiences requestCustomerFileSourceField(boolean value) {
            this.requestField("customer_file_source", value);
            return this;
        }

        public APIRequestGetAudiences requestDataSourceField() {
            return this.requestDataSourceField(true);
        }

        public APIRequestGetAudiences requestDataSourceField(boolean value) {
            this.requestField("data_source", value);
            return this;
        }

        public APIRequestGetAudiences requestDataSourceTypesField() {
            return this.requestDataSourceTypesField(true);
        }

        public APIRequestGetAudiences requestDataSourceTypesField(boolean value) {
            this.requestField("data_source_types", value);
            return this;
        }

        public APIRequestGetAudiences requestDatafileCustomAudienceUploadingStatusField() {
            return this.requestDatafileCustomAudienceUploadingStatusField(true);
        }

        public APIRequestGetAudiences requestDatafileCustomAudienceUploadingStatusField(boolean value) {
            this.requestField("datafile_custom_audience_uploading_status", value);
            return this;
        }

        public APIRequestGetAudiences requestDeliveryStatusField() {
            return this.requestDeliveryStatusField(true);
        }

        public APIRequestGetAudiences requestDeliveryStatusField(boolean value) {
            this.requestField("delivery_status", value);
            return this;
        }

        public APIRequestGetAudiences requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetAudiences requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetAudiences requestExcludedCustomAudiencesField() {
            return this.requestExcludedCustomAudiencesField(true);
        }

        public APIRequestGetAudiences requestExcludedCustomAudiencesField(boolean value) {
            this.requestField("excluded_custom_audiences", value);
            return this;
        }

        public APIRequestGetAudiences requestExpiryTimeField() {
            return this.requestExpiryTimeField(true);
        }

        public APIRequestGetAudiences requestExpiryTimeField(boolean value) {
            this.requestField("expiry_time", value);
            return this;
        }

        public APIRequestGetAudiences requestExternalEventSourceField() {
            return this.requestExternalEventSourceField(true);
        }

        public APIRequestGetAudiences requestExternalEventSourceField(boolean value) {
            this.requestField("external_event_source", value);
            return this;
        }

        public APIRequestGetAudiences requestHouseholdAudienceField() {
            return this.requestHouseholdAudienceField(true);
        }

        public APIRequestGetAudiences requestHouseholdAudienceField(boolean value) {
            this.requestField("household_audience", value);
            return this;
        }

        public APIRequestGetAudiences requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAudiences requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAudiences requestIncludedCustomAudiencesField() {
            return this.requestIncludedCustomAudiencesField(true);
        }

        public APIRequestGetAudiences requestIncludedCustomAudiencesField(boolean value) {
            this.requestField("included_custom_audiences", value);
            return this;
        }

        public APIRequestGetAudiences requestIsHouseholdField() {
            return this.requestIsHouseholdField(true);
        }

        public APIRequestGetAudiences requestIsHouseholdField(boolean value) {
            this.requestField("is_household", value);
            return this;
        }

        public APIRequestGetAudiences requestIsSnapshotField() {
            return this.requestIsSnapshotField(true);
        }

        public APIRequestGetAudiences requestIsSnapshotField(boolean value) {
            this.requestField("is_snapshot", value);
            return this;
        }

        public APIRequestGetAudiences requestIsValueBasedField() {
            return this.requestIsValueBasedField(true);
        }

        public APIRequestGetAudiences requestIsValueBasedField(boolean value) {
            this.requestField("is_value_based", value);
            return this;
        }

        public APIRequestGetAudiences requestListOfAccountsField() {
            return this.requestListOfAccountsField(true);
        }

        public APIRequestGetAudiences requestListOfAccountsField(boolean value) {
            this.requestField("list_of_accounts", value);
            return this;
        }

        public APIRequestGetAudiences requestLookalikeAudienceIdsField() {
            return this.requestLookalikeAudienceIdsField(true);
        }

        public APIRequestGetAudiences requestLookalikeAudienceIdsField(boolean value) {
            this.requestField("lookalike_audience_ids", value);
            return this;
        }

        public APIRequestGetAudiences requestLookalikeSpecField() {
            return this.requestLookalikeSpecField(true);
        }

        public APIRequestGetAudiences requestLookalikeSpecField(boolean value) {
            this.requestField("lookalike_spec", value);
            return this;
        }

        public APIRequestGetAudiences requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAudiences requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAudiences requestOperationStatusField() {
            return this.requestOperationStatusField(true);
        }

        public APIRequestGetAudiences requestOperationStatusField(boolean value) {
            this.requestField("operation_status", value);
            return this;
        }

        public APIRequestGetAudiences requestOptOutLinkField() {
            return this.requestOptOutLinkField(true);
        }

        public APIRequestGetAudiences requestOptOutLinkField(boolean value) {
            this.requestField("opt_out_link", value);
            return this;
        }

        public APIRequestGetAudiences requestPermissionForActionsField() {
            return this.requestPermissionForActionsField(true);
        }

        public APIRequestGetAudiences requestPermissionForActionsField(boolean value) {
            this.requestField("permission_for_actions", value);
            return this;
        }

        public APIRequestGetAudiences requestPixelIdField() {
            return this.requestPixelIdField(true);
        }

        public APIRequestGetAudiences requestPixelIdField(boolean value) {
            this.requestField("pixel_id", value);
            return this;
        }

        public APIRequestGetAudiences requestRetentionDaysField() {
            return this.requestRetentionDaysField(true);
        }

        public APIRequestGetAudiences requestRetentionDaysField(boolean value) {
            this.requestField("retention_days", value);
            return this;
        }

        public APIRequestGetAudiences requestRevSharePolicyIdField() {
            return this.requestRevSharePolicyIdField(true);
        }

        public APIRequestGetAudiences requestRevSharePolicyIdField(boolean value) {
            this.requestField("rev_share_policy_id", value);
            return this;
        }

        public APIRequestGetAudiences requestRuleField() {
            return this.requestRuleField(true);
        }

        public APIRequestGetAudiences requestRuleField(boolean value) {
            this.requestField("rule", value);
            return this;
        }

        public APIRequestGetAudiences requestRuleAggregationField() {
            return this.requestRuleAggregationField(true);
        }

        public APIRequestGetAudiences requestRuleAggregationField(boolean value) {
            this.requestField("rule_aggregation", value);
            return this;
        }

        public APIRequestGetAudiences requestRuleV2Field() {
            return this.requestRuleV2Field(true);
        }

        public APIRequestGetAudiences requestRuleV2Field(boolean value) {
            this.requestField("rule_v2", value);
            return this;
        }

        public APIRequestGetAudiences requestSeedAudienceField() {
            return this.requestSeedAudienceField(true);
        }

        public APIRequestGetAudiences requestSeedAudienceField(boolean value) {
            this.requestField("seed_audience", value);
            return this;
        }

        public APIRequestGetAudiences requestSharingStatusField() {
            return this.requestSharingStatusField(true);
        }

        public APIRequestGetAudiences requestSharingStatusField(boolean value) {
            this.requestField("sharing_status", value);
            return this;
        }

        public APIRequestGetAudiences requestStudySpecField() {
            return this.requestStudySpecField(true);
        }

        public APIRequestGetAudiences requestStudySpecField(boolean value) {
            this.requestField("study_spec", value);
            return this;
        }

        public APIRequestGetAudiences requestSubtypeField() {
            return this.requestSubtypeField(true);
        }

        public APIRequestGetAudiences requestSubtypeField(boolean value) {
            this.requestField("subtype", value);
            return this;
        }

        public APIRequestGetAudiences requestTimeContentUpdatedField() {
            return this.requestTimeContentUpdatedField(true);
        }

        public APIRequestGetAudiences requestTimeContentUpdatedField(boolean value) {
            this.requestField("time_content_updated", value);
            return this;
        }

        public APIRequestGetAudiences requestTimeCreatedField() {
            return this.requestTimeCreatedField(true);
        }

        public APIRequestGetAudiences requestTimeCreatedField(boolean value) {
            this.requestField("time_created", value);
            return this;
        }

        public APIRequestGetAudiences requestTimeUpdatedField() {
            return this.requestTimeUpdatedField(true);
        }

        public APIRequestGetAudiences requestTimeUpdatedField(boolean value) {
            this.requestField("time_updated", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateAssignedUser
    extends APIRequest<AdsPixel> {
        AdsPixel lastResponse = null;
        public static final String[] PARAMS = new String[]{"user", "tasks", "business"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdsPixel getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdsPixel parseResponse(String response, String header) throws APIException {
            return AdsPixel.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdsPixel execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdsPixel execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdsPixel> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdsPixel> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdsPixel>(){

                public AdsPixel apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateAssignedUser.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateAssignedUser(String nodeId, APIContext context) {
            super(context, nodeId, "/assigned_users", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAssignedUser setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAssignedUser setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAssignedUser setUser(Long user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestCreateAssignedUser setUser(String user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestCreateAssignedUser setTasks(List<EnumTasks> tasks) {
            this.setParam("tasks", tasks);
            return this;
        }

        public APIRequestCreateAssignedUser setTasks(String tasks) {
            this.setParam("tasks", tasks);
            return this;
        }

        public APIRequestCreateAssignedUser setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestCreateAssignedUser requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAssignedUser requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAssignedUser requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAssignedUser requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAssignedUser requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAssignedUser requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAssignedUsers
    extends APIRequest<AssignedUser> {
        APINodeList<AssignedUser> lastResponse = null;
        public static final String[] PARAMS = new String[]{"business"};
        public static final String[] FIELDS = new String[]{"business", "id", "name", "user_type"};

        @Override
        public APINodeList<AssignedUser> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AssignedUser> parseResponse(String response, String header) throws APIException {
            return AssignedUser.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AssignedUser> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AssignedUser> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AssignedUser>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AssignedUser>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AssignedUser>>(){

                public APINodeList<AssignedUser> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetAssignedUsers.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAssignedUsers(String nodeId, APIContext context) {
            super(context, nodeId, "/assigned_users", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAssignedUsers setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAssignedUsers setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAssignedUsers setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestGetAssignedUsers requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAssignedUsers requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAssignedUsers requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAssignedUsers requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAssignedUsers requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAssignedUsers requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAssignedUsers requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetAssignedUsers requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetAssignedUsers requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAssignedUsers requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAssignedUsers requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAssignedUsers requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAssignedUsers requestUserTypeField() {
            return this.requestUserTypeField(true);
        }

        public APIRequestGetAssignedUsers requestUserTypeField(boolean value) {
            this.requestField("user_type", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteAssignedUsers
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"user", "business"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestDeleteAssignedUsers.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteAssignedUsers(String nodeId, APIContext context) {
            super(context, nodeId, "/assigned_users", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteAssignedUsers setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteAssignedUsers setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteAssignedUsers setUser(Long user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestDeleteAssignedUsers setUser(String user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestDeleteAssignedUsers setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestDeleteAssignedUsers requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteAssignedUsers requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteAssignedUsers requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteAssignedUsers requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteAssignedUsers requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteAssignedUsers requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

