/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FoodDrinkOrder
extends APINode {
    @SerializedName(value="admin_note")
    private String mAdminNote = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="customer_name")
    private String mCustomerName = null;
    @SerializedName(value="customer_phone_number")
    private String mCustomerPhoneNumber = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="note")
    private String mNote = null;
    @SerializedName(value="order_details")
    private List<Object> mOrderDetails = null;
    @SerializedName(value="state")
    private String mState = null;
    @SerializedName(value="update_time")
    private String mUpdateTime = null;
    protected static Gson gson = null;

    FoodDrinkOrder() {
    }

    public FoodDrinkOrder(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public FoodDrinkOrder(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public FoodDrinkOrder fetch() throws APIException {
        FoodDrinkOrder newInstance = FoodDrinkOrder.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static FoodDrinkOrder fetchById(Long id, APIContext context) throws APIException {
        return FoodDrinkOrder.fetchById(id.toString(), context);
    }

    public static ListenableFuture<FoodDrinkOrder> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return FoodDrinkOrder.fetchByIdAsync(id.toString(), context);
    }

    public static FoodDrinkOrder fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<FoodDrinkOrder> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<FoodDrinkOrder> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<FoodDrinkOrder>(context, "", "/", "GET", FoodDrinkOrder.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<FoodDrinkOrder>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<FoodDrinkOrder>(context, "", "/", "GET", FoodDrinkOrder.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static FoodDrinkOrder loadJSON(String json, APIContext context, String header) {
        FoodDrinkOrder foodDrinkOrder = (FoodDrinkOrder)FoodDrinkOrder.getGson().fromJson(json, FoodDrinkOrder.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(foodDrinkOrder.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        foodDrinkOrder.context = context;
        foodDrinkOrder.rawValue = json;
        foodDrinkOrder.header = header;
        return foodDrinkOrder;
    }

    public static APINodeList<FoodDrinkOrder> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<FoodDrinkOrder> foodDrinkOrders = new APINodeList<FoodDrinkOrder>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        foodDrinkOrders.add(FoodDrinkOrder.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return foodDrinkOrders;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            foodDrinkOrders.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        foodDrinkOrders.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            foodDrinkOrders.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            foodDrinkOrders.add(FoodDrinkOrder.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                foodDrinkOrders.add(FoodDrinkOrder.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            foodDrinkOrders.add(FoodDrinkOrder.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return foodDrinkOrders;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        foodDrinkOrders.add(FoodDrinkOrder.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return foodDrinkOrders;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        foodDrinkOrders.add(FoodDrinkOrder.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return foodDrinkOrders;
                }
                foodDrinkOrders.clear();
                foodDrinkOrders.add(FoodDrinkOrder.loadJSON(json, context, header));
                return foodDrinkOrders;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return FoodDrinkOrder.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAdminNote() {
        return this.mAdminNote;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public String getFieldCustomerName() {
        return this.mCustomerName;
    }

    public String getFieldCustomerPhoneNumber() {
        return this.mCustomerPhoneNumber;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldNote() {
        return this.mNote;
    }

    public List<Object> getFieldOrderDetails() {
        return this.mOrderDetails;
    }

    public String getFieldState() {
        return this.mState;
    }

    public String getFieldUpdateTime() {
        return this.mUpdateTime;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public FoodDrinkOrder copyFrom(FoodDrinkOrder instance) {
        this.mAdminNote = instance.mAdminNote;
        this.mCreationTime = instance.mCreationTime;
        this.mCustomerName = instance.mCustomerName;
        this.mCustomerPhoneNumber = instance.mCustomerPhoneNumber;
        this.mId = instance.mId;
        this.mNote = instance.mNote;
        this.mOrderDetails = instance.mOrderDetails;
        this.mState = instance.mState;
        this.mUpdateTime = instance.mUpdateTime;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<FoodDrinkOrder> getParser() {
        return new APIRequest.ResponseParser<FoodDrinkOrder>(){

            @Override
            public APINodeList<FoodDrinkOrder> parseResponse(String response, APIContext context, APIRequest<FoodDrinkOrder> request, String header) throws APIException.MalformedResponseException {
                return FoodDrinkOrder.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumState {
        VALUE_CANCELLED("CANCELLED"),
        VALUE_CONFIRMED("CONFIRMED"),
        VALUE_DRAFT("DRAFT"),
        VALUE_EXPIRED("EXPIRED"),
        VALUE_ON_DELIVERY("ON_DELIVERY"),
        VALUE_PENDING("PENDING"),
        VALUE_READY_FOR_PICKUP("READY_FOR_PICKUP"),
        VALUE_SERVING("SERVING"),
        NULL(null);

        private String value;

        private EnumState(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<FoodDrinkOrder> {
        FoodDrinkOrder lastResponse = null;
        public static final String[] PARAMS = new String[]{"state"};
        public static final String[] FIELDS = new String[0];

        @Override
        public FoodDrinkOrder getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public FoodDrinkOrder parseResponse(String response, String header) throws APIException {
            return FoodDrinkOrder.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public FoodDrinkOrder execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public FoodDrinkOrder execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<FoodDrinkOrder> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<FoodDrinkOrder> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, FoodDrinkOrder>(){

                public FoodDrinkOrder apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setState(EnumState state) {
            this.setParam("state", (Object)state);
            return this;
        }

        public APIRequestUpdate setState(String state) {
            this.setParam("state", state);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<FoodDrinkOrder> {
        FoodDrinkOrder lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"admin_note", "creation_time", "customer_name", "customer_phone_number", "id", "note", "order_details", "state", "update_time"};

        @Override
        public FoodDrinkOrder getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public FoodDrinkOrder parseResponse(String response, String header) throws APIException {
            return FoodDrinkOrder.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public FoodDrinkOrder execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public FoodDrinkOrder execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<FoodDrinkOrder> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<FoodDrinkOrder> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, FoodDrinkOrder>(){

                public FoodDrinkOrder apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdminNoteField() {
            return this.requestAdminNoteField(true);
        }

        public APIRequestGet requestAdminNoteField(boolean value) {
            this.requestField("admin_note", value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestCustomerNameField() {
            return this.requestCustomerNameField(true);
        }

        public APIRequestGet requestCustomerNameField(boolean value) {
            this.requestField("customer_name", value);
            return this;
        }

        public APIRequestGet requestCustomerPhoneNumberField() {
            return this.requestCustomerPhoneNumberField(true);
        }

        public APIRequestGet requestCustomerPhoneNumberField(boolean value) {
            this.requestField("customer_phone_number", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestNoteField() {
            return this.requestNoteField(true);
        }

        public APIRequestGet requestNoteField(boolean value) {
            this.requestField("note", value);
            return this;
        }

        public APIRequestGet requestOrderDetailsField() {
            return this.requestOrderDetailsField(true);
        }

        public APIRequestGet requestOrderDetailsField(boolean value) {
            this.requestField("order_details", value);
            return this;
        }

        public APIRequestGet requestStateField() {
            return this.requestStateField(true);
        }

        public APIRequestGet requestStateField(boolean value) {
            this.requestField("state", value);
            return this;
        }

        public APIRequestGet requestUpdateTimeField() {
            return this.requestUpdateTimeField(true);
        }

        public APIRequestGet requestUpdateTimeField(boolean value) {
            this.requestField("update_time", value);
            return this;
        }
    }
}

