/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Page;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkExperience
extends APINode {
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="employer")
    private Page mEmployer = null;
    @SerializedName(value="end_date")
    private String mEndDate = null;
    @SerializedName(value="from")
    private User mFrom = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="location")
    private Page mLocation = null;
    @SerializedName(value="position")
    private Page mPosition = null;
    @SerializedName(value="projects")
    private List<Object> mProjects = null;
    @SerializedName(value="start_date")
    private String mStartDate = null;
    @SerializedName(value="with")
    private List<User> mWith = null;
    protected static Gson gson = null;

    WorkExperience() {
    }

    public WorkExperience(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public WorkExperience(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public WorkExperience fetch() throws APIException {
        WorkExperience newInstance = WorkExperience.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static WorkExperience fetchById(Long id, APIContext context) throws APIException {
        return WorkExperience.fetchById(id.toString(), context);
    }

    public static ListenableFuture<WorkExperience> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return WorkExperience.fetchByIdAsync(id.toString(), context);
    }

    public static WorkExperience fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<WorkExperience> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<WorkExperience> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<WorkExperience>(context, "", "/", "GET", WorkExperience.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<WorkExperience>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<WorkExperience>(context, "", "/", "GET", WorkExperience.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static WorkExperience loadJSON(String json, APIContext context, String header) {
        WorkExperience workExperience = (WorkExperience)WorkExperience.getGson().fromJson(json, WorkExperience.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(workExperience.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        workExperience.context = context;
        workExperience.rawValue = json;
        workExperience.header = header;
        return workExperience;
    }

    public static APINodeList<WorkExperience> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<WorkExperience> workExperiences = new APINodeList<WorkExperience>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        workExperiences.add(WorkExperience.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return workExperiences;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            workExperiences.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        workExperiences.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            workExperiences.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            workExperiences.add(WorkExperience.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                workExperiences.add(WorkExperience.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            workExperiences.add(WorkExperience.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return workExperiences;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        workExperiences.add(WorkExperience.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return workExperiences;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        workExperiences.add(WorkExperience.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return workExperiences;
                }
                workExperiences.clear();
                workExperiences.add(WorkExperience.loadJSON(json, context, header));
                return workExperiences;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return WorkExperience.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public Page getFieldEmployer() {
        if (this.mEmployer != null) {
            this.mEmployer.context = this.getContext();
        }
        return this.mEmployer;
    }

    public String getFieldEndDate() {
        return this.mEndDate;
    }

    public User getFieldFrom() {
        if (this.mFrom != null) {
            this.mFrom.context = this.getContext();
        }
        return this.mFrom;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Page getFieldLocation() {
        if (this.mLocation != null) {
            this.mLocation.context = this.getContext();
        }
        return this.mLocation;
    }

    public Page getFieldPosition() {
        if (this.mPosition != null) {
            this.mPosition.context = this.getContext();
        }
        return this.mPosition;
    }

    public List<Object> getFieldProjects() {
        return this.mProjects;
    }

    public String getFieldStartDate() {
        return this.mStartDate;
    }

    public List<User> getFieldWith() {
        return this.mWith;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public WorkExperience copyFrom(WorkExperience instance) {
        this.mDescription = instance.mDescription;
        this.mEmployer = instance.mEmployer;
        this.mEndDate = instance.mEndDate;
        this.mFrom = instance.mFrom;
        this.mId = instance.mId;
        this.mLocation = instance.mLocation;
        this.mPosition = instance.mPosition;
        this.mProjects = instance.mProjects;
        this.mStartDate = instance.mStartDate;
        this.mWith = instance.mWith;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<WorkExperience> getParser() {
        return new APIRequest.ResponseParser<WorkExperience>(){

            @Override
            public APINodeList<WorkExperience> parseResponse(String response, APIContext context, APIRequest<WorkExperience> request, String header) throws APIException.MalformedResponseException {
                return WorkExperience.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<WorkExperience> {
        WorkExperience lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"description", "employer", "end_date", "from", "id", "location", "position", "projects", "start_date", "with"};

        @Override
        public WorkExperience getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public WorkExperience parseResponse(String response, String header) throws APIException {
            return WorkExperience.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public WorkExperience execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public WorkExperience execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<WorkExperience> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<WorkExperience> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, WorkExperience>(){

                public WorkExperience apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestEmployerField() {
            return this.requestEmployerField(true);
        }

        public APIRequestGet requestEmployerField(boolean value) {
            this.requestField("employer", value);
            return this;
        }

        public APIRequestGet requestEndDateField() {
            return this.requestEndDateField(true);
        }

        public APIRequestGet requestEndDateField(boolean value) {
            this.requestField("end_date", value);
            return this;
        }

        public APIRequestGet requestFromField() {
            return this.requestFromField(true);
        }

        public APIRequestGet requestFromField(boolean value) {
            this.requestField("from", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGet requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGet requestPositionField() {
            return this.requestPositionField(true);
        }

        public APIRequestGet requestPositionField(boolean value) {
            this.requestField("position", value);
            return this;
        }

        public APIRequestGet requestProjectsField() {
            return this.requestProjectsField(true);
        }

        public APIRequestGet requestProjectsField(boolean value) {
            this.requestField("projects", value);
            return this;
        }

        public APIRequestGet requestStartDateField() {
            return this.requestStartDateField(true);
        }

        public APIRequestGet requestStartDateField(boolean value) {
            this.requestField("start_date", value);
            return this;
        }

        public APIRequestGet requestWithField() {
            return this.requestWithField(true);
        }

        public APIRequestGet requestWithField(boolean value) {
            this.requestField("with", value);
            return this;
        }
    }
}

