/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserInfluence
extends APINode {
    @SerializedName(value="trust")
    private String mTrust = null;
    @SerializedName(value="trust_code")
    private Long mTrustCode = null;
    @SerializedName(value="version")
    private Long mVersion = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static UserInfluence loadJSON(String json, APIContext context, String header) {
        UserInfluence userInfluence = (UserInfluence)UserInfluence.getGson().fromJson(json, UserInfluence.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(userInfluence.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        userInfluence.context = context;
        userInfluence.rawValue = json;
        userInfluence.header = header;
        return userInfluence;
    }

    public static APINodeList<UserInfluence> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<UserInfluence> userInfluences = new APINodeList<UserInfluence>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        userInfluences.add(UserInfluence.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return userInfluences;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            userInfluences.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        userInfluences.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            userInfluences.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            userInfluences.add(UserInfluence.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                userInfluences.add(UserInfluence.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            userInfluences.add(UserInfluence.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return userInfluences;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        userInfluences.add(UserInfluence.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return userInfluences;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        userInfluences.add(UserInfluence.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return userInfluences;
                }
                userInfluences.clear();
                userInfluences.add(UserInfluence.loadJSON(json, context, header));
                return userInfluences;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return UserInfluence.getGson().toJson((Object)this);
    }

    public String getFieldTrust() {
        return this.mTrust;
    }

    public UserInfluence setFieldTrust(String value) {
        this.mTrust = value;
        return this;
    }

    public Long getFieldTrustCode() {
        return this.mTrustCode;
    }

    public UserInfluence setFieldTrustCode(Long value) {
        this.mTrustCode = value;
        return this;
    }

    public Long getFieldVersion() {
        return this.mVersion;
    }

    public UserInfluence setFieldVersion(Long value) {
        this.mVersion = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public UserInfluence setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public UserInfluence copyFrom(UserInfluence instance) {
        this.mTrust = instance.mTrust;
        this.mTrustCode = instance.mTrustCode;
        this.mVersion = instance.mVersion;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<UserInfluence> getParser() {
        return new APIRequest.ResponseParser<UserInfluence>(){

            @Override
            public APINodeList<UserInfluence> parseResponse(String response, APIContext context, APIRequest<UserInfluence> request, String header) throws APIException.MalformedResponseException {
                return UserInfluence.parseResponse(response, context, request, header);
            }
        };
    }
}

