/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.PageUpcomingChange;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageChangeProposal
extends APINode {
    @SerializedName(value="acceptance_status")
    private String mAcceptanceStatus = null;
    @SerializedName(value="category")
    private String mCategory = null;
    @SerializedName(value="current_value")
    private String mCurrentValue = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="proposed_value")
    private String mProposedValue = null;
    @SerializedName(value="upcoming_change_info")
    private PageUpcomingChange mUpcomingChangeInfo = null;
    protected static Gson gson = null;

    PageChangeProposal() {
    }

    public PageChangeProposal(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public PageChangeProposal(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public PageChangeProposal fetch() throws APIException {
        PageChangeProposal newInstance = PageChangeProposal.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static PageChangeProposal fetchById(Long id, APIContext context) throws APIException {
        return PageChangeProposal.fetchById(id.toString(), context);
    }

    public static ListenableFuture<PageChangeProposal> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return PageChangeProposal.fetchByIdAsync(id.toString(), context);
    }

    public static PageChangeProposal fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<PageChangeProposal> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<PageChangeProposal> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<PageChangeProposal>(context, "", "/", "GET", PageChangeProposal.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<PageChangeProposal>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<PageChangeProposal>(context, "", "/", "GET", PageChangeProposal.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PageChangeProposal loadJSON(String json, APIContext context, String header) {
        PageChangeProposal pageChangeProposal = (PageChangeProposal)PageChangeProposal.getGson().fromJson(json, PageChangeProposal.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(pageChangeProposal.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        pageChangeProposal.context = context;
        pageChangeProposal.rawValue = json;
        pageChangeProposal.header = header;
        return pageChangeProposal;
    }

    public static APINodeList<PageChangeProposal> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PageChangeProposal> pageChangeProposals = new APINodeList<PageChangeProposal>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        pageChangeProposals.add(PageChangeProposal.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return pageChangeProposals;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            pageChangeProposals.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        pageChangeProposals.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            pageChangeProposals.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            pageChangeProposals.add(PageChangeProposal.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                pageChangeProposals.add(PageChangeProposal.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            pageChangeProposals.add(PageChangeProposal.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return pageChangeProposals;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        pageChangeProposals.add(PageChangeProposal.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return pageChangeProposals;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        pageChangeProposals.add(PageChangeProposal.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return pageChangeProposals;
                }
                pageChangeProposals.clear();
                pageChangeProposals.add(PageChangeProposal.loadJSON(json, context, header));
                return pageChangeProposals;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PageChangeProposal.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAcceptanceStatus() {
        return this.mAcceptanceStatus;
    }

    public String getFieldCategory() {
        return this.mCategory;
    }

    public String getFieldCurrentValue() {
        return this.mCurrentValue;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldProposedValue() {
        return this.mProposedValue;
    }

    public PageUpcomingChange getFieldUpcomingChangeInfo() {
        if (this.mUpcomingChangeInfo != null) {
            this.mUpcomingChangeInfo.context = this.getContext();
        }
        return this.mUpcomingChangeInfo;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PageChangeProposal copyFrom(PageChangeProposal instance) {
        this.mAcceptanceStatus = instance.mAcceptanceStatus;
        this.mCategory = instance.mCategory;
        this.mCurrentValue = instance.mCurrentValue;
        this.mId = instance.mId;
        this.mProposedValue = instance.mProposedValue;
        this.mUpcomingChangeInfo = instance.mUpcomingChangeInfo;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PageChangeProposal> getParser() {
        return new APIRequest.ResponseParser<PageChangeProposal>(){

            @Override
            public APINodeList<PageChangeProposal> parseResponse(String response, APIContext context, APIRequest<PageChangeProposal> request, String header) throws APIException.MalformedResponseException {
                return PageChangeProposal.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<PageChangeProposal> {
        PageChangeProposal lastResponse = null;
        public static final String[] PARAMS = new String[]{"accept"};
        public static final String[] FIELDS = new String[0];

        @Override
        public PageChangeProposal getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PageChangeProposal parseResponse(String response, String header) throws APIException {
            return PageChangeProposal.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public PageChangeProposal execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PageChangeProposal execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<PageChangeProposal> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PageChangeProposal> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, PageChangeProposal>(){

                public PageChangeProposal apply(String result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setAccept(Boolean accept) {
            this.setParam("accept", accept);
            return this;
        }

        public APIRequestUpdate setAccept(String accept) {
            this.setParam("accept", accept);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<PageChangeProposal> {
        PageChangeProposal lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"acceptance_status", "category", "current_value", "id", "proposed_value", "upcoming_change_info"};

        @Override
        public PageChangeProposal getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PageChangeProposal parseResponse(String response, String header) throws APIException {
            return PageChangeProposal.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public PageChangeProposal execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PageChangeProposal execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<PageChangeProposal> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PageChangeProposal> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, PageChangeProposal>(){

                public PageChangeProposal apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAcceptanceStatusField() {
            return this.requestAcceptanceStatusField(true);
        }

        public APIRequestGet requestAcceptanceStatusField(boolean value) {
            this.requestField("acceptance_status", value);
            return this;
        }

        public APIRequestGet requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGet requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGet requestCurrentValueField() {
            return this.requestCurrentValueField(true);
        }

        public APIRequestGet requestCurrentValueField(boolean value) {
            this.requestField("current_value", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestProposedValueField() {
            return this.requestProposedValueField(true);
        }

        public APIRequestGet requestProposedValueField(boolean value) {
            this.requestField("proposed_value", value);
            return this;
        }

        public APIRequestGet requestUpcomingChangeInfoField() {
            return this.requestUpcomingChangeInfoField(true);
        }

        public APIRequestGet requestUpcomingChangeInfoField(boolean value) {
            this.requestField("upcoming_change_info", value);
            return this;
        }
    }
}

