/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Photo;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanvasCollectionThumbnail
extends APINode {
    @SerializedName(value="element_child_index")
    private Long mElementChildIndex = null;
    @SerializedName(value="element_id")
    private String mElementId = null;
    @SerializedName(value="photo")
    private Photo mPhoto = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CanvasCollectionThumbnail loadJSON(String json, APIContext context) {
        CanvasCollectionThumbnail canvasCollectionThumbnail = (CanvasCollectionThumbnail)CanvasCollectionThumbnail.getGson().fromJson(json, CanvasCollectionThumbnail.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(canvasCollectionThumbnail.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        canvasCollectionThumbnail.context = context;
        canvasCollectionThumbnail.rawValue = json;
        return canvasCollectionThumbnail;
    }

    public static APINodeList<CanvasCollectionThumbnail> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CanvasCollectionThumbnail> canvasCollectionThumbnails = new APINodeList<CanvasCollectionThumbnail>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        canvasCollectionThumbnails.add(CanvasCollectionThumbnail.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return canvasCollectionThumbnails;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            canvasCollectionThumbnails.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        canvasCollectionThumbnails.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            canvasCollectionThumbnails.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            canvasCollectionThumbnails.add(CanvasCollectionThumbnail.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                canvasCollectionThumbnails.add(CanvasCollectionThumbnail.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            canvasCollectionThumbnails.add(CanvasCollectionThumbnail.loadJSON(obj.toString(), context));
                        }
                    }
                    return canvasCollectionThumbnails;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        canvasCollectionThumbnails.add(CanvasCollectionThumbnail.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return canvasCollectionThumbnails;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        canvasCollectionThumbnails.add(CanvasCollectionThumbnail.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return canvasCollectionThumbnails;
                }
                canvasCollectionThumbnails.clear();
                canvasCollectionThumbnails.add(CanvasCollectionThumbnail.loadJSON(json, context));
                return canvasCollectionThumbnails;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CanvasCollectionThumbnail.getGson().toJson((Object)this);
    }

    public Long getFieldElementChildIndex() {
        return this.mElementChildIndex;
    }

    public CanvasCollectionThumbnail setFieldElementChildIndex(Long value) {
        this.mElementChildIndex = value;
        return this;
    }

    public String getFieldElementId() {
        return this.mElementId;
    }

    public CanvasCollectionThumbnail setFieldElementId(String value) {
        this.mElementId = value;
        return this;
    }

    public Photo getFieldPhoto() {
        if (this.mPhoto != null) {
            this.mPhoto.context = this.getContext();
        }
        return this.mPhoto;
    }

    public CanvasCollectionThumbnail setFieldPhoto(Photo value) {
        this.mPhoto = value;
        return this;
    }

    public CanvasCollectionThumbnail setFieldPhoto(String value) {
        Type type = new TypeToken<Photo>(){}.getType();
        this.mPhoto = (Photo)Photo.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public CanvasCollectionThumbnail setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CanvasCollectionThumbnail copyFrom(CanvasCollectionThumbnail instance) {
        this.mElementChildIndex = instance.mElementChildIndex;
        this.mElementId = instance.mElementId;
        this.mPhoto = instance.mPhoto;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CanvasCollectionThumbnail> getParser() {
        return new APIRequest.ResponseParser<CanvasCollectionThumbnail>(){

            @Override
            public APINodeList<CanvasCollectionThumbnail> parseResponse(String response, APIContext context, APIRequest<CanvasCollectionThumbnail> request) throws APIException.MalformedResponseException {
                return CanvasCollectionThumbnail.parseResponse(response, context, request);
            }
        };
    }
}

