/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdScriptExecutionHistory
extends APINode {
    @SerializedName(value="account_id")
    private String mAccountId = null;
    @SerializedName(value="changes")
    private List<Object> mChanges = null;
    @SerializedName(value="complete_time")
    private String mCompleteTime = null;
    @SerializedName(value="execution_status")
    private String mExecutionStatus = null;
    @SerializedName(value="execution_token")
    private String mExecutionToken = null;
    @SerializedName(value="logs")
    private Object mLogs = null;
    @SerializedName(value="script_id")
    private String mScriptId = null;
    @SerializedName(value="script_schedule_spec_id")
    private String mScriptScheduleSpecId = null;
    @SerializedName(value="start_time")
    private String mStartTime = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdScriptExecutionHistory loadJSON(String json, APIContext context) {
        AdScriptExecutionHistory adScriptExecutionHistory = (AdScriptExecutionHistory)AdScriptExecutionHistory.getGson().fromJson(json, AdScriptExecutionHistory.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adScriptExecutionHistory.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adScriptExecutionHistory.context = context;
        adScriptExecutionHistory.rawValue = json;
        return adScriptExecutionHistory;
    }

    public static APINodeList<AdScriptExecutionHistory> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdScriptExecutionHistory> adScriptExecutionHistorys = new APINodeList<AdScriptExecutionHistory>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adScriptExecutionHistorys.add(AdScriptExecutionHistory.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adScriptExecutionHistorys;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adScriptExecutionHistorys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adScriptExecutionHistorys.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adScriptExecutionHistorys.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adScriptExecutionHistorys.add(AdScriptExecutionHistory.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adScriptExecutionHistorys.add(AdScriptExecutionHistory.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adScriptExecutionHistorys.add(AdScriptExecutionHistory.loadJSON(obj.toString(), context));
                        }
                    }
                    return adScriptExecutionHistorys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adScriptExecutionHistorys.add(AdScriptExecutionHistory.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adScriptExecutionHistorys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adScriptExecutionHistorys.add(AdScriptExecutionHistory.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adScriptExecutionHistorys;
                }
                adScriptExecutionHistorys.clear();
                adScriptExecutionHistorys.add(AdScriptExecutionHistory.loadJSON(json, context));
                return adScriptExecutionHistorys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdScriptExecutionHistory.getGson().toJson((Object)this);
    }

    public String getFieldAccountId() {
        return this.mAccountId;
    }

    public AdScriptExecutionHistory setFieldAccountId(String value) {
        this.mAccountId = value;
        return this;
    }

    public List<Object> getFieldChanges() {
        return this.mChanges;
    }

    public AdScriptExecutionHistory setFieldChanges(List<Object> value) {
        this.mChanges = value;
        return this;
    }

    public String getFieldCompleteTime() {
        return this.mCompleteTime;
    }

    public AdScriptExecutionHistory setFieldCompleteTime(String value) {
        this.mCompleteTime = value;
        return this;
    }

    public String getFieldExecutionStatus() {
        return this.mExecutionStatus;
    }

    public AdScriptExecutionHistory setFieldExecutionStatus(String value) {
        this.mExecutionStatus = value;
        return this;
    }

    public String getFieldExecutionToken() {
        return this.mExecutionToken;
    }

    public AdScriptExecutionHistory setFieldExecutionToken(String value) {
        this.mExecutionToken = value;
        return this;
    }

    public Object getFieldLogs() {
        return this.mLogs;
    }

    public AdScriptExecutionHistory setFieldLogs(Object value) {
        this.mLogs = value;
        return this;
    }

    public String getFieldScriptId() {
        return this.mScriptId;
    }

    public AdScriptExecutionHistory setFieldScriptId(String value) {
        this.mScriptId = value;
        return this;
    }

    public String getFieldScriptScheduleSpecId() {
        return this.mScriptScheduleSpecId;
    }

    public AdScriptExecutionHistory setFieldScriptScheduleSpecId(String value) {
        this.mScriptScheduleSpecId = value;
        return this;
    }

    public String getFieldStartTime() {
        return this.mStartTime;
    }

    public AdScriptExecutionHistory setFieldStartTime(String value) {
        this.mStartTime = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public AdScriptExecutionHistory setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdScriptExecutionHistory copyFrom(AdScriptExecutionHistory instance) {
        this.mAccountId = instance.mAccountId;
        this.mChanges = instance.mChanges;
        this.mCompleteTime = instance.mCompleteTime;
        this.mExecutionStatus = instance.mExecutionStatus;
        this.mExecutionToken = instance.mExecutionToken;
        this.mLogs = instance.mLogs;
        this.mScriptId = instance.mScriptId;
        this.mScriptScheduleSpecId = instance.mScriptScheduleSpecId;
        this.mStartTime = instance.mStartTime;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdScriptExecutionHistory> getParser() {
        return new APIRequest.ResponseParser<AdScriptExecutionHistory>(){

            @Override
            public APINodeList<AdScriptExecutionHistory> parseResponse(String response, APIContext context, APIRequest<AdScriptExecutionHistory> request) throws APIException.MalformedResponseException {
                return AdScriptExecutionHistory.parseResponse(response, context, request);
            }
        };
    }
}

