/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Place;
import com.facebook.ads.sdk.Targeting;
import com.facebook.ads.sdk.User;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DraftPost
extends APINode {
    @SerializedName(value="admin_creator")
    private User mAdminCreator = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="feed_audience_description")
    private String mFeedAudienceDescription = null;
    @SerializedName(value="feed_targeting")
    private Targeting mFeedTargeting = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="message")
    private String mMessage = null;
    @SerializedName(value="modified_time")
    private String mModifiedTime = null;
    @SerializedName(value="og_action_summary")
    private String mOgActionSummary = null;
    @SerializedName(value="permalink_url")
    private String mPermalinkUrl = null;
    @SerializedName(value="place")
    private Place mPlace = null;
    @SerializedName(value="privacy_description")
    private String mPrivacyDescription = null;
    @SerializedName(value="promotion_info")
    private Object mPromotionInfo = null;
    @SerializedName(value="scheduled_publish_time")
    private String mScheduledPublishTime = null;
    @SerializedName(value="story_token")
    private String mStoryToken = null;
    @SerializedName(value="thumbnail")
    private String mThumbnail = null;
    @SerializedName(value="video_id")
    private String mVideoId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static DraftPost loadJSON(String json, APIContext context) {
        DraftPost draftPost = (DraftPost)DraftPost.getGson().fromJson(json, DraftPost.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(draftPost.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        draftPost.context = context;
        draftPost.rawValue = json;
        return draftPost;
    }

    public static APINodeList<DraftPost> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<DraftPost> draftPosts = new APINodeList<DraftPost>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        draftPosts.add(DraftPost.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return draftPosts;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            draftPosts.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        draftPosts.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            draftPosts.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            draftPosts.add(DraftPost.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                draftPosts.add(DraftPost.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            draftPosts.add(DraftPost.loadJSON(obj.toString(), context));
                        }
                    }
                    return draftPosts;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        draftPosts.add(DraftPost.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return draftPosts;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        draftPosts.add(DraftPost.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return draftPosts;
                }
                draftPosts.clear();
                draftPosts.add(DraftPost.loadJSON(json, context));
                return draftPosts;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return DraftPost.getGson().toJson((Object)this);
    }

    public User getFieldAdminCreator() {
        if (this.mAdminCreator != null) {
            this.mAdminCreator.context = this.getContext();
        }
        return this.mAdminCreator;
    }

    public DraftPost setFieldAdminCreator(User value) {
        this.mAdminCreator = value;
        return this;
    }

    public DraftPost setFieldAdminCreator(String value) {
        Type type = new TypeToken<User>(){}.getType();
        this.mAdminCreator = (User)User.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public DraftPost setFieldCreationTime(String value) {
        this.mCreationTime = value;
        return this;
    }

    public String getFieldFeedAudienceDescription() {
        return this.mFeedAudienceDescription;
    }

    public DraftPost setFieldFeedAudienceDescription(String value) {
        this.mFeedAudienceDescription = value;
        return this;
    }

    public Targeting getFieldFeedTargeting() {
        return this.mFeedTargeting;
    }

    public DraftPost setFieldFeedTargeting(Targeting value) {
        this.mFeedTargeting = value;
        return this;
    }

    public DraftPost setFieldFeedTargeting(String value) {
        Type type = new TypeToken<Targeting>(){}.getType();
        this.mFeedTargeting = (Targeting)Targeting.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public DraftPost setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldMessage() {
        return this.mMessage;
    }

    public DraftPost setFieldMessage(String value) {
        this.mMessage = value;
        return this;
    }

    public String getFieldModifiedTime() {
        return this.mModifiedTime;
    }

    public DraftPost setFieldModifiedTime(String value) {
        this.mModifiedTime = value;
        return this;
    }

    public String getFieldOgActionSummary() {
        return this.mOgActionSummary;
    }

    public DraftPost setFieldOgActionSummary(String value) {
        this.mOgActionSummary = value;
        return this;
    }

    public String getFieldPermalinkUrl() {
        return this.mPermalinkUrl;
    }

    public DraftPost setFieldPermalinkUrl(String value) {
        this.mPermalinkUrl = value;
        return this;
    }

    public Place getFieldPlace() {
        if (this.mPlace != null) {
            this.mPlace.context = this.getContext();
        }
        return this.mPlace;
    }

    public DraftPost setFieldPlace(Place value) {
        this.mPlace = value;
        return this;
    }

    public DraftPost setFieldPlace(String value) {
        Type type = new TypeToken<Place>(){}.getType();
        this.mPlace = (Place)Place.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldPrivacyDescription() {
        return this.mPrivacyDescription;
    }

    public DraftPost setFieldPrivacyDescription(String value) {
        this.mPrivacyDescription = value;
        return this;
    }

    public Object getFieldPromotionInfo() {
        return this.mPromotionInfo;
    }

    public DraftPost setFieldPromotionInfo(Object value) {
        this.mPromotionInfo = value;
        return this;
    }

    public String getFieldScheduledPublishTime() {
        return this.mScheduledPublishTime;
    }

    public DraftPost setFieldScheduledPublishTime(String value) {
        this.mScheduledPublishTime = value;
        return this;
    }

    public String getFieldStoryToken() {
        return this.mStoryToken;
    }

    public DraftPost setFieldStoryToken(String value) {
        this.mStoryToken = value;
        return this;
    }

    public String getFieldThumbnail() {
        return this.mThumbnail;
    }

    public DraftPost setFieldThumbnail(String value) {
        this.mThumbnail = value;
        return this;
    }

    public String getFieldVideoId() {
        return this.mVideoId;
    }

    public DraftPost setFieldVideoId(String value) {
        this.mVideoId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public DraftPost copyFrom(DraftPost instance) {
        this.mAdminCreator = instance.mAdminCreator;
        this.mCreationTime = instance.mCreationTime;
        this.mFeedAudienceDescription = instance.mFeedAudienceDescription;
        this.mFeedTargeting = instance.mFeedTargeting;
        this.mId = instance.mId;
        this.mMessage = instance.mMessage;
        this.mModifiedTime = instance.mModifiedTime;
        this.mOgActionSummary = instance.mOgActionSummary;
        this.mPermalinkUrl = instance.mPermalinkUrl;
        this.mPlace = instance.mPlace;
        this.mPrivacyDescription = instance.mPrivacyDescription;
        this.mPromotionInfo = instance.mPromotionInfo;
        this.mScheduledPublishTime = instance.mScheduledPublishTime;
        this.mStoryToken = instance.mStoryToken;
        this.mThumbnail = instance.mThumbnail;
        this.mVideoId = instance.mVideoId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<DraftPost> getParser() {
        return new APIRequest.ResponseParser<DraftPost>(){

            @Override
            public APINodeList<DraftPost> parseResponse(String response, APIContext context, APIRequest<DraftPost> request) throws APIException.MalformedResponseException {
                return DraftPost.parseResponse(response, context, request);
            }
        };
    }
}

