/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdRuleTrigger
extends APINode {
    @SerializedName(value="field")
    private String mField = null;
    @SerializedName(value="operator")
    private EnumOperator mOperator = null;
    @SerializedName(value="type")
    private EnumType mType = null;
    @SerializedName(value="value")
    private Object mValue = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdRuleTrigger loadJSON(String json, APIContext context) {
        AdRuleTrigger adRuleTrigger = (AdRuleTrigger)AdRuleTrigger.getGson().fromJson(json, AdRuleTrigger.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adRuleTrigger.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adRuleTrigger.context = context;
        adRuleTrigger.rawValue = json;
        return adRuleTrigger;
    }

    public static APINodeList<AdRuleTrigger> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdRuleTrigger> adRuleTriggers = new APINodeList<AdRuleTrigger>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adRuleTriggers.add(AdRuleTrigger.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adRuleTriggers;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adRuleTriggers.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adRuleTriggers.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adRuleTriggers.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adRuleTriggers.add(AdRuleTrigger.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adRuleTriggers.add(AdRuleTrigger.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adRuleTriggers.add(AdRuleTrigger.loadJSON(obj.toString(), context));
                        }
                    }
                    return adRuleTriggers;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adRuleTriggers.add(AdRuleTrigger.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adRuleTriggers;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adRuleTriggers.add(AdRuleTrigger.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adRuleTriggers;
                }
                adRuleTriggers.clear();
                adRuleTriggers.add(AdRuleTrigger.loadJSON(json, context));
                return adRuleTriggers;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdRuleTrigger.getGson().toJson((Object)this);
    }

    public String getFieldField() {
        return this.mField;
    }

    public AdRuleTrigger setFieldField(String value) {
        this.mField = value;
        return this;
    }

    public EnumOperator getFieldOperator() {
        return this.mOperator;
    }

    public AdRuleTrigger setFieldOperator(EnumOperator value) {
        this.mOperator = value;
        return this;
    }

    public EnumType getFieldType() {
        return this.mType;
    }

    public AdRuleTrigger setFieldType(EnumType value) {
        this.mType = value;
        return this;
    }

    public Object getFieldValue() {
        return this.mValue;
    }

    public AdRuleTrigger setFieldValue(Object value) {
        this.mValue = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public AdRuleTrigger setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdRuleTrigger copyFrom(AdRuleTrigger instance) {
        this.mField = instance.mField;
        this.mOperator = instance.mOperator;
        this.mType = instance.mType;
        this.mValue = instance.mValue;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdRuleTrigger> getParser() {
        return new APIRequest.ResponseParser<AdRuleTrigger>(){

            @Override
            public APINodeList<AdRuleTrigger> parseResponse(String response, APIContext context, APIRequest<AdRuleTrigger> request) throws APIException.MalformedResponseException {
                return AdRuleTrigger.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumType {
        VALUE_METADATA_CREATION("METADATA_CREATION"),
        VALUE_METADATA_UPDATE("METADATA_UPDATE"),
        VALUE_STATS_MILESTONE("STATS_MILESTONE"),
        VALUE_STATS_CHANGE("STATS_CHANGE"),
        VALUE_DELIVERY_INSIGHTS_CHANGE("DELIVERY_INSIGHTS_CHANGE"),
        NULL(null);

        private String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumOperator {
        VALUE_GREATER_THAN("GREATER_THAN"),
        VALUE_LESS_THAN("LESS_THAN"),
        VALUE_EQUAL("EQUAL"),
        VALUE_NOT_EQUAL("NOT_EQUAL"),
        VALUE_IN_RANGE("IN_RANGE"),
        VALUE_NOT_IN_RANGE("NOT_IN_RANGE"),
        VALUE_IN("IN"),
        VALUE_NOT_IN("NOT_IN"),
        VALUE_CONTAIN("CONTAIN"),
        VALUE_NOT_CONTAIN("NOT_CONTAIN"),
        VALUE_ANY("ANY"),
        VALUE_ALL("ALL"),
        VALUE_NONE("NONE"),
        NULL(null);

        private String value;

        private EnumOperator(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

