/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.TargetingDynamicRule;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngagementInsightsRule
extends APINode {
    @SerializedName(value="audience_size")
    private Long mAudienceSize = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="rule")
    private TargetingDynamicRule mRule = null;
    @SerializedName(value="rule_id")
    private String mRuleId = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    EngagementInsightsRule() {
    }

    public EngagementInsightsRule(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public EngagementInsightsRule(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public EngagementInsightsRule fetch() throws APIException {
        EngagementInsightsRule newInstance = EngagementInsightsRule.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static EngagementInsightsRule fetchById(Long id, APIContext context) throws APIException {
        return EngagementInsightsRule.fetchById(id.toString(), context);
    }

    public static ListenableFuture<EngagementInsightsRule> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return EngagementInsightsRule.fetchByIdAsync(id.toString(), context);
    }

    public static EngagementInsightsRule fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<EngagementInsightsRule> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<EngagementInsightsRule> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<EngagementInsightsRule>(context, "", "/", "GET", EngagementInsightsRule.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<EngagementInsightsRule>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<EngagementInsightsRule>(context, "", "/", "GET", EngagementInsightsRule.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static EngagementInsightsRule loadJSON(String json, APIContext context) {
        EngagementInsightsRule engagementInsightsRule = (EngagementInsightsRule)EngagementInsightsRule.getGson().fromJson(json, EngagementInsightsRule.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(engagementInsightsRule.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        engagementInsightsRule.context = context;
        engagementInsightsRule.rawValue = json;
        return engagementInsightsRule;
    }

    public static APINodeList<EngagementInsightsRule> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<EngagementInsightsRule> engagementInsightsRules = new APINodeList<EngagementInsightsRule>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        engagementInsightsRules.add(EngagementInsightsRule.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return engagementInsightsRules;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            engagementInsightsRules.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        engagementInsightsRules.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            engagementInsightsRules.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            engagementInsightsRules.add(EngagementInsightsRule.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                engagementInsightsRules.add(EngagementInsightsRule.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            engagementInsightsRules.add(EngagementInsightsRule.loadJSON(obj.toString(), context));
                        }
                    }
                    return engagementInsightsRules;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        engagementInsightsRules.add(EngagementInsightsRule.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return engagementInsightsRules;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        engagementInsightsRules.add(EngagementInsightsRule.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return engagementInsightsRules;
                }
                engagementInsightsRules.clear();
                engagementInsightsRules.add(EngagementInsightsRule.loadJSON(json, context));
                return engagementInsightsRules;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return EngagementInsightsRule.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldAudienceSize() {
        return this.mAudienceSize;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public TargetingDynamicRule getFieldRule() {
        if (this.mRule != null) {
            this.mRule.context = this.getContext();
        }
        return this.mRule;
    }

    public String getFieldRuleId() {
        return this.mRuleId;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public EngagementInsightsRule copyFrom(EngagementInsightsRule instance) {
        this.mAudienceSize = instance.mAudienceSize;
        this.mDescription = instance.mDescription;
        this.mRule = instance.mRule;
        this.mRuleId = instance.mRuleId;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<EngagementInsightsRule> getParser() {
        return new APIRequest.ResponseParser<EngagementInsightsRule>(){

            @Override
            public APINodeList<EngagementInsightsRule> parseResponse(String response, APIContext context, APIRequest<EngagementInsightsRule> request) throws APIException.MalformedResponseException {
                return EngagementInsightsRule.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<EngagementInsightsRule> {
        EngagementInsightsRule lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"audience_size", "description", "rule", "rule_id", "id"};

        @Override
        public EngagementInsightsRule getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public EngagementInsightsRule parseResponse(String response) throws APIException {
            return EngagementInsightsRule.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public EngagementInsightsRule execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public EngagementInsightsRule execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<EngagementInsightsRule> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<EngagementInsightsRule> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, EngagementInsightsRule>(){

                public EngagementInsightsRule apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAudienceSizeField() {
            return this.requestAudienceSizeField(true);
        }

        public APIRequestGet requestAudienceSizeField(boolean value) {
            this.requestField("audience_size", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestRuleField() {
            return this.requestRuleField(true);
        }

        public APIRequestGet requestRuleField(boolean value) {
            this.requestField("rule", value);
            return this;
        }

        public APIRequestGet requestRuleIdField() {
            return this.requestRuleIdField(true);
        }

        public APIRequestGet requestRuleIdField(boolean value) {
            this.requestField("rule_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

