/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdCreativeVideoDataCustomOverlaySpec
extends APINode {
    @SerializedName(value="background_color")
    private String mBackgroundColor = null;
    @SerializedName(value="background_opacity")
    private EnumBackgroundOpacity mBackgroundOpacity = null;
    @SerializedName(value="duration")
    private Long mDuration = null;
    @SerializedName(value="float_with_margin")
    private Boolean mFloatWithMargin = null;
    @SerializedName(value="full_width")
    private Boolean mFullWidth = null;
    @SerializedName(value="option")
    private EnumOption mOption = null;
    @SerializedName(value="position")
    private EnumPosition mPosition = null;
    @SerializedName(value="start")
    private Long mStart = null;
    @SerializedName(value="template")
    private EnumTemplate mTemplate = null;
    @SerializedName(value="text_color")
    private String mTextColor = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdCreativeVideoDataCustomOverlaySpec() {
    }

    public AdCreativeVideoDataCustomOverlaySpec(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdCreativeVideoDataCustomOverlaySpec(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdCreativeVideoDataCustomOverlaySpec fetch() throws APIException {
        AdCreativeVideoDataCustomOverlaySpec newInstance = AdCreativeVideoDataCustomOverlaySpec.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdCreativeVideoDataCustomOverlaySpec fetchById(Long id, APIContext context) throws APIException {
        return AdCreativeVideoDataCustomOverlaySpec.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdCreativeVideoDataCustomOverlaySpec> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdCreativeVideoDataCustomOverlaySpec.fetchByIdAsync(id.toString(), context);
    }

    public static AdCreativeVideoDataCustomOverlaySpec fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdCreativeVideoDataCustomOverlaySpec> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdCreativeVideoDataCustomOverlaySpec> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdCreativeVideoDataCustomOverlaySpec>(context, "", "/", "GET", AdCreativeVideoDataCustomOverlaySpec.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdCreativeVideoDataCustomOverlaySpec>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdCreativeVideoDataCustomOverlaySpec>(context, "", "/", "GET", AdCreativeVideoDataCustomOverlaySpec.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdCreativeVideoDataCustomOverlaySpec loadJSON(String json, APIContext context) {
        AdCreativeVideoDataCustomOverlaySpec adCreativeVideoDataCustomOverlaySpec = (AdCreativeVideoDataCustomOverlaySpec)AdCreativeVideoDataCustomOverlaySpec.getGson().fromJson(json, AdCreativeVideoDataCustomOverlaySpec.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCreativeVideoDataCustomOverlaySpec.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCreativeVideoDataCustomOverlaySpec.context = context;
        adCreativeVideoDataCustomOverlaySpec.rawValue = json;
        return adCreativeVideoDataCustomOverlaySpec;
    }

    public static APINodeList<AdCreativeVideoDataCustomOverlaySpec> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCreativeVideoDataCustomOverlaySpec> adCreativeVideoDataCustomOverlaySpecs = new APINodeList<AdCreativeVideoDataCustomOverlaySpec>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCreativeVideoDataCustomOverlaySpecs.add(AdCreativeVideoDataCustomOverlaySpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adCreativeVideoDataCustomOverlaySpecs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCreativeVideoDataCustomOverlaySpecs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCreativeVideoDataCustomOverlaySpecs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCreativeVideoDataCustomOverlaySpecs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCreativeVideoDataCustomOverlaySpecs.add(AdCreativeVideoDataCustomOverlaySpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCreativeVideoDataCustomOverlaySpecs.add(AdCreativeVideoDataCustomOverlaySpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCreativeVideoDataCustomOverlaySpecs.add(AdCreativeVideoDataCustomOverlaySpec.loadJSON(obj.toString(), context));
                        }
                    }
                    return adCreativeVideoDataCustomOverlaySpecs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCreativeVideoDataCustomOverlaySpecs.add(AdCreativeVideoDataCustomOverlaySpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adCreativeVideoDataCustomOverlaySpecs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCreativeVideoDataCustomOverlaySpecs.add(AdCreativeVideoDataCustomOverlaySpec.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCreativeVideoDataCustomOverlaySpecs;
                }
                adCreativeVideoDataCustomOverlaySpecs.clear();
                adCreativeVideoDataCustomOverlaySpecs.add(AdCreativeVideoDataCustomOverlaySpec.loadJSON(json, context));
                return adCreativeVideoDataCustomOverlaySpecs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCreativeVideoDataCustomOverlaySpec.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldBackgroundColor() {
        return this.mBackgroundColor;
    }

    public EnumBackgroundOpacity getFieldBackgroundOpacity() {
        return this.mBackgroundOpacity;
    }

    public Long getFieldDuration() {
        return this.mDuration;
    }

    public Boolean getFieldFloatWithMargin() {
        return this.mFloatWithMargin;
    }

    public Boolean getFieldFullWidth() {
        return this.mFullWidth;
    }

    public EnumOption getFieldOption() {
        return this.mOption;
    }

    public EnumPosition getFieldPosition() {
        return this.mPosition;
    }

    public Long getFieldStart() {
        return this.mStart;
    }

    public EnumTemplate getFieldTemplate() {
        return this.mTemplate;
    }

    public String getFieldTextColor() {
        return this.mTextColor;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCreativeVideoDataCustomOverlaySpec copyFrom(AdCreativeVideoDataCustomOverlaySpec instance) {
        this.mBackgroundColor = instance.mBackgroundColor;
        this.mBackgroundOpacity = instance.mBackgroundOpacity;
        this.mDuration = instance.mDuration;
        this.mFloatWithMargin = instance.mFloatWithMargin;
        this.mFullWidth = instance.mFullWidth;
        this.mOption = instance.mOption;
        this.mPosition = instance.mPosition;
        this.mStart = instance.mStart;
        this.mTemplate = instance.mTemplate;
        this.mTextColor = instance.mTextColor;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCreativeVideoDataCustomOverlaySpec> getParser() {
        return new APIRequest.ResponseParser<AdCreativeVideoDataCustomOverlaySpec>(){

            @Override
            public APINodeList<AdCreativeVideoDataCustomOverlaySpec> parseResponse(String response, APIContext context, APIRequest<AdCreativeVideoDataCustomOverlaySpec> request) throws APIException.MalformedResponseException {
                return AdCreativeVideoDataCustomOverlaySpec.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumTemplate {
        VALUE_RECTANGLE_WITH_TEXT("rectangle_with_text"),
        NULL(null);

        private String value;

        private EnumTemplate(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumPosition {
        VALUE_TOP_LEFT("top_left"),
        VALUE_TOP_CENTER("top_center"),
        VALUE_TOP_RIGHT("top_right"),
        VALUE_MIDDLE_LEFT("middle_left"),
        VALUE_MIDDLE_CENTER("middle_center"),
        VALUE_MIDDLE_RIGHT("middle_right"),
        NULL(null);

        private String value;

        private EnumPosition(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumOption {
        VALUE_BANK_TRANSFER("bank_transfer"),
        VALUE_BOLETO("boleto"),
        VALUE_DISCOUNT_WITH_BOLETO("discount_with_boleto"),
        VALUE_CASH_ON_DELIVERY("cash_on_delivery"),
        VALUE_HOME_DELIVERY("home_delivery"),
        VALUE_FREE_SHIPPING("free_shipping"),
        VALUE_INVENTORY("inventory"),
        VALUE_PAY_ON_ARRIVAL("pay_on_arrival"),
        VALUE_PAY_AT_HOTEL("pay_at_hotel"),
        VALUE_FAST_DELIVERY("fast_delivery"),
        NULL(null);

        private String value;

        private EnumOption(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumBackgroundOpacity {
        VALUE_SOLID("solid"),
        VALUE_HALF("half"),
        NULL(null);

        private String value;

        private EnumBackgroundOpacity(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdCreativeVideoDataCustomOverlaySpec> {
        AdCreativeVideoDataCustomOverlaySpec lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"background_color", "background_opacity", "duration", "float_with_margin", "full_width", "option", "position", "start", "template", "text_color", "id"};

        @Override
        public AdCreativeVideoDataCustomOverlaySpec getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdCreativeVideoDataCustomOverlaySpec parseResponse(String response) throws APIException {
            return AdCreativeVideoDataCustomOverlaySpec.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdCreativeVideoDataCustomOverlaySpec execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdCreativeVideoDataCustomOverlaySpec execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdCreativeVideoDataCustomOverlaySpec> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdCreativeVideoDataCustomOverlaySpec> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdCreativeVideoDataCustomOverlaySpec>(){

                public AdCreativeVideoDataCustomOverlaySpec apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBackgroundColorField() {
            return this.requestBackgroundColorField(true);
        }

        public APIRequestGet requestBackgroundColorField(boolean value) {
            this.requestField("background_color", value);
            return this;
        }

        public APIRequestGet requestBackgroundOpacityField() {
            return this.requestBackgroundOpacityField(true);
        }

        public APIRequestGet requestBackgroundOpacityField(boolean value) {
            this.requestField("background_opacity", value);
            return this;
        }

        public APIRequestGet requestDurationField() {
            return this.requestDurationField(true);
        }

        public APIRequestGet requestDurationField(boolean value) {
            this.requestField("duration", value);
            return this;
        }

        public APIRequestGet requestFloatWithMarginField() {
            return this.requestFloatWithMarginField(true);
        }

        public APIRequestGet requestFloatWithMarginField(boolean value) {
            this.requestField("float_with_margin", value);
            return this;
        }

        public APIRequestGet requestFullWidthField() {
            return this.requestFullWidthField(true);
        }

        public APIRequestGet requestFullWidthField(boolean value) {
            this.requestField("full_width", value);
            return this;
        }

        public APIRequestGet requestOptionField() {
            return this.requestOptionField(true);
        }

        public APIRequestGet requestOptionField(boolean value) {
            this.requestField("option", value);
            return this;
        }

        public APIRequestGet requestPositionField() {
            return this.requestPositionField(true);
        }

        public APIRequestGet requestPositionField(boolean value) {
            this.requestField("position", value);
            return this;
        }

        public APIRequestGet requestStartField() {
            return this.requestStartField(true);
        }

        public APIRequestGet requestStartField(boolean value) {
            this.requestField("start", value);
            return this;
        }

        public APIRequestGet requestTemplateField() {
            return this.requestTemplateField(true);
        }

        public APIRequestGet requestTemplateField(boolean value) {
            this.requestField("template", value);
            return this;
        }

        public APIRequestGet requestTextColorField() {
            return this.requestTextColorField(true);
        }

        public APIRequestGet requestTextColorField(boolean value) {
            this.requestField("text_color", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

