/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdCreativeLinkDataImageLayerSpec
extends APINode {
    @SerializedName(value="blending_mode")
    private EnumBlendingMode mBlendingMode = null;
    @SerializedName(value="content")
    private Object mContent = null;
    @SerializedName(value="frame_image_hash")
    private String mFrameImageHash = null;
    @SerializedName(value="frame_source")
    private EnumFrameSource mFrameSource = null;
    @SerializedName(value="image_source")
    private EnumImageSource mImageSource = null;
    @SerializedName(value="layer_type")
    private EnumLayerType mLayerType = null;
    @SerializedName(value="opacity")
    private Long mOpacity = null;
    @SerializedName(value="overlay_position")
    private EnumOverlayPosition mOverlayPosition = null;
    @SerializedName(value="overlay_shape")
    private EnumOverlayShape mOverlayShape = null;
    @SerializedName(value="scale")
    private Long mScale = null;
    @SerializedName(value="shape_color")
    private String mShapeColor = null;
    @SerializedName(value="text_color")
    private String mTextColor = null;
    @SerializedName(value="text_font")
    private EnumTextFont mTextFont = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdCreativeLinkDataImageLayerSpec() {
    }

    public AdCreativeLinkDataImageLayerSpec(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdCreativeLinkDataImageLayerSpec(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdCreativeLinkDataImageLayerSpec fetch() throws APIException {
        AdCreativeLinkDataImageLayerSpec newInstance = AdCreativeLinkDataImageLayerSpec.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdCreativeLinkDataImageLayerSpec fetchById(Long id, APIContext context) throws APIException {
        return AdCreativeLinkDataImageLayerSpec.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdCreativeLinkDataImageLayerSpec> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdCreativeLinkDataImageLayerSpec.fetchByIdAsync(id.toString(), context);
    }

    public static AdCreativeLinkDataImageLayerSpec fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdCreativeLinkDataImageLayerSpec> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdCreativeLinkDataImageLayerSpec> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdCreativeLinkDataImageLayerSpec>(context, "", "/", "GET", AdCreativeLinkDataImageLayerSpec.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdCreativeLinkDataImageLayerSpec>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdCreativeLinkDataImageLayerSpec>(context, "", "/", "GET", AdCreativeLinkDataImageLayerSpec.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdCreativeLinkDataImageLayerSpec loadJSON(String json, APIContext context) {
        AdCreativeLinkDataImageLayerSpec adCreativeLinkDataImageLayerSpec = (AdCreativeLinkDataImageLayerSpec)AdCreativeLinkDataImageLayerSpec.getGson().fromJson(json, AdCreativeLinkDataImageLayerSpec.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCreativeLinkDataImageLayerSpec.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCreativeLinkDataImageLayerSpec.context = context;
        adCreativeLinkDataImageLayerSpec.rawValue = json;
        return adCreativeLinkDataImageLayerSpec;
    }

    public static APINodeList<AdCreativeLinkDataImageLayerSpec> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCreativeLinkDataImageLayerSpec> adCreativeLinkDataImageLayerSpecs = new APINodeList<AdCreativeLinkDataImageLayerSpec>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCreativeLinkDataImageLayerSpecs.add(AdCreativeLinkDataImageLayerSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adCreativeLinkDataImageLayerSpecs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCreativeLinkDataImageLayerSpecs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCreativeLinkDataImageLayerSpecs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCreativeLinkDataImageLayerSpecs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCreativeLinkDataImageLayerSpecs.add(AdCreativeLinkDataImageLayerSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCreativeLinkDataImageLayerSpecs.add(AdCreativeLinkDataImageLayerSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCreativeLinkDataImageLayerSpecs.add(AdCreativeLinkDataImageLayerSpec.loadJSON(obj.toString(), context));
                        }
                    }
                    return adCreativeLinkDataImageLayerSpecs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCreativeLinkDataImageLayerSpecs.add(AdCreativeLinkDataImageLayerSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adCreativeLinkDataImageLayerSpecs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCreativeLinkDataImageLayerSpecs.add(AdCreativeLinkDataImageLayerSpec.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCreativeLinkDataImageLayerSpecs;
                }
                adCreativeLinkDataImageLayerSpecs.clear();
                adCreativeLinkDataImageLayerSpecs.add(AdCreativeLinkDataImageLayerSpec.loadJSON(json, context));
                return adCreativeLinkDataImageLayerSpecs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCreativeLinkDataImageLayerSpec.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public EnumBlendingMode getFieldBlendingMode() {
        return this.mBlendingMode;
    }

    public Object getFieldContent() {
        return this.mContent;
    }

    public String getFieldFrameImageHash() {
        return this.mFrameImageHash;
    }

    public EnumFrameSource getFieldFrameSource() {
        return this.mFrameSource;
    }

    public EnumImageSource getFieldImageSource() {
        return this.mImageSource;
    }

    public EnumLayerType getFieldLayerType() {
        return this.mLayerType;
    }

    public Long getFieldOpacity() {
        return this.mOpacity;
    }

    public EnumOverlayPosition getFieldOverlayPosition() {
        return this.mOverlayPosition;
    }

    public EnumOverlayShape getFieldOverlayShape() {
        return this.mOverlayShape;
    }

    public Long getFieldScale() {
        return this.mScale;
    }

    public String getFieldShapeColor() {
        return this.mShapeColor;
    }

    public String getFieldTextColor() {
        return this.mTextColor;
    }

    public EnumTextFont getFieldTextFont() {
        return this.mTextFont;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCreativeLinkDataImageLayerSpec copyFrom(AdCreativeLinkDataImageLayerSpec instance) {
        this.mBlendingMode = instance.mBlendingMode;
        this.mContent = instance.mContent;
        this.mFrameImageHash = instance.mFrameImageHash;
        this.mFrameSource = instance.mFrameSource;
        this.mImageSource = instance.mImageSource;
        this.mLayerType = instance.mLayerType;
        this.mOpacity = instance.mOpacity;
        this.mOverlayPosition = instance.mOverlayPosition;
        this.mOverlayShape = instance.mOverlayShape;
        this.mScale = instance.mScale;
        this.mShapeColor = instance.mShapeColor;
        this.mTextColor = instance.mTextColor;
        this.mTextFont = instance.mTextFont;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCreativeLinkDataImageLayerSpec> getParser() {
        return new APIRequest.ResponseParser<AdCreativeLinkDataImageLayerSpec>(){

            @Override
            public APINodeList<AdCreativeLinkDataImageLayerSpec> parseResponse(String response, APIContext context, APIRequest<AdCreativeLinkDataImageLayerSpec> request) throws APIException.MalformedResponseException {
                return AdCreativeLinkDataImageLayerSpec.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumTextFont {
        VALUE_DROID_SERIF_REGULAR("droid_serif_regular"),
        VALUE_LATO_REGULAR("lato_regular"),
        VALUE_NOTO_SANS_REGULAR("noto_sans_regular"),
        VALUE_NUNITO_SANS_BOLD("nunito_sans_bold"),
        VALUE_OPEN_SANS_BOLD("open_sans_bold"),
        VALUE_OPEN_SANS_CONDENSED_BOLD("open_sans_condensed_bold"),
        VALUE_PT_SERIF_BOLD("pt_serif_bold"),
        VALUE_ROBOTO_CONDENSED_REGULAR("roboto_condensed_regular"),
        VALUE_ROBOTO_MEDIUM("roboto_medium"),
        NULL(null);

        private String value;

        private EnumTextFont(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumOverlayShape {
        VALUE_CIRCLE("circle"),
        VALUE_NONE("none"),
        VALUE_PILL("pill"),
        VALUE_RECTANGLE("rectangle"),
        VALUE_TRIANGLE("triangle"),
        NULL(null);

        private String value;

        private EnumOverlayShape(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumOverlayPosition {
        VALUE_BOTTOM("bottom"),
        VALUE_BOTTOM_LEFT("bottom_left"),
        VALUE_BOTTOM_RIGHT("bottom_right"),
        VALUE_CENTER("center"),
        VALUE_LEFT("left"),
        VALUE_RIGHT("right"),
        VALUE_TOP("top"),
        VALUE_TOP_LEFT("top_left"),
        VALUE_TOP_RIGHT("top_right"),
        NULL(null);

        private String value;

        private EnumOverlayPosition(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumLayerType {
        VALUE_FRAME_OVERLAY("frame_overlay"),
        VALUE_IMAGE("image"),
        VALUE_TEXT_OVERLAY("text_overlay"),
        NULL(null);

        private String value;

        private EnumLayerType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumImageSource {
        VALUE_CATALOG("catalog"),
        NULL(null);

        private String value;

        private EnumImageSource(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumFrameSource {
        VALUE_CUSTOM("custom"),
        NULL(null);

        private String value;

        private EnumFrameSource(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumBlendingMode {
        VALUE_LIGHTEN("lighten"),
        VALUE_MULTIPLY("multiply"),
        VALUE_NORMAL("normal"),
        NULL(null);

        private String value;

        private EnumBlendingMode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdCreativeLinkDataImageLayerSpec> {
        AdCreativeLinkDataImageLayerSpec lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"blending_mode", "content", "frame_image_hash", "frame_source", "image_source", "layer_type", "opacity", "overlay_position", "overlay_shape", "scale", "shape_color", "text_color", "text_font", "id"};

        @Override
        public AdCreativeLinkDataImageLayerSpec getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdCreativeLinkDataImageLayerSpec parseResponse(String response) throws APIException {
            return AdCreativeLinkDataImageLayerSpec.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdCreativeLinkDataImageLayerSpec execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdCreativeLinkDataImageLayerSpec execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdCreativeLinkDataImageLayerSpec> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdCreativeLinkDataImageLayerSpec> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdCreativeLinkDataImageLayerSpec>(){

                public AdCreativeLinkDataImageLayerSpec apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBlendingModeField() {
            return this.requestBlendingModeField(true);
        }

        public APIRequestGet requestBlendingModeField(boolean value) {
            this.requestField("blending_mode", value);
            return this;
        }

        public APIRequestGet requestContentField() {
            return this.requestContentField(true);
        }

        public APIRequestGet requestContentField(boolean value) {
            this.requestField("content", value);
            return this;
        }

        public APIRequestGet requestFrameImageHashField() {
            return this.requestFrameImageHashField(true);
        }

        public APIRequestGet requestFrameImageHashField(boolean value) {
            this.requestField("frame_image_hash", value);
            return this;
        }

        public APIRequestGet requestFrameSourceField() {
            return this.requestFrameSourceField(true);
        }

        public APIRequestGet requestFrameSourceField(boolean value) {
            this.requestField("frame_source", value);
            return this;
        }

        public APIRequestGet requestImageSourceField() {
            return this.requestImageSourceField(true);
        }

        public APIRequestGet requestImageSourceField(boolean value) {
            this.requestField("image_source", value);
            return this;
        }

        public APIRequestGet requestLayerTypeField() {
            return this.requestLayerTypeField(true);
        }

        public APIRequestGet requestLayerTypeField(boolean value) {
            this.requestField("layer_type", value);
            return this;
        }

        public APIRequestGet requestOpacityField() {
            return this.requestOpacityField(true);
        }

        public APIRequestGet requestOpacityField(boolean value) {
            this.requestField("opacity", value);
            return this;
        }

        public APIRequestGet requestOverlayPositionField() {
            return this.requestOverlayPositionField(true);
        }

        public APIRequestGet requestOverlayPositionField(boolean value) {
            this.requestField("overlay_position", value);
            return this;
        }

        public APIRequestGet requestOverlayShapeField() {
            return this.requestOverlayShapeField(true);
        }

        public APIRequestGet requestOverlayShapeField(boolean value) {
            this.requestField("overlay_shape", value);
            return this;
        }

        public APIRequestGet requestScaleField() {
            return this.requestScaleField(true);
        }

        public APIRequestGet requestScaleField(boolean value) {
            this.requestField("scale", value);
            return this;
        }

        public APIRequestGet requestShapeColorField() {
            return this.requestShapeColorField(true);
        }

        public APIRequestGet requestShapeColorField(boolean value) {
            this.requestField("shape_color", value);
            return this;
        }

        public APIRequestGet requestTextColorField() {
            return this.requestTextColorField(true);
        }

        public APIRequestGet requestTextColorField(boolean value) {
            this.requestField("text_color", value);
            return this;
        }

        public APIRequestGet requestTextFontField() {
            return this.requestTextFontField(true);
        }

        public APIRequestGet requestTextFontField(boolean value) {
            this.requestField("text_font", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

