/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageRestaurantServices
extends APINode {
    @SerializedName(value="catering")
    private Boolean mCatering = null;
    @SerializedName(value="delivery")
    private Boolean mDelivery = null;
    @SerializedName(value="groups")
    private Boolean mGroups = null;
    @SerializedName(value="kids")
    private Boolean mKids = null;
    @SerializedName(value="outdoor")
    private Boolean mOutdoor = null;
    @SerializedName(value="pickup")
    private Boolean mPickup = null;
    @SerializedName(value="reserve")
    private Boolean mReserve = null;
    @SerializedName(value="takeout")
    private Boolean mTakeout = null;
    @SerializedName(value="waiter")
    private Boolean mWaiter = null;
    @SerializedName(value="walkins")
    private Boolean mWalkins = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    PageRestaurantServices() {
    }

    public PageRestaurantServices(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public PageRestaurantServices(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public PageRestaurantServices fetch() throws APIException {
        PageRestaurantServices newInstance = PageRestaurantServices.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static PageRestaurantServices fetchById(Long id, APIContext context) throws APIException {
        return PageRestaurantServices.fetchById(id.toString(), context);
    }

    public static ListenableFuture<PageRestaurantServices> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return PageRestaurantServices.fetchByIdAsync(id.toString(), context);
    }

    public static PageRestaurantServices fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<PageRestaurantServices> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<PageRestaurantServices> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<PageRestaurantServices>(context, "", "/", "GET", PageRestaurantServices.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<PageRestaurantServices>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<PageRestaurantServices>(context, "", "/", "GET", PageRestaurantServices.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PageRestaurantServices loadJSON(String json, APIContext context) {
        PageRestaurantServices pageRestaurantServices = (PageRestaurantServices)PageRestaurantServices.getGson().fromJson(json, PageRestaurantServices.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(pageRestaurantServices.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        pageRestaurantServices.context = context;
        pageRestaurantServices.rawValue = json;
        return pageRestaurantServices;
    }

    public static APINodeList<PageRestaurantServices> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PageRestaurantServices> pageRestaurantServicess = new APINodeList<PageRestaurantServices>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        pageRestaurantServicess.add(PageRestaurantServices.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return pageRestaurantServicess;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            pageRestaurantServicess.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        pageRestaurantServicess.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            pageRestaurantServicess.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            pageRestaurantServicess.add(PageRestaurantServices.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                pageRestaurantServicess.add(PageRestaurantServices.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            pageRestaurantServicess.add(PageRestaurantServices.loadJSON(obj.toString(), context));
                        }
                    }
                    return pageRestaurantServicess;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        pageRestaurantServicess.add(PageRestaurantServices.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return pageRestaurantServicess;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        pageRestaurantServicess.add(PageRestaurantServices.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return pageRestaurantServicess;
                }
                pageRestaurantServicess.clear();
                pageRestaurantServicess.add(PageRestaurantServices.loadJSON(json, context));
                return pageRestaurantServicess;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PageRestaurantServices.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Boolean getFieldCatering() {
        return this.mCatering;
    }

    public Boolean getFieldDelivery() {
        return this.mDelivery;
    }

    public Boolean getFieldGroups() {
        return this.mGroups;
    }

    public Boolean getFieldKids() {
        return this.mKids;
    }

    public Boolean getFieldOutdoor() {
        return this.mOutdoor;
    }

    public Boolean getFieldPickup() {
        return this.mPickup;
    }

    public Boolean getFieldReserve() {
        return this.mReserve;
    }

    public Boolean getFieldTakeout() {
        return this.mTakeout;
    }

    public Boolean getFieldWaiter() {
        return this.mWaiter;
    }

    public Boolean getFieldWalkins() {
        return this.mWalkins;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PageRestaurantServices copyFrom(PageRestaurantServices instance) {
        this.mCatering = instance.mCatering;
        this.mDelivery = instance.mDelivery;
        this.mGroups = instance.mGroups;
        this.mKids = instance.mKids;
        this.mOutdoor = instance.mOutdoor;
        this.mPickup = instance.mPickup;
        this.mReserve = instance.mReserve;
        this.mTakeout = instance.mTakeout;
        this.mWaiter = instance.mWaiter;
        this.mWalkins = instance.mWalkins;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PageRestaurantServices> getParser() {
        return new APIRequest.ResponseParser<PageRestaurantServices>(){

            @Override
            public APINodeList<PageRestaurantServices> parseResponse(String response, APIContext context, APIRequest<PageRestaurantServices> request) throws APIException.MalformedResponseException {
                return PageRestaurantServices.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<PageRestaurantServices> {
        PageRestaurantServices lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"catering", "delivery", "groups", "kids", "outdoor", "pickup", "reserve", "takeout", "waiter", "walkins", "id"};

        @Override
        public PageRestaurantServices getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PageRestaurantServices parseResponse(String response) throws APIException {
            return PageRestaurantServices.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public PageRestaurantServices execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PageRestaurantServices execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<PageRestaurantServices> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PageRestaurantServices> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, PageRestaurantServices>(){

                public PageRestaurantServices apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCateringField() {
            return this.requestCateringField(true);
        }

        public APIRequestGet requestCateringField(boolean value) {
            this.requestField("catering", value);
            return this;
        }

        public APIRequestGet requestDeliveryField() {
            return this.requestDeliveryField(true);
        }

        public APIRequestGet requestDeliveryField(boolean value) {
            this.requestField("delivery", value);
            return this;
        }

        public APIRequestGet requestGroupsField() {
            return this.requestGroupsField(true);
        }

        public APIRequestGet requestGroupsField(boolean value) {
            this.requestField("groups", value);
            return this;
        }

        public APIRequestGet requestKidsField() {
            return this.requestKidsField(true);
        }

        public APIRequestGet requestKidsField(boolean value) {
            this.requestField("kids", value);
            return this;
        }

        public APIRequestGet requestOutdoorField() {
            return this.requestOutdoorField(true);
        }

        public APIRequestGet requestOutdoorField(boolean value) {
            this.requestField("outdoor", value);
            return this;
        }

        public APIRequestGet requestPickupField() {
            return this.requestPickupField(true);
        }

        public APIRequestGet requestPickupField(boolean value) {
            this.requestField("pickup", value);
            return this;
        }

        public APIRequestGet requestReserveField() {
            return this.requestReserveField(true);
        }

        public APIRequestGet requestReserveField(boolean value) {
            this.requestField("reserve", value);
            return this;
        }

        public APIRequestGet requestTakeoutField() {
            return this.requestTakeoutField(true);
        }

        public APIRequestGet requestTakeoutField(boolean value) {
            this.requestField("takeout", value);
            return this;
        }

        public APIRequestGet requestWaiterField() {
            return this.requestWaiterField(true);
        }

        public APIRequestGet requestWaiterField(boolean value) {
            this.requestField("waiter", value);
            return this;
        }

        public APIRequestGet requestWalkinsField() {
            return this.requestWalkinsField(true);
        }

        public APIRequestGet requestWalkinsField(boolean value) {
            this.requestField("walkins", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

