/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyticsQueryResult
extends APINode {
    @SerializedName(value="columns")
    private Object mColumns = null;
    @SerializedName(value="datapoints")
    private List<Object> mDatapoints = null;
    @SerializedName(value="error")
    private Object mError = null;
    @SerializedName(value="query_id")
    private String mQueryId = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AnalyticsQueryResult() {
    }

    public AnalyticsQueryResult(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AnalyticsQueryResult(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AnalyticsQueryResult fetch() throws APIException {
        AnalyticsQueryResult newInstance = AnalyticsQueryResult.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AnalyticsQueryResult fetchById(Long id, APIContext context) throws APIException {
        return AnalyticsQueryResult.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AnalyticsQueryResult> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AnalyticsQueryResult.fetchByIdAsync(id.toString(), context);
    }

    public static AnalyticsQueryResult fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AnalyticsQueryResult> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AnalyticsQueryResult> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AnalyticsQueryResult>(context, "", "/", "GET", AnalyticsQueryResult.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AnalyticsQueryResult>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AnalyticsQueryResult>(context, "", "/", "GET", AnalyticsQueryResult.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AnalyticsQueryResult loadJSON(String json, APIContext context) {
        AnalyticsQueryResult analyticsQueryResult = (AnalyticsQueryResult)AnalyticsQueryResult.getGson().fromJson(json, AnalyticsQueryResult.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(analyticsQueryResult.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        analyticsQueryResult.context = context;
        analyticsQueryResult.rawValue = json;
        return analyticsQueryResult;
    }

    public static APINodeList<AnalyticsQueryResult> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AnalyticsQueryResult> analyticsQueryResults = new APINodeList<AnalyticsQueryResult>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        analyticsQueryResults.add(AnalyticsQueryResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return analyticsQueryResults;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            analyticsQueryResults.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        analyticsQueryResults.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            analyticsQueryResults.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            analyticsQueryResults.add(AnalyticsQueryResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                analyticsQueryResults.add(AnalyticsQueryResult.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            analyticsQueryResults.add(AnalyticsQueryResult.loadJSON(obj.toString(), context));
                        }
                    }
                    return analyticsQueryResults;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        analyticsQueryResults.add(AnalyticsQueryResult.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return analyticsQueryResults;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        analyticsQueryResults.add(AnalyticsQueryResult.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return analyticsQueryResults;
                }
                analyticsQueryResults.clear();
                analyticsQueryResults.add(AnalyticsQueryResult.loadJSON(json, context));
                return analyticsQueryResults;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AnalyticsQueryResult.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Object getFieldColumns() {
        return this.mColumns;
    }

    public List<Object> getFieldDatapoints() {
        return this.mDatapoints;
    }

    public Object getFieldError() {
        return this.mError;
    }

    public String getFieldQueryId() {
        return this.mQueryId;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AnalyticsQueryResult copyFrom(AnalyticsQueryResult instance) {
        this.mColumns = instance.mColumns;
        this.mDatapoints = instance.mDatapoints;
        this.mError = instance.mError;
        this.mQueryId = instance.mQueryId;
        this.mStatus = instance.mStatus;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AnalyticsQueryResult> getParser() {
        return new APIRequest.ResponseParser<AnalyticsQueryResult>(){

            @Override
            public APINodeList<AnalyticsQueryResult> parseResponse(String response, APIContext context, APIRequest<AnalyticsQueryResult> request) throws APIException.MalformedResponseException {
                return AnalyticsQueryResult.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AnalyticsQueryResult> {
        AnalyticsQueryResult lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"columns", "datapoints", "error", "query_id", "status", "id"};

        @Override
        public AnalyticsQueryResult getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AnalyticsQueryResult parseResponse(String response) throws APIException {
            return AnalyticsQueryResult.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AnalyticsQueryResult execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AnalyticsQueryResult execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AnalyticsQueryResult> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AnalyticsQueryResult> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AnalyticsQueryResult>(){

                public AnalyticsQueryResult apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestColumnsField() {
            return this.requestColumnsField(true);
        }

        public APIRequestGet requestColumnsField(boolean value) {
            this.requestField("columns", value);
            return this;
        }

        public APIRequestGet requestDatapointsField() {
            return this.requestDatapointsField(true);
        }

        public APIRequestGet requestDatapointsField(boolean value) {
            this.requestField("datapoints", value);
            return this;
        }

        public APIRequestGet requestErrorField() {
            return this.requestErrorField(true);
        }

        public APIRequestGet requestErrorField(boolean value) {
            this.requestField("error", value);
            return this;
        }

        public APIRequestGet requestQueryIdField() {
            return this.requestQueryIdField(true);
        }

        public APIRequestGet requestQueryIdField(boolean value) {
            this.requestField("query_id", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

