/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfilePictureSource
extends APINode {
    @SerializedName(value="bottom")
    private Long mBottom = null;
    @SerializedName(value="cache_key")
    private String mCacheKey = null;
    @SerializedName(value="height")
    private Long mHeight = null;
    @SerializedName(value="is_silhouette")
    private Boolean mIsSilhouette = null;
    @SerializedName(value="left")
    private Long mLeft = null;
    @SerializedName(value="right")
    private Long mRight = null;
    @SerializedName(value="top")
    private Long mTop = null;
    @SerializedName(value="uri")
    private String mUri = null;
    @SerializedName(value="url")
    private String mUrl = null;
    @SerializedName(value="width")
    private Long mWidth = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    ProfilePictureSource() {
    }

    public ProfilePictureSource(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ProfilePictureSource(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ProfilePictureSource fetch() throws APIException {
        ProfilePictureSource newInstance = ProfilePictureSource.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ProfilePictureSource fetchById(Long id, APIContext context) throws APIException {
        return ProfilePictureSource.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ProfilePictureSource> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ProfilePictureSource.fetchByIdAsync(id.toString(), context);
    }

    public static ProfilePictureSource fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ProfilePictureSource> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ProfilePictureSource> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ProfilePictureSource>(context, "", "/", "GET", ProfilePictureSource.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ProfilePictureSource>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ProfilePictureSource>(context, "", "/", "GET", ProfilePictureSource.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ProfilePictureSource loadJSON(String json, APIContext context) {
        ProfilePictureSource profilePictureSource = (ProfilePictureSource)ProfilePictureSource.getGson().fromJson(json, ProfilePictureSource.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(profilePictureSource.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        profilePictureSource.context = context;
        profilePictureSource.rawValue = json;
        return profilePictureSource;
    }

    public static APINodeList<ProfilePictureSource> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ProfilePictureSource> profilePictureSources = new APINodeList<ProfilePictureSource>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        profilePictureSources.add(ProfilePictureSource.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return profilePictureSources;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            profilePictureSources.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        profilePictureSources.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            profilePictureSources.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            profilePictureSources.add(ProfilePictureSource.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                profilePictureSources.add(ProfilePictureSource.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            profilePictureSources.add(ProfilePictureSource.loadJSON(obj.toString(), context));
                        }
                    }
                    return profilePictureSources;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        profilePictureSources.add(ProfilePictureSource.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return profilePictureSources;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        profilePictureSources.add(ProfilePictureSource.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return profilePictureSources;
                }
                profilePictureSources.clear();
                profilePictureSources.add(ProfilePictureSource.loadJSON(json, context));
                return profilePictureSources;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ProfilePictureSource.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldBottom() {
        return this.mBottom;
    }

    public String getFieldCacheKey() {
        return this.mCacheKey;
    }

    public Long getFieldHeight() {
        return this.mHeight;
    }

    public Boolean getFieldIsSilhouette() {
        return this.mIsSilhouette;
    }

    public Long getFieldLeft() {
        return this.mLeft;
    }

    public Long getFieldRight() {
        return this.mRight;
    }

    public Long getFieldTop() {
        return this.mTop;
    }

    public String getFieldUri() {
        return this.mUri;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    public Long getFieldWidth() {
        return this.mWidth;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ProfilePictureSource copyFrom(ProfilePictureSource instance) {
        this.mBottom = instance.mBottom;
        this.mCacheKey = instance.mCacheKey;
        this.mHeight = instance.mHeight;
        this.mIsSilhouette = instance.mIsSilhouette;
        this.mLeft = instance.mLeft;
        this.mRight = instance.mRight;
        this.mTop = instance.mTop;
        this.mUri = instance.mUri;
        this.mUrl = instance.mUrl;
        this.mWidth = instance.mWidth;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ProfilePictureSource> getParser() {
        return new APIRequest.ResponseParser<ProfilePictureSource>(){

            @Override
            public APINodeList<ProfilePictureSource> parseResponse(String response, APIContext context, APIRequest<ProfilePictureSource> request) throws APIException.MalformedResponseException {
                return ProfilePictureSource.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumType {
        VALUE_THUMBNAIL("thumbnail"),
        VALUE_SMALL("small"),
        VALUE_ALBUM("album"),
        NULL(null);

        private String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<ProfilePictureSource> {
        ProfilePictureSource lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"bottom", "cache_key", "height", "is_silhouette", "left", "right", "top", "uri", "url", "width", "id"};

        @Override
        public ProfilePictureSource getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ProfilePictureSource parseResponse(String response) throws APIException {
            return ProfilePictureSource.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public ProfilePictureSource execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ProfilePictureSource execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<ProfilePictureSource> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ProfilePictureSource> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, ProfilePictureSource>(){

                public ProfilePictureSource apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBottomField() {
            return this.requestBottomField(true);
        }

        public APIRequestGet requestBottomField(boolean value) {
            this.requestField("bottom", value);
            return this;
        }

        public APIRequestGet requestCacheKeyField() {
            return this.requestCacheKeyField(true);
        }

        public APIRequestGet requestCacheKeyField(boolean value) {
            this.requestField("cache_key", value);
            return this;
        }

        public APIRequestGet requestHeightField() {
            return this.requestHeightField(true);
        }

        public APIRequestGet requestHeightField(boolean value) {
            this.requestField("height", value);
            return this;
        }

        public APIRequestGet requestIsSilhouetteField() {
            return this.requestIsSilhouetteField(true);
        }

        public APIRequestGet requestIsSilhouetteField(boolean value) {
            this.requestField("is_silhouette", value);
            return this;
        }

        public APIRequestGet requestLeftField() {
            return this.requestLeftField(true);
        }

        public APIRequestGet requestLeftField(boolean value) {
            this.requestField("left", value);
            return this;
        }

        public APIRequestGet requestRightField() {
            return this.requestRightField(true);
        }

        public APIRequestGet requestRightField(boolean value) {
            this.requestField("right", value);
            return this;
        }

        public APIRequestGet requestTopField() {
            return this.requestTopField(true);
        }

        public APIRequestGet requestTopField(boolean value) {
            this.requestField("top", value);
            return this;
        }

        public APIRequestGet requestUriField() {
            return this.requestUriField(true);
        }

        public APIRequestGet requestUriField(boolean value) {
            this.requestField("uri", value);
            return this;
        }

        public APIRequestGet requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGet requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }

        public APIRequestGet requestWidthField() {
            return this.requestWidthField(true);
        }

        public APIRequestGet requestWidthField(boolean value) {
            this.requestField("width", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

